/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.engine;

import com.intellij.openapi.util.text.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.engine.ProcessBasedScriptEngineKt;
import org.jetbrains.kotlin.js.engine.ScriptEngine;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/engine/ProcessBasedScriptEngine;", "Lorg/jetbrains/kotlin/js/engine/ScriptEngine;", "executablePath", "", "(Ljava/lang/String;)V", "buffer", "", "process", "Ljava/lang/Process;", "eval", "script", "getOrCreateProcess", "loadFile", "", "path", "release", "reset", "restoreGlobalState", "saveGlobalState", "js.engines"})
public abstract class ProcessBasedScriptEngine
implements ScriptEngine {
    @NotNull
    private final String executablePath;
    @Nullable
    private Process process;
    @NotNull
    private final byte[] buffer;

    public ProcessBasedScriptEngine(@NotNull String executablePath) {
        Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
        this.executablePath = executablePath;
        this.buffer = new byte[1024];
    }

    @Override
    @NotNull
    public String eval(@NotNull String script) {
        String s;
        boolean bl;
        int n;
        byte[] byArray;
        int count;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Process vm = this.getOrCreateProcess();
        OutputStream stdin = vm.getOutputStream();
        InputStream stdout = vm.getInputStream();
        InputStream stderr = vm.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)stdin, (String)"stdin");
        OutputStream outputStream = stdin;
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        writer.write(Intrinsics.stringPlus((String)StringUtil.convertLineSeparators((String)script, (String)"\\n"), (Object)"\n"));
        writer.flush();
        StringBuilder out = new StringBuilder();
        while (vm.isAlive()) {
            int n2 = stdout.available();
            if (n2 == 0) continue;
            count = stdout.read(this.buffer);
            byArray = this.buffer;
            n = 0;
            bl = false;
            s = new String(byArray, n, count, Charsets.UTF_8);
            out.append(s);
            if (!StringsKt.endsWith$default((CharSequence)out, (CharSequence)ProcessBasedScriptEngineKt.access$getEND_MARKER$p(), (boolean)false, (int)2, null)) continue;
        }
        if (stderr.available() > 0) {
            StringBuilder err = new StringBuilder();
            while (vm.isAlive() && stderr.available() > 0) {
                count = stderr.read(this.buffer);
                byArray = this.buffer;
                n = 0;
                bl = false;
                s = new String(byArray, n, count, Charsets.UTF_8);
                err.append(s);
            }
            String string = "ERROR:\n" + err + "\nOUTPUT:\n" + out;
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Object)StringsKt.removeSuffix((CharSequence)StringsKt.removeSuffix((CharSequence)out, (CharSequence)ProcessBasedScriptEngineKt.access$getEND_MARKER$p()), (CharSequence)ProcessBasedScriptEngineKt.access$getLINE_SEPARATOR$p())).toString();
    }

    @Override
    public void loadFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.eval("load('" + StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null) + "');");
    }

    @Override
    public void reset() {
        this.eval("!reset");
    }

    @Override
    public void saveGlobalState() {
        this.eval("!saveGlobalState");
    }

    @Override
    public void restoreGlobalState() {
        this.eval("!restoreGlobalState");
    }

    @Override
    public void release() {
        Process process = this.process;
        if (process != null) {
            process.destroy();
        }
        this.process = null;
    }

    private final Process getOrCreateProcess() {
        Process p = this.process;
        if (p != null && p.isAlive()) {
            return p;
        }
        this.process = null;
        Object object = new String[]{this.executablePath, "js/js.engines/src/org/jetbrains/kotlin/js/engine/repl.js"};
        ProcessBuilder builder = new ProcessBuilder((String)object);
        Process process = builder.start();
        boolean bl = false;
        boolean bl2 = false;
        Process it = process;
        boolean bl3 = false;
        this.process = it;
        object = process;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.start().also {\n \u2026   process = it\n        }");
        return object;
    }
}

