/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirReservedUnderscoreCheckersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.stubs.elements.KtParameterElementType;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a@\u0010\u0004\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\u0001H\u0002\u001a*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0002\u00a8\u0006\u0010"}, d2={"isUnderscore", "", "text", "", "reportIfUnderscore", "", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isSingleUnderscoreAllowed", "isExpression", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkers"})
public final class FirReservedUnderscoreCheckersKt {
    private static final void reportIfUnderscore(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, boolean isSingleUnderscoreAllowed) {
        Object object;
        Object object2;
        FirSourceElement source = declaration2.getSource();
        Object object3 = source;
        if (object3 instanceof FirPsiSourceElement) {
            Object object4 = ((FirPsiSourceElement)source).getPsi();
            Object object5 = object2 = object4 instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)object4 : null;
            object = object2 == null ? null : ((object4 = object2.getNameIdentifier()) == null ? null : object4.getText());
        } else {
            object = object3 instanceof FirLightSourceElement ? ((object2 = LightTreePositioningStrategiesKt.nameIdentifier(((FirLightSourceElement)source).getTreeStructure(), ((FirLightSourceElement)source).getLighterASTNode())) == null ? null : object2.toString()) : null;
        }
        String rawIdentifier = object;
        FirReservedUnderscoreCheckersKt.reportIfUnderscore$default(rawIdentifier, source, context2, reporter, isSingleUnderscoreAllowed, false, 32, null);
        if (declaration2 instanceof FirValueParameter) {
            boolean isReport2;
            IElementType tokenType;
            Object psi;
            FirSourceElement returnTypeRefSource = ((FirValueParameter)declaration2).getReturnTypeRef().getSource();
            boolean bl = returnTypeRefSource instanceof FirPsiSourceElement ? !((psi = ((FirPsiSourceElement)returnTypeRefSource).getPsi()) instanceof KtFunctionLiteral) && !(psi instanceof KtParameter) : (returnTypeRefSource instanceof FirLightSourceElement ? !((tokenType = ((FirLightSourceElement)returnTypeRefSource).getLighterASTNode().getTokenType()) instanceof KtParameterElementType) && !Intrinsics.areEqual(tokenType, KtNodeTypes.CLASS) : (isReport2 = false));
            if (isReport2) {
                FirReservedUnderscoreCheckersKt.reportIfUnderscore$reportIfAnyDescendantIsUnderscore(source, reporter, context2, ((FirValueParameter)declaration2).getReturnTypeRef().getSource());
            }
        } else if (declaration2 instanceof FirFunction) {
            object3 = ((FirFunction)declaration2).getReceiverTypeRef();
            FirReservedUnderscoreCheckersKt.reportIfUnderscore$reportIfAnyDescendantIsUnderscore(source, reporter, context2, object3 == null ? null : ((FirTypeRef)object3).getSource());
        }
    }

    static /* synthetic */ void reportIfUnderscore$default(FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        FirReservedUnderscoreCheckersKt.reportIfUnderscore(firDeclaration, checkerContext, diagnosticReporter, bl);
    }

    private static final void reportIfUnderscore(CharSequence text2, FirSourceElement source, CheckerContext context2, DiagnosticReporter reporter, boolean isSingleUnderscoreAllowed, boolean isExpression) {
        if (text2 == null || isSingleUnderscoreAllowed && Intrinsics.areEqual(text2, "_")) {
            return;
        }
        if (FirReservedUnderscoreCheckersKt.isUnderscore(text2)) {
            DiagnosticReporterKt.reportOn(reporter, source, isExpression ? FirErrors.INSTANCE.getUNDERSCORE_USAGE_WITHOUT_BACKTICKS() : FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), context2);
        }
    }

    static /* synthetic */ void reportIfUnderscore$default(CharSequence charSequence, FirSourceElement firSourceElement, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        FirReservedUnderscoreCheckersKt.reportIfUnderscore(charSequence, firSourceElement, checkerContext, diagnosticReporter, bl, bl2);
    }

    private static final boolean isUnderscore(CharSequence text2) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = text2;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                if (it == '_') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void reportIfUnderscore$reportIfAnyDescendantIsUnderscore(FirSourceElement source, DiagnosticReporter $reporter, CheckerContext $context, FirSourceElement typeRefSource) {
        boolean bl;
        if (typeRefSource == null) {
            return;
        }
        FirSourceElement firSourceElement = typeRefSource;
        if (firSourceElement instanceof FirPsiSourceElement) {
            Object psi = ((FirPsiSourceElement)typeRefSource).getPsi();
            if (psi instanceof KtFunctionLiteral) return;
            Object p = psi;
            Function1 predicate$iv = reportIfUnderscore.reportIfAnyDescendantIsUnderscore.isReport.1.INSTANCE;
            boolean $i$f$anyDescendantOfType = false;
            Object $this$findDescendantOfType$iv$iv = p;
            boolean $i$f$findDescendantOfType = false;
            Object $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof LeafPsiElement && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            if ((PsiElement)result$iv$iv$iv.element == null) return;
            boolean bl2 = true;
            if (!bl2) return;
            bl = true;
        } else {
            if (!(firSourceElement instanceof FirLightSourceElement)) return;
            FirSourceElement firSourceElement2 = source;
            if (firSourceElement2 == null) {
                return;
            }
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = firSourceElement2.getTreeStructure();
            if (flyweightCapableTreeStructure == null) {
                return;
            }
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findFirstDescendant(flyweightCapableTreeStructure, ((FirLightSourceElement)typeRefSource).getLighterASTNode(), reportIfUnderscore.reportIfAnyDescendantIsUnderscore.isReport.2.INSTANCE);
            if (lighterASTNode2 == null) return;
            bl = true;
        }
        boolean isReport2 = bl;
        if (!isReport2) return;
        DiagnosticReporterKt.reportOn($reporter, typeRefSource, FirErrors.INSTANCE.getUNDERSCORE_USAGE_WITHOUT_BACKTICKS(), $context);
    }

    public static final /* synthetic */ void access$reportIfUnderscore(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, boolean isSingleUnderscoreAllowed) {
        FirReservedUnderscoreCheckersKt.reportIfUnderscore(declaration2, context2, reporter, isSingleUnderscoreAllowed);
    }

    public static final /* synthetic */ boolean access$isUnderscore(CharSequence text2) {
        return FirReservedUnderscoreCheckersKt.isUnderscore(text2);
    }
}

