/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.SubtypePathNode;
import org.jetbrains.kotlin.types.checker.TypeCheckerProcedureCallbacksImpl;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedureCallbacks;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\u0007H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"doesTypeParameterFormSelfType", "", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "selfConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "findCorrespondingSupertype", "Lorg/jetbrains/kotlin/types/KotlinType;", "subtype", "supertype", "typeCheckingProcedureCallbacks", "Lorg/jetbrains/kotlin/types/checker/TypeCheckingProcedureCallbacks;", "approximate", "debugInfo", "", "descriptors"})
public final class UtilsKt {
    @Nullable
    public static final KotlinType findCorrespondingSupertype(@NotNull KotlinType subtype, @NotNull KotlinType supertype2, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        Intrinsics.checkNotNullParameter(typeCheckingProcedureCallbacks, "typeCheckingProcedureCallbacks");
        ArrayDeque<SubtypePathNode> queue = new ArrayDeque<SubtypePathNode>();
        queue.add(new SubtypePathNode(subtype, null));
        TypeConstructor supertypeConstructor = supertype2.getConstructor();
        while (!queue.isEmpty()) {
            SubtypePathNode lastPathNode = (SubtypePathNode)queue.poll();
            KotlinType currentSubtype = lastPathNode.getType();
            TypeConstructor constructor2 = currentSubtype.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor2, supertypeConstructor)) {
                KotlinType substituted = currentSubtype;
                boolean isAnyMarkedNullable = currentSubtype.isMarkedNullable();
                for (SubtypePathNode currentPathNode = lastPathNode.getPrevious(); currentPathNode != null; currentPathNode = currentPathNode.getPrevious()) {
                    KotlinType kotlinType;
                    KotlinType kotlinType2;
                    boolean bl;
                    KotlinType currentType;
                    block10: {
                        currentType = currentPathNode.getType();
                        Iterable $this$any$iv = currentType.getArguments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                TypeProjection it = (TypeProjection)element$iv;
                                boolean bl2 = false;
                                if (!(it.getProjectionKind() != Variance.INVARIANT)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        kotlinType2 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(TypeConstructorSubstitution.Companion.create(currentType), false, 1, null).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT);
                        Intrinsics.checkNotNullExpressionValue(kotlinType2, "TypeConstructorSubstitution.create(currentType)\n                            .wrapWithCapturingSubstitution().buildSubstitutor()\n                            .safeSubstitute(substituted, Variance.INVARIANT)");
                        kotlinType = UtilsKt.approximate(kotlinType2);
                    } else {
                        kotlinType2 = TypeConstructorSubstitution.Companion.create(currentType).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT);
                        Intrinsics.checkNotNullExpressionValue(kotlinType2, "{\n                    TypeConstructorSubstitution.create(currentType)\n                            .buildSubstitutor()\n                            .safeSubstitute(substituted, Variance.INVARIANT)\n                }");
                        kotlinType = kotlinType2;
                    }
                    substituted = kotlinType;
                    isAnyMarkedNullable = isAnyMarkedNullable || currentType.isMarkedNullable();
                }
                TypeConstructor substitutedConstructor = substituted.getConstructor();
                if (!typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substitutedConstructor, supertypeConstructor)) {
                    throw new AssertionError((Object)("Type constructors should be equals!\nsubstitutedSuperType: " + UtilsKt.debugInfo(substitutedConstructor) + ", \n\nsupertype: " + UtilsKt.debugInfo(supertypeConstructor) + " \n" + typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substitutedConstructor, supertypeConstructor)));
                }
                return TypeUtils.makeNullableAsSpecified(substituted, isAnyMarkedNullable);
            }
            for (KotlinType immediateSupertype : constructor2.getSupertypes()) {
                Intrinsics.checkNotNullExpressionValue(immediateSupertype, "immediateSupertype");
                queue.add(new SubtypePathNode(immediateSupertype, lastPathNode));
            }
        }
        return null;
    }

    public static /* synthetic */ KotlinType findCorrespondingSupertype$default(KotlinType kotlinType, KotlinType kotlinType2, TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks, int n, Object object) {
        if ((n & 4) != 0) {
            typeCheckingProcedureCallbacks = new TypeCheckerProcedureCallbacksImpl();
        }
        return UtilsKt.findCorrespondingSupertype(kotlinType, kotlinType2, typeCheckingProcedureCallbacks);
    }

    private static final KotlinType approximate(KotlinType $this$approximate) {
        return CapturedTypeApproximationKt.approximateCapturedTypes($this$approximate).getUpper();
    }

    private static final String debugInfo(TypeConstructor $this$debugInfo) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$debugInfo_u24lambda_u2d1 = stringBuilder2;
        boolean bl5 = false;
        UtilsKt.debugInfo$lambda-1$unaryPlus(Intrinsics.stringPlus("type: ", $this$debugInfo), $this$debugInfo_u24lambda_u2d1);
        UtilsKt.debugInfo$lambda-1$unaryPlus(Intrinsics.stringPlus("hashCode: ", $this$debugInfo.hashCode()), $this$debugInfo_u24lambda_u2d1);
        UtilsKt.debugInfo$lambda-1$unaryPlus(Intrinsics.stringPlus("javaClass: ", $this$debugInfo.getClass().getCanonicalName()), $this$debugInfo_u24lambda_u2d1);
        for (DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)$this$debugInfo.getDeclarationDescriptor(); declarationDescriptor != null; declarationDescriptor = declarationDescriptor.getContainingDeclaration()) {
            UtilsKt.debugInfo$lambda-1$unaryPlus(Intrinsics.stringPlus("fqName: ", DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor)), $this$debugInfo_u24lambda_u2d1);
            UtilsKt.debugInfo$lambda-1$unaryPlus(Intrinsics.stringPlus("javaClass: ", declarationDescriptor.getClass().getCanonicalName()), $this$debugInfo_u24lambda_u2d1);
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static final boolean doesTypeParameterFormSelfType(@NotNull TypeParameterDescriptor typeParameter, @NotNull TypeConstructor selfConstructor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            Intrinsics.checkNotNullParameter(selfConstructor, "selfConstructor");
            List<KotlinType> list2 = typeParameter.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, "typeParameter.upperBounds");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType upperBound = (KotlinType)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(upperBound, "upperBound");
                    if (!(TypeUtilsKt.contains(upperBound, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>(typeParameter){
                        final /* synthetic */ TypeParameterDescriptor $typeParameter;
                        {
                            this.$typeParameter = $typeParameter;
                            super(1);
                        }

                        public final boolean invoke(@NotNull UnwrappedType it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return Intrinsics.areEqual(it.getConstructor(), this.$typeParameter.getTypeConstructor());
                        }
                    }) && Intrinsics.areEqual(upperBound.getConstructor(), selfConstructor))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final StringBuilder debugInfo$lambda-1$unaryPlus(String $this$debugInfo_u24lambda_u2d1_u24unaryPlus, StringBuilder $this_buildString) {
        Intrinsics.checkNotNullParameter($this$debugInfo_u24lambda_u2d1_u24unaryPlus, "<this>");
        StringBuilder stringBuilder2 = $this_buildString;
        boolean bl = false;
        StringBuilder stringBuilder3 = stringBuilder2.append($this$debugInfo_u24lambda_u2d1_u24unaryPlus);
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl2 = false;
        StringBuilder stringBuilder5 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append('\\n')");
        return stringBuilder5;
    }
}

