/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0003"}, d2={"kind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.serialization.common"})
public final class IrModuleDeserializerKt {
    @NotNull
    public static final BinarySymbolData.SymbolKind kind(@NotNull IrSymbol $this$kind) {
        BinarySymbolData.SymbolKind symbolKind;
        Intrinsics.checkNotNullParameter($this$kind, "<this>");
        IrSymbol irSymbol = $this$kind;
        if (irSymbol instanceof IrClassSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.CLASS_SYMBOL;
        } else if (irSymbol instanceof IrConstructorSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL;
        } else if (irSymbol instanceof IrSimpleFunctionSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
        } else if (irSymbol instanceof IrPropertySymbol) {
            symbolKind = BinarySymbolData.SymbolKind.PROPERTY_SYMBOL;
        } else if (irSymbol instanceof IrEnumEntrySymbol) {
            symbolKind = BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL;
        } else if (irSymbol instanceof IrTypeAliasSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL;
        } else {
            String string2 = Intrinsics.stringPlus("Unexpected symbol kind ", $this$kind);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return symbolKind;
    }
}

