/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.win;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.IntConsumer;
import org.jline.terminal.Cursor;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractWindowsTerminal;
import org.jline.terminal.impl.jna.win.Kernel32;
import org.jline.terminal.impl.jna.win.WindowsAnsiOutputStream;
import org.jline.utils.InfoCmp;

public class JnaWinSysTerminal
extends AbstractWindowsTerminal {
    private static final Pointer consoleIn = Kernel32.INSTANCE.GetStdHandle(-10);
    private static final Pointer consoleOut = Kernel32.INSTANCE.GetStdHandle(-11);
    private int prevButtonState;
    private char[] mouse = new char[]{'\u001b', '[', 'M', ' ', ' ', ' '};

    public JnaWinSysTerminal(String name, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super(new WindowsAnsiOutputStream(new FileOutputStream(FileDescriptor.out), consoleOut), name, nativeSignals, signalHandler);
        this.strings.put(InfoCmp.Capability.key_mouse, "\\E[M");
    }

    @Override
    protected int getConsoleOutputCP() {
        return Kernel32.INSTANCE.GetConsoleOutputCP();
    }

    @Override
    protected int getConsoleMode() {
        IntByReference mode = new IntByReference();
        Kernel32.INSTANCE.GetConsoleMode(consoleIn, mode);
        return mode.getValue();
    }

    @Override
    protected void setConsoleMode(int mode) {
        Kernel32.INSTANCE.SetConsoleMode(consoleIn, mode);
    }

    @Override
    public Size getSize() {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, info);
        return new Size(info.windowWidth(), info.windowHeight());
    }

    @Override
    protected byte[] readConsoleInput() throws IOException {
        Kernel32.INPUT_RECORD[] events = this.doReadConsoleInput();
        if (events == null) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder();
        for (Kernel32.INPUT_RECORD event : events) {
            if (event.EventType == 1) {
                boolean isAlt;
                Kernel32.KEY_EVENT_RECORD keyEvent = event.Event.KeyEvent;
                int altState = 3;
                int ctrlState = 12;
                boolean bl = isAlt = (keyEvent.dwControlKeyState & 3) != 0 && (keyEvent.dwControlKeyState & 0xC) == 0;
                if (keyEvent.bKeyDown) {
                    if (keyEvent.uChar.UnicodeChar > '\u0000') {
                        boolean shiftPressed;
                        boolean bl2 = shiftPressed = (keyEvent.dwControlKeyState & 0x10) != 0;
                        if (keyEvent.uChar.UnicodeChar == '\t' && shiftPressed) {
                            sb.append(this.getSequence(InfoCmp.Capability.key_btab));
                            continue;
                        }
                        if (isAlt) {
                            sb.append('\u001b');
                        }
                        sb.append(keyEvent.uChar.UnicodeChar);
                        continue;
                    }
                    String escapeSequence = this.getEscapeSequence(keyEvent.wVirtualKeyCode);
                    if (escapeSequence == null) continue;
                    for (int k = 0; k < keyEvent.wRepeatCount; ++k) {
                        if (isAlt) {
                            sb.append('\u001b');
                        }
                        sb.append(escapeSequence);
                    }
                    continue;
                }
                if (keyEvent.wVirtualKeyCode != 18 || keyEvent.uChar.UnicodeChar <= '\u0000') continue;
                sb.append(keyEvent.uChar.UnicodeChar);
                continue;
            }
            if (event.EventType == 4) {
                this.raise(Terminal.Signal.WINCH);
                continue;
            }
            if (event.EventType != 2) continue;
            Kernel32.MOUSE_EVENT_RECORD mouseEvent = event.Event.MouseEvent;
            int dwEventFlags = mouseEvent.dwEventFlags;
            int dwButtonState = mouseEvent.dwButtonState;
            if (this.tracking == Terminal.MouseTracking.Off || this.tracking == Terminal.MouseTracking.Normal && dwEventFlags == 1 || this.tracking == Terminal.MouseTracking.Button && dwEventFlags == 1 && dwButtonState == 0) continue;
            int cb = 0;
            if ((dwEventFlags &= 0xFFFFFFFD) == 4) {
                cb |= 0x40;
                if (dwButtonState >> 16 < 0) {
                    cb |= 1;
                }
            } else {
                if (dwEventFlags == 8) continue;
                cb = (dwButtonState & 1) != 0 ? (cb |= 0) : ((dwButtonState & 2) != 0 ? (cb |= 1) : ((dwButtonState & 4) != 0 ? (cb |= 2) : (cb |= 3)));
            }
            short cx = mouseEvent.dwMousePosition.X;
            short cy = mouseEvent.dwMousePosition.Y;
            this.mouse[3] = (char)(32 + cb);
            this.mouse[4] = (char)(32 + cx + 1);
            this.mouse[5] = (char)(32 + cy + 1);
            sb.append(this.mouse);
            this.prevButtonState = dwButtonState;
        }
        return sb.toString().getBytes();
    }

    private Kernel32.INPUT_RECORD[] doReadConsoleInput() throws IOException {
        Kernel32.INPUT_RECORD[] ir2 = new Kernel32.INPUT_RECORD[1];
        IntByReference r = new IntByReference();
        Kernel32.INSTANCE.ReadConsoleInput(consoleIn, ir2, ir2.length, r);
        for (int i = 0; i < r.getValue(); ++i) {
            switch (ir2[i].EventType) {
                case 1: 
                case 2: 
                case 4: {
                    return ir2;
                }
            }
        }
        return null;
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, info);
        return new Cursor(info.dwCursorPosition.X, info.dwCursorPosition.Y);
    }
}

