/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.resolvedCallUtil;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\n\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f*\u0006\u0012\u0002\b\u00030\n\u001a\u000e\u0010\u0010\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n\u001a\u001c\u0010\u0012\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u0006\u0012\u0002\b\u00030\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a8\u0006\u0018"}, d2={"getArgumentByParameterIndex", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "index", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDispatchReceiverWithSmartCast", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getExplicitReceiverValue", "getImplicitReceiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "getImplicitReceivers", "", "hasBothReceivers", "", "hasSafeNullableReceiver", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "hasThisOrNoDispatchReceiver", "makeNullableTypeIfSafeReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "frontend"})
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(@NotNull ResolvedCall<?> $this$hasThisOrNoDispatchReceiver, @NotNull BindingContext context2) {
        KtExpression expression2;
        Intrinsics.checkNotNullParameter($this$hasThisOrNoDispatchReceiver, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ReceiverValue dispatchReceiverValue2 = $this$hasThisOrNoDispatchReceiver.getDispatchReceiver();
        if ($this$hasThisOrNoDispatchReceiver.getResultingDescriptor().getDispatchReceiverParameter() == null || dispatchReceiverValue2 == null) {
            return true;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        ReceiverValue receiverValue = dispatchReceiverValue2;
        if (receiverValue instanceof ImplicitReceiver) {
            dispatchReceiverDescriptor = ((ImplicitReceiver)dispatchReceiverValue2).getDeclarationDescriptor();
        } else if (receiverValue instanceof ClassValueReceiver) {
            dispatchReceiverDescriptor = ((ClassValueReceiver)dispatchReceiverValue2).getClassQualifier().getDescriptor();
        } else if (receiverValue instanceof ExpressionReceiver && (expression2 = KtPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue2).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression2).getInstanceReference());
        }
        receiverValue = $this$hasThisOrNoDispatchReceiver.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(receiverValue, "resultingDescriptor");
        return Intrinsics.areEqual(dispatchReceiverDescriptor, DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter((CallableDescriptor)((Object)receiverValue)));
    }

    @Nullable
    public static final ReceiverValue getExplicitReceiverValue(@NotNull ResolvedCall<?> $this$getExplicitReceiverValue) {
        ReceiverValue receiverValue;
        Intrinsics.checkNotNullParameter($this$getExplicitReceiverValue, "<this>");
        ExplicitReceiverKind explicitReceiverKind = $this$getExplicitReceiverValue.getExplicitReceiverKind();
        int n = WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()];
        switch (n) {
            case 1: {
                ReceiverValue receiverValue2 = $this$getExplicitReceiverValue.getDispatchReceiver();
                Intrinsics.checkNotNull(receiverValue2);
                receiverValue = receiverValue2;
                break;
            }
            case 2: 
            case 3: {
                ReceiverValue receiverValue3 = $this$getExplicitReceiverValue.getExtensionReceiver();
                Intrinsics.checkNotNull(receiverValue3);
                receiverValue = receiverValue3;
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    @Nullable
    public static final ImplicitReceiver getImplicitReceiverValue(@NotNull ResolvedCall<?> $this$getImplicitReceiverValue) {
        Intrinsics.checkNotNullParameter($this$getImplicitReceiverValue, "<this>");
        Object t = CollectionsKt.firstOrNull((Iterable)ResolvedCallUtilKt.getImplicitReceivers($this$getImplicitReceiverValue));
        return t instanceof ImplicitReceiver ? (ImplicitReceiver)t : null;
    }

    @NotNull
    public static final Collection<ReceiverValue> getImplicitReceivers(@NotNull ResolvedCall<?> $this$getImplicitReceivers) {
        Collection collection;
        Intrinsics.checkNotNullParameter($this$getImplicitReceivers, "<this>");
        ExplicitReceiverKind explicitReceiverKind = $this$getImplicitReceivers.getExplicitReceiverKind();
        int n = WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()];
        switch (n) {
            case 4: {
                ReceiverValue[] receiverValueArray = new ReceiverValue[]{$this$getImplicitReceivers.getExtensionReceiver(), $this$getImplicitReceivers.getDispatchReceiver()};
                collection = CollectionsKt.listOfNotNull(receiverValueArray);
                break;
            }
            case 1: {
                collection = CollectionsKt.listOfNotNull($this$getImplicitReceivers.getExtensionReceiver());
                break;
            }
            case 2: {
                collection = CollectionsKt.listOfNotNull($this$getImplicitReceivers.getDispatchReceiver());
                break;
            }
            case 3: {
                collection = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return collection;
    }

    private static final boolean hasSafeNullableReceiver(ResolvedCall<?> $this$hasSafeNullableReceiver, CallResolutionContext<?> context2) {
        DataFlowValue dataFlowValue2;
        Call call2 = $this$hasSafeNullableReceiver.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        if (!CallUtilKt.isSafeCall(call2)) {
            return false;
        }
        ReceiverValue receiverValue = ResolvedCallUtilKt.getExplicitReceiverValue($this$hasSafeNullableReceiver);
        if (receiverValue == null) {
            dataFlowValue2 = null;
        } else {
            ReceiverValue receiverValue2 = receiverValue;
            boolean bl = false;
            boolean bl2 = false;
            ReceiverValue it = receiverValue2;
            boolean bl3 = false;
            dataFlowValue2 = context2.dataFlowValueFactory.createDataFlowValue(it, (ResolutionContext)context2);
        }
        DataFlowValue dataFlowValue3 = dataFlowValue2;
        if (dataFlowValue3 == null) {
            return false;
        }
        DataFlowValue receiverValue3 = dataFlowValue3;
        return context2.dataFlowInfo.getStableNullability(receiverValue3).canBeNull();
    }

    @Nullable
    public static final KotlinType makeNullableTypeIfSafeReceiver(@NotNull ResolvedCall<?> $this$makeNullableTypeIfSafeReceiver, @Nullable KotlinType type2, @NotNull CallResolutionContext<?> context2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$makeNullableTypeIfSafeReceiver, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        KotlinType kotlinType2 = type2;
        if (kotlinType2 == null) {
            kotlinType = null;
        } else {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType3;
            boolean bl3 = false;
            kotlinType = TypeUtils.makeNullableIfNeeded(type2, ResolvedCallUtilKt.hasSafeNullableReceiver($this$makeNullableTypeIfSafeReceiver, context2));
        }
        return kotlinType;
    }

    public static final boolean hasBothReceivers(@NotNull ResolvedCall<?> $this$hasBothReceivers) {
        Intrinsics.checkNotNullParameter($this$hasBothReceivers, "<this>");
        return $this$hasBothReceivers.getDispatchReceiver() != null && $this$hasBothReceivers.getExtensionReceiver() != null;
    }

    @Nullable
    public static final ReceiverValue getDispatchReceiverWithSmartCast(@NotNull ResolvedCall<?> $this$getDispatchReceiverWithSmartCast) {
        Intrinsics.checkNotNullParameter($this$getDispatchReceiverWithSmartCast, "<this>");
        return SmartCastUtilKt.getReceiverValueWithSmartCast($this$getDispatchReceiverWithSmartCast.getDispatchReceiver(), $this$getDispatchReceiverWithSmartCast.getSmartCastDispatchReceiverType());
    }

    @NotNull
    public static final List<ValueArgument> getArgumentByParameterIndex(@NotNull KtCallElement $this$getArgumentByParameterIndex, int index2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getArgumentByParameterIndex, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$getArgumentByParameterIndex, context2);
        if (resolvedCall2 == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        Object object = resolvedCall3.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, "resolvedCall.resultingDescriptor.valueParameters");
        Object object2 = CollectionsKt.getOrNull(object, index2);
        if (object2 == null) {
            return CollectionsKt.emptyList();
        }
        ValueParameterDescriptor parameterToProcess = object2;
        object = resolvedCall3.getValueArguments().get(parameterToProcess);
        object2 = object == null ? null : object.getArguments();
        return object2 == null ? CollectionsKt.emptyList() : object2;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
            nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 3;
            nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

