/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core.resolve;

import java.util.Date;
import org.jetbrains.kotlin.org.apache.ivy.core.LogOptions;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.org.apache.ivy.util.ConfigurationUtils;
import org.jetbrains.kotlin.org.apache.ivy.util.filter.Filter;
import org.jetbrains.kotlin.org.apache.ivy.util.filter.FilterHelper;

public class ResolveOptions
extends LogOptions {
    public static final String[] RESOLVEMODES = new String[]{"default", "dynamic"};
    private String[] confs = new String[]{"*"};
    private String revision = null;
    private Date date = null;
    private boolean validate = true;
    private boolean useCacheOnly = false;
    private boolean transitive = true;
    private boolean download = true;
    private boolean outputReport = true;
    private Filter<Artifact> artifactFilter = FilterHelper.NO_FILTER;
    private String resolveMode;
    private String resolveId;
    private boolean refresh;
    private boolean checkIfChanged = false;

    public ResolveOptions() {
    }

    public ResolveOptions(ResolveOptions options) {
        super(options);
        this.confs = options.confs;
        this.revision = options.revision;
        this.date = options.date;
        this.validate = options.validate;
        this.refresh = options.refresh;
        this.useCacheOnly = options.useCacheOnly;
        this.transitive = options.transitive;
        this.download = options.download;
        this.outputReport = options.outputReport;
        this.resolveMode = options.resolveMode;
        this.artifactFilter = options.artifactFilter;
        this.resolveId = options.resolveId;
        this.checkIfChanged = options.checkIfChanged;
    }

    public Filter<Artifact> getArtifactFilter() {
        return this.artifactFilter;
    }

    public String getResolveMode() {
        return this.resolveMode;
    }

    public String[] getConfs(ModuleDescriptor md) {
        return ConfigurationUtils.replaceWildcards(this.confs, md);
    }

    public ResolveOptions setConfs(String[] confs) {
        this.confs = confs;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isDownload() {
        return this.download;
    }

    public ResolveOptions setDownload(boolean download) {
        this.download = download;
        return this;
    }

    public boolean isOutputReport() {
        return this.outputReport;
    }

    public ResolveOptions setOutputReport(boolean outputReport) {
        this.outputReport = outputReport;
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public ResolveOptions setTransitive(boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    public boolean isUseCacheOnly() {
        return this.useCacheOnly;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public ResolveOptions setValidate(boolean validate) {
        this.validate = validate;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public ResolveOptions setResolveId(String resolveId) {
        this.resolveId = resolveId;
        return this;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public boolean getCheckIfChanged() {
        return this.checkIfChanged;
    }

    public static String getDefaultResolveId(ModuleDescriptor md) {
        ModuleId module = md.getModuleRevisionId().getModuleId();
        return ResolveOptions.getDefaultResolveId(module);
    }

    public static String getDefaultResolveId(ModuleId moduleId) {
        return moduleId.getOrganisation() + "-" + moduleId.getName();
    }
}

