/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/LambdaWithSuspendModifierCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "hasFormOfSuspendModifierForLambda", "", "Lorg/jetbrains/kotlin/psi/Call;", "hasNoArgumentListButDanglingLambdas", "isInfixWithRightLambda", "referencedName", "", "frontend"})
public final class LambdaWithSuspendModifierCallChecker
implements CallChecker {
    @NotNull
    public static final LambdaWithSuspendModifierCallChecker INSTANCE = new LambdaWithSuspendModifierCallChecker();

    private LambdaWithSuspendModifierCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        String variableCalleeName;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "resolvedCall.call");
        Call call3 = call2;
        String calleeName = this.referencedName(call3);
        ResolvedCall<?> $this$safeAs$iv = resolvedCall2;
        boolean $i$f$safeAs = false;
        ResolvedCall<?> resolvedCall3 = $this$safeAs$iv;
        if (!(resolvedCall3 instanceof VariableAsFunctionResolvedCall)) {
            resolvedCall3 = null;
        }
        Object object3 = object2 = (object = (VariableAsFunctionResolvedCall)((Object)resolvedCall3)) == null ? null : object.getVariableCall();
        String string2 = object2 == null ? null : (variableCalleeName = (object = object2.getCall()) == null ? null : this.referencedName((Call)object));
        if (!(Intrinsics.areEqual(calleeName, "suspend") || Intrinsics.areEqual(variableCalleeName, "suspend") || Intrinsics.areEqual(descriptor2.getName().asString(), "suspend"))) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(descriptor2, "descriptor");
        object2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)descriptor2);
        if (Intrinsics.areEqual(object2, SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            if (!Intrinsics.areEqual(calleeName, "suspend") || !this.hasFormOfSuspendModifierForLambda(call3) || call3.getExplicitReceiver() != null) {
                context2.getTrace().report(Errors.NON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND.on(reportOn));
            }
        } else if ((Intrinsics.areEqual(calleeName, "suspend") || Intrinsics.areEqual(variableCalleeName, "suspend")) && this.hasFormOfSuspendModifierForLambda(call3)) {
            context2.getTrace().report(Errors.MODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND.on(reportOn));
        }
    }

    private final boolean hasFormOfSuspendModifierForLambda(Call $this$hasFormOfSuspendModifierForLambda) {
        return !CallUtilKt.isCallableReference($this$hasFormOfSuspendModifierForLambda) && $this$hasFormOfSuspendModifierForLambda.getTypeArguments().isEmpty() && (this.hasNoArgumentListButDanglingLambdas($this$hasFormOfSuspendModifierForLambda) || this.isInfixWithRightLambda($this$hasFormOfSuspendModifierForLambda));
    }

    private final String referencedName(Call $this$referencedName) {
        String string2;
        KtExpression ktExpression = $this$referencedName.getCalleeExpression();
        if (ktExpression == null) {
            string2 = null;
        } else {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtExpression $this$safeAs$iv = ktExpression;
            boolean $i$f$safeAs = false;
            KtExpression ktExpression2 = $this$safeAs$iv;
            if (!(ktExpression2 instanceof KtSimpleNameExpression)) {
                ktExpression2 = null;
            }
            string2 = (ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression2) == null ? null : ktSimpleNameExpression.getReferencedName();
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNoArgumentListButDanglingLambdas(Call $this$hasNoArgumentListButDanglingLambdas) {
        Object object = $this$hasNoArgumentListButDanglingLambdas.getValueArgumentList();
        if ((object == null ? null : ((KtValueArgumentList)object).getLeftParenthesis()) != null) return false;
        object = $this$hasNoArgumentListButDanglingLambdas.getFunctionLiteralArguments();
        Intrinsics.checkNotNullExpressionValue(object, "functionLiteralArguments");
        object = (Collection)object;
        boolean bl = false;
        if (object.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixWithRightLambda(Call $this$isInfixWithRightLambda) {
        KtBinaryExpression ktBinaryExpression;
        if (!CallResolverUtilKt.isInfixCall($this$isInfixWithRightLambda)) return false;
        KtElement $this$safeAs$iv = $this$isInfixWithRightLambda.getCallElement();
        boolean $i$f$safeAs = false;
        KtElement ktElement = $this$safeAs$iv;
        if (!(ktElement instanceof KtBinaryExpression)) {
            ktElement = null;
        }
        if (!(((ktBinaryExpression = (KtBinaryExpression)ktElement) == null ? null : ktBinaryExpression.getRight()) instanceof KtLambdaExpression)) return false;
        return true;
    }
}

