/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.modules;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00102\u00020\u0001:\u0003\u0010\u0011\u0012B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "", "moduleName", "", "requires", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Requires;", "exports", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Exports;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getExports", "()Ljava/util/List;", "getModuleName", "()Ljava/lang/String;", "getRequires", "toString", "Companion", "Exports", "Requires", "frontend.java"})
public final class JavaModuleInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String moduleName;
    @NotNull
    private final List<Requires> requires;
    @NotNull
    private final List<Exports> exports;

    public JavaModuleInfo(@NotNull String moduleName, @NotNull List<Requires> requires, @NotNull List<Exports> exports) {
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(requires, "requires");
        Intrinsics.checkNotNullParameter(exports, "exports");
        this.moduleName = moduleName;
        this.requires = requires;
        this.exports = exports;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final List<Requires> getRequires() {
        return this.requires;
    }

    @NotNull
    public final List<Exports> getExports() {
        return this.exports;
    }

    @NotNull
    public String toString() {
        return "Module " + this.moduleName + " (" + this.requires.size() + " requires, " + this.exports.size() + " exports)";
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Requires;", "", "moduleName", "", "isTransitive", "", "(Ljava/lang/String;Z)V", "()Z", "getModuleName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "frontend.java"})
    public static final class Requires {
        @NotNull
        private final String moduleName;
        private final boolean isTransitive;

        public Requires(@NotNull String moduleName, boolean isTransitive) {
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            this.moduleName = moduleName;
            this.isTransitive = isTransitive;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        public final boolean isTransitive() {
            return this.isTransitive;
        }

        @NotNull
        public final String component1() {
            return this.moduleName;
        }

        public final boolean component2() {
            return this.isTransitive;
        }

        @NotNull
        public final Requires copy(@NotNull String moduleName, boolean isTransitive) {
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            return new Requires(moduleName, isTransitive);
        }

        public static /* synthetic */ Requires copy$default(Requires requires, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = requires.moduleName;
            }
            if ((n & 2) != 0) {
                bl = requires.isTransitive;
            }
            return requires.copy(string2, bl);
        }

        @NotNull
        public String toString() {
            return "Requires(moduleName=" + this.moduleName + ", isTransitive=" + this.isTransitive + ')';
        }

        public int hashCode() {
            int result2 = this.moduleName.hashCode();
            int n = this.isTransitive ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Requires)) {
                return false;
            }
            Requires requires = (Requires)other;
            if (!Intrinsics.areEqual(this.moduleName, requires.moduleName)) {
                return false;
            }
            return this.isTransitive == requires.isTransitive;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Exports;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "toModules", "", "", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getToModules", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "frontend.java"})
    public static final class Exports {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<String> toModules;

        public Exports(@NotNull FqName packageFqName, @NotNull List<String> toModules) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(toModules, "toModules");
            this.packageFqName = packageFqName;
            this.toModules = toModules;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final List<String> getToModules() {
            return this.toModules;
        }

        @NotNull
        public final FqName component1() {
            return this.packageFqName;
        }

        @NotNull
        public final List<String> component2() {
            return this.toModules;
        }

        @NotNull
        public final Exports copy(@NotNull FqName packageFqName, @NotNull List<String> toModules) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(toModules, "toModules");
            return new Exports(packageFqName, toModules);
        }

        public static /* synthetic */ Exports copy$default(Exports exports, FqName fqName2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = exports.packageFqName;
            }
            if ((n & 2) != 0) {
                list2 = exports.toModules;
            }
            return exports.copy(fqName2, list2);
        }

        @NotNull
        public String toString() {
            return "Exports(packageFqName=" + this.packageFqName + ", toModules=" + this.toModules + ')';
        }

        public int hashCode() {
            int result2 = this.packageFqName.hashCode();
            result2 = result2 * 31 + ((Object)this.toModules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Exports)) {
                return false;
            }
            Exports exports = (Exports)other;
            if (!Intrinsics.areEqual(this.packageFqName, exports.packageFqName)) {
                return false;
            }
            return Intrinsics.areEqual(this.toModules, exports.toModules);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "psiJavaModule", "Lcom/intellij/psi/PsiJavaModule;", "read", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaModuleInfo create(@NotNull PsiJavaModule psiJavaModule) {
            List list2;
            boolean bl;
            Object object;
            boolean bl2;
            boolean bl3;
            String string2;
            String string3;
            PsiStatement statement2;
            boolean bl4;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable<PsiPackageAccessibilityStatement> $this$mapNotNullTo$iv$iv;
            Iterable<PsiPackageAccessibilityStatement> $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(psiJavaModule, "psiJavaModule");
            Object object2 = psiJavaModule.getName();
            Intrinsics.checkNotNullExpressionValue(object2, "psiJavaModule.name");
            String string4 = object2;
            object2 = psiJavaModule.getRequires();
            Intrinsics.checkNotNullExpressionValue(object2, "psiJavaModule.requires");
            String string5 = string4;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable<PsiPackageAccessibilityStatement> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Requires requires;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl4 = false;
                statement2 = (PsiRequiresStatement)element$iv$iv;
                boolean bl5 = false;
                string3 = statement2.getModuleName();
                if (string3 == null) {
                    requires = null;
                } else {
                    string2 = string3;
                    bl3 = false;
                    bl2 = false;
                    String moduleName = string2;
                    boolean bl6 = false;
                    requires = new Requires(moduleName, statement2.hasModifierProperty("transitive"));
                }
                if (requires == null) continue;
                object = requires;
                boolean bl7 = false;
                bl = false;
                Requires it$iv$iv = object;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            $this$mapNotNull$iv = psiJavaModule.getExports();
            Intrinsics.checkNotNullExpressionValue($this$mapNotNull$iv, "psiJavaModule.exports");
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Exports exports;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl4 = false;
                statement2 = (PsiPackageAccessibilityStatement)element$iv$iv;
                boolean bl9 = false;
                string3 = statement2.getPackageName();
                if (string3 == null) {
                    exports = null;
                } else {
                    string2 = string3;
                    bl3 = false;
                    bl2 = false;
                    String packageName = string2;
                    boolean bl10 = false;
                    FqName fqName2 = new FqName(packageName);
                    object = statement2.getModuleNames();
                    Intrinsics.checkNotNullExpressionValue(object, "statement.moduleNames");
                    exports = new Exports(fqName2, (List<String>)object);
                }
                if (exports == null) continue;
                Exports exports2 = exports;
                bl = false;
                boolean bl11 = false;
                Exports it$iv$iv = exports2;
                boolean bl12 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list4 = list2 = (List)destination$iv$iv;
            List list5 = list3;
            String string6 = string5;
            return new JavaModuleInfo(string6, list5, list4);
        }

        @Nullable
        public final JavaModuleInfo read(@NotNull VirtualFile file2) {
            JavaModuleInfo javaModuleInfo;
            byte[] byArray;
            Intrinsics.checkNotNullParameter(file2, "file");
            try {
                byArray = file2.contentsToByteArray();
            }
            catch (IOException e) {
                return null;
            }
            byte[] contents = byArray;
            Ref.ObjectRef<String> moduleName = new Ref.ObjectRef<String>();
            boolean bl = false;
            ArrayList<Requires> requires = new ArrayList<Requires>();
            boolean bl2 = false;
            ArrayList<Exports> exports = new ArrayList<Exports>();
            try {
                new ClassReader(contents).accept(new ClassVisitor(moduleName, requires, exports){
                    final /* synthetic */ Ref.ObjectRef<String> $moduleName;
                    final /* synthetic */ ArrayList<Requires> $requires;
                    final /* synthetic */ ArrayList<Exports> $exports;
                    {
                        this.$moduleName = $moduleName;
                        this.$requires = $requires;
                        this.$exports = $exports;
                        super(524288);
                    }

                    @NotNull
                    public ModuleVisitor visitModule(@NotNull String name, int access, @Nullable String version) {
                        Intrinsics.checkNotNullParameter(name, "name");
                        this.$moduleName.element = name;
                        return new ModuleVisitor(this.$requires, this.$exports){
                            final /* synthetic */ ArrayList<Requires> $requires;
                            final /* synthetic */ ArrayList<Exports> $exports;
                            {
                                this.$requires = $requires;
                                this.$exports = $exports;
                                super(524288);
                            }

                            public void visitRequire(@NotNull String module2, int access, @Nullable String version) {
                                Intrinsics.checkNotNullParameter(module2, "module");
                                this.$requires.add(new Requires(module2, (access & 0x20) != 0));
                            }

                            public void visitExport(@NotNull String packageFqName, int access, @Nullable String[] modules) {
                                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                                FqName fqName2 = new FqName(StringsKt.replace$default(packageFqName, '/', '.', false, 4, null));
                                Object object = modules;
                                object = object == null ? null : ArraysKt.toList(object);
                                boolean bl = false;
                                Object object2 = object;
                                if (object == null) {
                                    object2 = kotlin.collections.CollectionsKt.emptyList();
                                }
                                this.$exports.add(new Exports(fqName2, (List<String>)object2));
                            }
                        };
                    }
                }, 7);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not load module definition from: " + file2 + ". The file might be broken by incorrect post-processing via bytecode tools. Please remove this file from the classpath.", e);
            }
            if (moduleName.element != null) {
                Intrinsics.checkNotNull(moduleName.element);
                javaModuleInfo = new JavaModuleInfo((String)moduleName.element, CollectionsKt.compact(requires), CollectionsKt.compact(exports));
            } else {
                javaModuleInfo = null;
            }
            return javaModuleInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

