/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004J@\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00042\u001e\b\u0002\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00040\u0014H\u0002J>\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00102\u001c\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0006H\u0082\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorEquivalenceForOverrides;", "", "()V", "areCallableDescriptorsEquivalent", "", "a", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "b", "allowCopiesFromTheSameDeclaration", "distinguishExpectsAndNonExpects", "ignoreReturnType", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "areClassesEquivalent", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "areEquivalent", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "areTypeParametersEquivalent", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "equivalentCallables", "Lkotlin/Function2;", "ownersEquivalent", "singleSource", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "descriptors"})
public final class DescriptorEquivalenceForOverrides {
    @NotNull
    public static final DescriptorEquivalenceForOverrides INSTANCE = new DescriptorEquivalenceForOverrides();

    private DescriptorEquivalenceForOverrides() {
    }

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a, @Nullable DeclarationDescriptor b, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects) {
        return a instanceof ClassDescriptor && b instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a, (ClassDescriptor)b) : (a instanceof TypeParameterDescriptor && b instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a, (TypeParameterDescriptor)b, allowCopiesFromTheSameDeclaration, null, 8, null) : (a instanceof CallableDescriptor && b instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a, (CallableDescriptor)b, allowCopiesFromTheSameDeclaration, distinguishExpectsAndNonExpects, false, KotlinTypeRefiner.Default.INSTANCE, 16, null) : (a instanceof PackageFragmentDescriptor && b instanceof PackageFragmentDescriptor ? Intrinsics.areEqual(((PackageFragmentDescriptor)a).getFqName(), ((PackageFragmentDescriptor)b).getFqName()) : Intrinsics.areEqual(a, b))));
    }

    public static /* synthetic */ boolean areEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return descriptorEquivalenceForOverrides.areEquivalent(declarationDescriptor, declarationDescriptor2, bl, bl2);
    }

    private final boolean areClassesEquivalent(ClassDescriptor a, ClassDescriptor b) {
        return Intrinsics.areEqual(a.getTypeConstructor(), b.getTypeConstructor());
    }

    private final boolean areTypeParametersEquivalent(TypeParameterDescriptor a, TypeParameterDescriptor b, boolean allowCopiesFromTheSameDeclaration, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        if (Intrinsics.areEqual(a, b)) {
            return true;
        }
        if (Intrinsics.areEqual(a.getContainingDeclaration(), b.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, equivalentCallables, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        return a.getIndex() == b.getIndex();
    }

    static /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, bl, function2);
    }

    private final SourceElement singleSource(CallableDescriptor $this$singleSource) {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides = this;
        CallableDescriptor callableDescriptor = $this$singleSource;
        while (true) {
            DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides2 = descriptorEquivalenceForOverrides;
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (!(callableDescriptor2 instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)callableDescriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return callableDescriptor2.getSource();
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)callableDescriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "overriddenDescriptors");
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (callableMemberDescriptor == null) break;
            descriptorEquivalenceForOverrides = descriptorEquivalenceForOverrides2;
            callableDescriptor = callableMemberDescriptor;
        }
        return null;
    }

    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a, @NotNull CallableDescriptor b, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects, boolean ignoreReturnType, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        if (Intrinsics.areEqual(a, b)) {
            return true;
        }
        if (!Intrinsics.areEqual(a.getName(), b.getName())) {
            return false;
        }
        if (distinguishExpectsAndNonExpects && a instanceof MemberDescriptor && b instanceof MemberDescriptor && ((MemberDescriptor)((Object)a)).isExpect() != ((MemberDescriptor)((Object)b)).isExpect()) {
            return false;
        }
        if (Intrinsics.areEqual(a.getContainingDeclaration(), b.getContainingDeclaration())) {
            if (!allowCopiesFromTheSameDeclaration) {
                return false;
            }
            if (!Intrinsics.areEqual(this.singleSource(a), this.singleSource(b))) {
                return false;
            }
        }
        if (DescriptorUtils.isLocal(a) || DescriptorUtils.isLocal(b)) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, areCallableDescriptorsEquivalent.1.INSTANCE, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        OverridingUtil overridingUtil2 = OverridingUtil.create(kotlinTypeRefiner, new KotlinTypeChecker.TypeConstructorEquality(this, allowCopiesFromTheSameDeclaration, a, b){
            final /* synthetic */ DescriptorEquivalenceForOverrides this$0;
            final /* synthetic */ boolean $allowCopiesFromTheSameDeclaration;
            final /* synthetic */ CallableDescriptor $a;
            final /* synthetic */ CallableDescriptor $b;
            {
                this.this$0 = $receiver;
                this.$allowCopiesFromTheSameDeclaration = $allowCopiesFromTheSameDeclaration;
                this.$a = $a;
                this.$b = $b;
            }

            public final boolean equals(@NotNull TypeConstructor c1, @NotNull TypeConstructor c2) {
                Intrinsics.checkNotNullParameter(c1, "c1");
                Intrinsics.checkNotNullParameter(c2, "c2");
                if (Intrinsics.areEqual(c1, c2)) {
                    return true;
                }
                ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
                ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
                if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
                    return false;
                }
                return DescriptorEquivalenceForOverrides.access$areTypeParametersEquivalent(this.this$0, (TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, this.$allowCopiesFromTheSameDeclaration, new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>(this.$a, this.$b){
                    final /* synthetic */ CallableDescriptor $a;
                    final /* synthetic */ CallableDescriptor $b;
                    {
                        this.$a = $a;
                        this.$b = $b;
                        super(2);
                    }

                    public final boolean invoke(@Nullable DeclarationDescriptor x, @Nullable DeclarationDescriptor y) {
                        return Intrinsics.areEqual(x, this.$a) && Intrinsics.areEqual(y, this.$b);
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue(overridingUtil2, "fun areCallableDescriptorsEquivalent(\n        a: CallableDescriptor,\n        b: CallableDescriptor,\n        allowCopiesFromTheSameDeclaration: Boolean,\n        distinguishExpectsAndNonExpects: Boolean = true,\n        ignoreReturnType: Boolean = false,\n        kotlinTypeRefiner: KotlinTypeRefiner\n    ): Boolean {\n        if (a == b) return true\n        if (a.name != b.name) return false\n        if (distinguishExpectsAndNonExpects && a is MemberDescriptor && b is MemberDescriptor && a.isExpect != b.isExpect) return false\n        if (a.containingDeclaration == b.containingDeclaration) {\n            if (!allowCopiesFromTheSameDeclaration) return false\n            if (a.singleSource() != b.singleSource()) return false\n        }\n\n        // Distinct locals are not equivalent\n        if (DescriptorUtils.isLocal(a) || DescriptorUtils.isLocal(b)) return false\n\n        if (!ownersEquivalent(a, b, { _, _ -> false }, allowCopiesFromTheSameDeclaration)) return false\n\n        val overridingUtil = OverridingUtil.create(kotlinTypeRefiner) eq@{ c1, c2 ->\n            if (c1 == c2) return@eq true\n\n            val d1 = c1.declarationDescriptor\n            val d2 = c2.declarationDescriptor\n\n            if (d1 !is TypeParameterDescriptor || d2 !is TypeParameterDescriptor) return@eq false\n\n            areTypeParametersEquivalent(d1, d2, allowCopiesFromTheSameDeclaration) { x, y -> x == a && y == b }\n        }\n\n        return overridingUtil.isOverridableBy(a, b, null, !ignoreReturnType).result == OverrideCompatibilityInfo.Result.OVERRIDABLE\n                && overridingUtil.isOverridableBy(b, a, null, !ignoreReturnType).result == OverrideCompatibilityInfo.Result.OVERRIDABLE\n\n    }");
        OverridingUtil overridingUtil3 = overridingUtil2;
        return overridingUtil3.isOverridableBy(a, b, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && overridingUtil3.isOverridableBy(b, a, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    public static /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner kotlinTypeRefiner, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl, bl2, bl3, kotlinTypeRefiner);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a, DeclarationDescriptor b, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables, boolean allowCopiesFromTheSameDeclaration) {
        DeclarationDescriptor aOwner = a.getContainingDeclaration();
        DeclarationDescriptor bOwner = b.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? equivalentCallables.invoke(aOwner, bOwner) : DescriptorEquivalenceForOverrides.areEquivalent$default(this, aOwner, bOwner, allowCopiesFromTheSameDeclaration, false, 8, null);
    }

    public static final /* synthetic */ boolean access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides $this, TypeParameterDescriptor a, TypeParameterDescriptor b, boolean allowCopiesFromTheSameDeclaration, Function2 equivalentCallables) {
        return $this.areTypeParametersEquivalent(a, b, allowCopiesFromTheSameDeclaration, equivalentCallables);
    }
}

