/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.builder.FirResolvedContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.contracts.description.ConeBinaryLogicExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanValueParameterReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConditionalEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsNullPredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeLogicalNot;
import org.jetbrains.kotlin.fir.contracts.description.ConeReturnsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeValueParameterReference;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.deserialization.FirContractDeserializer$WhenMappings;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0007\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0007\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010 \u001a\u00020!*\u00020\bH\u0002J\u0014\u0010\"\u001a\u00020\u0006*\u00020\u00062\u0006\u0010#\u001a\u00020!H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010%*\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer;", "", "c", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "(Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)V", "extractPrimitiveExpression", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBooleanExpression;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression;", "primitiveType", "Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$PrimitiveExpressionType;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;", "extractType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "extractVariable", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeValueParameterReference;", "getComplexType", "Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$ComplexExpressionType;", "getPrimitiveType", "loadConstant", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConstantReference;", "value", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "loadContract", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "loadExpression", "loadPossiblyConditionalEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeEffectDeclaration;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect;", "loadSimpleEffect", "hasType", "", "invertIfNecessary", "shouldInvert", "toDescriptorInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "ComplexExpressionType", "PrimitiveExpressionType", "fir-deserialization"})
public final class FirContractDeserializer {
    private final FirDeserializationContext c;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirContractDescription loadContract(@NotNull ProtoBuf.Contract proto, @NotNull FirContractDescriptionOwner owner) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(owner, "owner");
        List<ProtoBuf.Effect> list2 = proto.getEffectList();
        Intrinsics.checkNotNullExpressionValue(list2, "proto.effectList");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ConeEffectDeclaration coneEffectDeclaration;
            void it;
            object = (ProtoBuf.Effect)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue(v1, "it");
            if (this.loadPossiblyConditionalEffect((ProtoBuf.Effect)v1, owner) == null) {
                return null;
            }
            collection.add(coneEffectDeclaration);
        }
        List effects = (List)destination$iv$iv;
        boolean $i$f$buildResolvedContractDescription = false;
        boolean bl = false;
        FirResolvedContractDescriptionBuilder firResolvedContractDescriptionBuilder = new FirResolvedContractDescriptionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirResolvedContractDescriptionBuilder $this$buildResolvedContractDescription = firResolvedContractDescriptionBuilder;
        boolean bl4 = false;
        Collection collection = $this$buildResolvedContractDescription.getEffects();
        Iterable $this$map$iv2 = effects;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeEffectDeclaration coneEffectDeclaration = (ConeEffectDeclaration)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl5 = false;
            FirEffectDeclaration firEffectDeclaration = ContractUtilsKt.toFirEffectDeclaration$default((ConeEffectDeclaration)it, null, 1, null);
            collection2.add(firEffectDeclaration);
        }
        object = (List)destination$iv$iv2;
        boolean bl6 = false;
        kotlin.collections.CollectionsKt.addAll(collection, object);
        return firResolvedContractDescriptionBuilder.build();
    }

    private final ConeEffectDeclaration loadPossiblyConditionalEffect(ProtoBuf.Effect proto, FirContractDescriptionOwner owner) {
        if (proto.hasConclusionOfConditionalEffect()) {
            ProtoBuf.Expression expression2 = proto.getConclusionOfConditionalEffect();
            Intrinsics.checkNotNullExpressionValue(expression2, "proto.conclusionOfConditionalEffect");
            ConeBooleanExpression coneBooleanExpression = this.loadExpression(expression2, owner);
            if (coneBooleanExpression == null) {
                return null;
            }
            ConeBooleanExpression conclusion = coneBooleanExpression;
            ConeEffectDeclaration coneEffectDeclaration = this.loadSimpleEffect(proto, owner);
            if (coneEffectDeclaration == null) {
                return null;
            }
            ConeEffectDeclaration effect = coneEffectDeclaration;
            return new ConeConditionalEffectDeclaration(effect, conclusion);
        }
        return this.loadSimpleEffect(proto, owner);
    }

    private final ConeEffectDeclaration loadSimpleEffect(ProtoBuf.Effect proto, FirContractDescriptionOwner owner) {
        ConeEffectDeclaration coneEffectDeclaration;
        if (!proto.hasEffectType()) {
            return null;
        }
        ProtoBuf.Effect.EffectType effectType = proto.getEffectType();
        Intrinsics.checkNotNullExpressionValue(effectType, "if (proto.hasEffectType(\u2026fectType else return null");
        ProtoBuf.Effect.EffectType type2 = effectType;
        switch (FirContractDeserializer$WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                ConeConstantReference coneConstantReference;
                List<ProtoBuf.Expression> list2 = proto.getEffectConstructorArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, "proto.effectConstructorArgumentList");
                ProtoBuf.Expression argument = kotlin.collections.CollectionsKt.firstOrNull(list2);
                if (argument == null) {
                    coneConstantReference = ConeConstantReference.Companion.getWILDCARD();
                } else {
                    ConeBooleanExpression coneBooleanExpression = this.loadExpression(argument, owner);
                    if (!(coneBooleanExpression instanceof ConeConstantReference)) {
                        coneBooleanExpression = null;
                    }
                    if ((coneConstantReference = (ConeConstantReference)((Object)coneBooleanExpression)) == null) {
                        return null;
                    }
                }
                ConeConstantReference returnValue = coneConstantReference;
                coneEffectDeclaration = new ConeReturnsEffectDeclaration(returnValue);
                break;
            }
            case 2: {
                coneEffectDeclaration = new ConeReturnsEffectDeclaration(ConeConstantReference.Companion.getNOT_NULL());
                break;
            }
            case 3: {
                EventOccurrencesRange eventOccurrencesRange;
                List<ProtoBuf.Expression> list3 = proto.getEffectConstructorArgumentList();
                Intrinsics.checkNotNullExpressionValue(list3, "proto.effectConstructorArgumentList");
                ProtoBuf.Expression expression2 = kotlin.collections.CollectionsKt.firstOrNull(list3);
                if (expression2 == null) {
                    return null;
                }
                ProtoBuf.Expression argument = expression2;
                ConeValueParameterReference coneValueParameterReference = this.extractVariable(argument, owner);
                if (coneValueParameterReference == null) {
                    return null;
                }
                ConeValueParameterReference callable = coneValueParameterReference;
                if (proto.hasKind()) {
                    ProtoBuf.Effect.InvocationKind invocationKind = proto.getKind();
                    Intrinsics.checkNotNullExpressionValue(invocationKind, "proto.kind");
                    eventOccurrencesRange = this.toDescriptorInvocationKind(invocationKind);
                    if (eventOccurrencesRange == null) {
                        return null;
                    }
                } else {
                    eventOccurrencesRange = EventOccurrencesRange.UNKNOWN;
                }
                EventOccurrencesRange invocationKind = eventOccurrencesRange;
                coneEffectDeclaration = new ConeCallsEffectDeclaration(callable, invocationKind);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneEffectDeclaration;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final ConeBooleanExpression loadExpression(ProtoBuf.Expression proto, FirContractDescriptionOwner owner) {
        ConeBooleanExpression coneBooleanExpression;
        PrimitiveExpressionType primitiveType = this.getPrimitiveType(proto);
        ConeBooleanExpression primitiveExpression = this.extractPrimitiveExpression(proto, primitiveType, owner);
        ComplexExpressionType complexType = this.getComplexType(proto);
        boolean bl = false;
        List childs = new ArrayList();
        CollectionsKt.addIfNotNull(childs, primitiveExpression);
        ComplexExpressionType complexExpressionType = complexType;
        if (complexExpressionType != null) {
            switch (FirContractDeserializer$WhenMappings.$EnumSwitchMapping$1[complexExpressionType.ordinal()]) {
                case 1: {
                    ConeBooleanExpression it;
                    List<ProtoBuf.Expression> list2 = proto.getAndArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list2, "proto.andArgumentList");
                    Iterable $this$mapTo$iv = list2;
                    boolean $i$f$mapTo = false;
                    for (Object t : $this$mapTo$iv) {
                        ConeBooleanExpression coneBooleanExpression2;
                        ProtoBuf.Expression expression2 = (ProtoBuf.Expression)t;
                        Collection collection = childs;
                        boolean bl2 = false;
                        void v2 = it;
                        Intrinsics.checkNotNullExpressionValue(v2, "it");
                        if (this.loadExpression((ProtoBuf.Expression)v2, owner) == null) return null;
                        collection.add(coneBooleanExpression2);
                    }
                    Iterable $this$reduce$iv = childs;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object t = iterator$iv.next();
                    while (true) {
                        void booleanExpression;
                        void var10_16;
                        if (!iterator$iv.hasNext()) {
                            coneBooleanExpression = (ConeBooleanExpression)var10_16;
                            return coneBooleanExpression;
                        }
                        it = (ConeBooleanExpression)iterator$iv.next();
                        ConeBooleanExpression acc = (ConeBooleanExpression)var10_16;
                        boolean bl3 = false;
                        ConeBooleanExpression coneBooleanExpression3 = new ConeBinaryLogicExpression(acc, (ConeBooleanExpression)booleanExpression, LogicOperationKind.AND);
                    }
                }
                case 2: {
                    ConeBooleanExpression it;
                    ProtoBuf.Expression booleanExpression;
                    List<ProtoBuf.Expression> list3 = proto.getOrArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list3, "proto.orArgumentList");
                    Iterable $this$mapTo$iv = list3;
                    boolean $i$f$mapTo = false;
                    for (Object t : $this$mapTo$iv) {
                        ConeBooleanExpression coneBooleanExpression4;
                        booleanExpression = (ProtoBuf.Expression)t;
                        Collection collection = childs;
                        boolean bl4 = false;
                        void v5 = it;
                        Intrinsics.checkNotNullExpressionValue(v5, "it");
                        if (this.loadExpression((ProtoBuf.Expression)v5, owner) == null) return null;
                        collection.add(coneBooleanExpression4);
                    }
                    Iterable $this$reduce$iv = childs;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object t = iterator$iv.next();
                    while (true) {
                        void var10_20;
                        if (!iterator$iv.hasNext()) {
                            coneBooleanExpression = (ConeBooleanExpression)var10_20;
                            return coneBooleanExpression;
                        }
                        it = (ConeBooleanExpression)iterator$iv.next();
                        ConeBooleanExpression acc = (ConeBooleanExpression)var10_20;
                        boolean bl5 = false;
                        ConeBooleanExpression coneBooleanExpression5 = new ConeBinaryLogicExpression(acc, (ConeBooleanExpression)((Object)booleanExpression), LogicOperationKind.OR);
                    }
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        coneBooleanExpression = primitiveExpression;
        return coneBooleanExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ConeBooleanExpression extractPrimitiveExpression(ProtoBuf.Expression proto, PrimitiveExpressionType primitiveType, FirContractDescriptionOwner owner) {
        Boolean bl = Flags.IS_NEGATED.get(proto.getFlags());
        Intrinsics.checkNotNullExpressionValue(bl, "Flags.IS_NEGATED.get(proto.flags)");
        boolean isInverted = bl;
        PrimitiveExpressionType primitiveExpressionType = primitiveType;
        if (primitiveExpressionType == null) return null;
        switch (FirContractDeserializer$WhenMappings.$EnumSwitchMapping$2[primitiveExpressionType.ordinal()]) {
            case 1: 
            case 2: {
                ConeValueParameterReference coneValueParameterReference = this.extractVariable(proto, owner);
                if (!(coneValueParameterReference instanceof ConeBooleanValueParameterReference)) {
                    coneValueParameterReference = null;
                }
                ConeBooleanValueParameterReference coneBooleanValueParameterReference = (ConeBooleanValueParameterReference)coneValueParameterReference;
                if (coneBooleanValueParameterReference == null) return null;
                ConeBooleanExpression coneBooleanExpression = this.invertIfNecessary(coneBooleanValueParameterReference, isInverted);
                return coneBooleanExpression;
            }
            case 3: {
                ProtoBuf.Expression.ConstantValue constantValue = proto.getConstantValue();
                Intrinsics.checkNotNullExpressionValue(constantValue, "proto.constantValue");
                ConeConstantReference coneConstantReference = this.loadConstant(constantValue);
                if (!(coneConstantReference instanceof ConeBooleanConstantReference)) {
                    coneConstantReference = null;
                }
                ConeBooleanConstantReference coneBooleanConstantReference = (ConeBooleanConstantReference)coneConstantReference;
                if (coneBooleanConstantReference == null) return null;
                ConeBooleanExpression coneBooleanExpression = this.invertIfNecessary(coneBooleanConstantReference, isInverted);
                return coneBooleanExpression;
            }
            case 4: {
                ConeValueParameterReference coneValueParameterReference = this.extractVariable(proto, owner);
                if (coneValueParameterReference == null) return null;
                ConeValueParameterReference variable2 = coneValueParameterReference;
                ConeKotlinType coneKotlinType = this.extractType(proto);
                if (coneKotlinType == null) return null;
                ConeKotlinType type2 = coneKotlinType;
                ConeBooleanExpression coneBooleanExpression = new ConeIsInstancePredicate(variable2, type2, isInverted);
                return coneBooleanExpression;
            }
            case 5: {
                ConeValueParameterReference coneValueParameterReference = this.extractVariable(proto, owner);
                if (coneValueParameterReference == null) return null;
                ConeValueParameterReference variable3 = coneValueParameterReference;
                ConeBooleanExpression coneBooleanExpression = new ConeIsNullPredicate(variable3, isInverted);
                return coneBooleanExpression;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final ConeBooleanExpression invertIfNecessary(ConeBooleanExpression $this$invertIfNecessary, boolean shouldInvert) {
        return shouldInvert ? (ConeBooleanExpression)new ConeLogicalNot($this$invertIfNecessary) : $this$invertIfNecessary;
    }

    private final ConeValueParameterReference extractVariable(ProtoBuf.Expression proto, FirContractDescriptionOwner owner) {
        FirTypeRef firTypeRef;
        if (!proto.hasValueParameterReference()) {
            return null;
        }
        FirContractDescriptionOwner firContractDescriptionOwner = owner;
        if (firContractDescriptionOwner == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
        }
        FirSimpleFunction ownerFunction = (FirSimpleFunction)firContractDescriptionOwner;
        int valueParameterIndex = proto.getValueParameterReference() - 1;
        String name = null;
        if (valueParameterIndex < 0) {
            name = "this";
            firTypeRef = ownerFunction.getReceiverTypeRef();
        } else {
            FirValueParameter firValueParameter = kotlin.collections.CollectionsKt.getOrNull(ownerFunction.getValueParameters(), valueParameterIndex);
            if (firValueParameter == null) {
                return null;
            }
            FirValueParameter parameter = firValueParameter;
            String string2 = parameter.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "parameter.name.asString()");
            name = string2;
            firTypeRef = parameter.getReturnTypeRef();
        }
        if (firTypeRef == null) {
            return null;
        }
        FirTypeRef typeRef = firTypeRef;
        return !FirTypeUtilsKt.isBoolean(typeRef) ? new ConeValueParameterReference(valueParameterIndex, name) : (ConeValueParameterReference)new ConeBooleanValueParameterReference(valueParameterIndex, name);
    }

    private final EventOccurrencesRange toDescriptorInvocationKind(ProtoBuf.Effect.InvocationKind $this$toDescriptorInvocationKind) {
        EventOccurrencesRange eventOccurrencesRange;
        switch (FirContractDeserializer$WhenMappings.$EnumSwitchMapping$3[$this$toDescriptorInvocationKind.ordinal()]) {
            case 1: {
                eventOccurrencesRange = EventOccurrencesRange.AT_MOST_ONCE;
                break;
            }
            case 2: {
                eventOccurrencesRange = EventOccurrencesRange.EXACTLY_ONCE;
                break;
            }
            case 3: {
                eventOccurrencesRange = EventOccurrencesRange.AT_LEAST_ONCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return eventOccurrencesRange;
    }

    private final ConeKotlinType extractType(ProtoBuf.Expression proto) {
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.isInstanceType(proto, this.c.getTypeTable());
        if (type2 == null) {
            return null;
        }
        return this.c.getTypeDeserializer().type(type2, ConeAttributes.Companion.getEmpty());
    }

    private final ConeConstantReference loadConstant(ProtoBuf.Expression.ConstantValue value2) {
        ConeConstantReference coneConstantReference;
        switch (FirContractDeserializer$WhenMappings.$EnumSwitchMapping$4[value2.ordinal()]) {
            case 1: {
                coneConstantReference = ConeBooleanConstantReference.Companion.getTRUE();
                break;
            }
            case 2: {
                coneConstantReference = ConeBooleanConstantReference.Companion.getFALSE();
                break;
            }
            case 3: {
                coneConstantReference = ConeConstantReference.Companion.getNULL();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneConstantReference;
    }

    private final ComplexExpressionType getComplexType(ProtoBuf.Expression proto) {
        boolean isOrSequence = proto.getOrArgumentCount() != 0;
        boolean isAndSequence = proto.getAndArgumentCount() != 0;
        return isOrSequence && isAndSequence ? null : (isOrSequence ? ComplexExpressionType.OR_SEQUENCE : (isAndSequence ? ComplexExpressionType.AND_SEQUENCE : null));
    }

    private final PrimitiveExpressionType getPrimitiveType(ProtoBuf.Expression proto) {
        List expressionTypes;
        block6: {
            block7: {
                block5: {
                    boolean bl = false;
                    expressionTypes = new ArrayList();
                    if (proto.hasValueParameterReference() && this.hasType(proto)) {
                        expressionTypes.add(PrimitiveExpressionType.INSTANCE_CHECK);
                    } else if (proto.hasValueParameterReference()) {
                        Boolean bl2 = Flags.IS_NULL_CHECK_PREDICATE.get(proto.getFlags());
                        Intrinsics.checkNotNullExpressionValue(bl2, "Flags.IS_NULL_CHECK_PREDICATE.get(proto.flags)");
                        if (bl2.booleanValue()) {
                            expressionTypes.add(PrimitiveExpressionType.NULLABILITY_CHECK);
                        }
                    }
                    Collection collection = expressionTypes;
                    boolean bl3 = false;
                    if (!collection.isEmpty()) {
                        return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
                    }
                    if (!proto.hasValueParameterReference() || proto.getValueParameterReference() <= 0) break block5;
                    expressionTypes.add(PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE);
                    break block6;
                }
                if (!proto.hasValueParameterReference() || proto.getValueParameterReference() != 0) break block7;
                expressionTypes.add(PrimitiveExpressionType.RECEIVER_REFERENCE);
                break block6;
            }
            if (!proto.hasConstantValue()) break block6;
            expressionTypes.add(PrimitiveExpressionType.CONSTANT);
        }
        return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
    }

    private final boolean hasType(ProtoBuf.Expression $this$hasType) {
        return $this$hasType.hasIsInstanceType() || $this$hasType.hasIsInstanceTypeId();
    }

    public FirContractDeserializer(@NotNull FirDeserializationContext c) {
        Intrinsics.checkNotNullParameter(c, "c");
        this.c = c;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$PrimitiveExpressionType;", "", "(Ljava/lang/String;I)V", "VALUE_PARAMETER_REFERENCE", "RECEIVER_REFERENCE", "CONSTANT", "INSTANCE_CHECK", "NULLABILITY_CHECK", "fir-deserialization"})
    private static final class PrimitiveExpressionType
    extends Enum<PrimitiveExpressionType> {
        public static final /* enum */ PrimitiveExpressionType VALUE_PARAMETER_REFERENCE;
        public static final /* enum */ PrimitiveExpressionType RECEIVER_REFERENCE;
        public static final /* enum */ PrimitiveExpressionType CONSTANT;
        public static final /* enum */ PrimitiveExpressionType INSTANCE_CHECK;
        public static final /* enum */ PrimitiveExpressionType NULLABILITY_CHECK;
        private static final /* synthetic */ PrimitiveExpressionType[] $VALUES;

        static {
            PrimitiveExpressionType[] primitiveExpressionTypeArray = new PrimitiveExpressionType[5];
            PrimitiveExpressionType[] primitiveExpressionTypeArray2 = primitiveExpressionTypeArray;
            primitiveExpressionTypeArray[0] = VALUE_PARAMETER_REFERENCE = new PrimitiveExpressionType();
            primitiveExpressionTypeArray[1] = RECEIVER_REFERENCE = new PrimitiveExpressionType();
            primitiveExpressionTypeArray[2] = CONSTANT = new PrimitiveExpressionType();
            primitiveExpressionTypeArray[3] = INSTANCE_CHECK = new PrimitiveExpressionType();
            primitiveExpressionTypeArray[4] = NULLABILITY_CHECK = new PrimitiveExpressionType();
            $VALUES = primitiveExpressionTypeArray;
        }

        public static PrimitiveExpressionType[] values() {
            return (PrimitiveExpressionType[])$VALUES.clone();
        }

        public static PrimitiveExpressionType valueOf(String string2) {
            return Enum.valueOf(PrimitiveExpressionType.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$ComplexExpressionType;", "", "(Ljava/lang/String;I)V", "AND_SEQUENCE", "OR_SEQUENCE", "fir-deserialization"})
    private static final class ComplexExpressionType
    extends Enum<ComplexExpressionType> {
        public static final /* enum */ ComplexExpressionType AND_SEQUENCE;
        public static final /* enum */ ComplexExpressionType OR_SEQUENCE;
        private static final /* synthetic */ ComplexExpressionType[] $VALUES;

        static {
            ComplexExpressionType[] complexExpressionTypeArray = new ComplexExpressionType[2];
            ComplexExpressionType[] complexExpressionTypeArray2 = complexExpressionTypeArray;
            complexExpressionTypeArray[0] = AND_SEQUENCE = new ComplexExpressionType();
            complexExpressionTypeArray[1] = OR_SEQUENCE = new ComplexExpressionType();
            $VALUES = complexExpressionTypeArray;
        }

        public static ComplexExpressionType[] values() {
            return (ComplexExpressionType[])$VALUES.clone();
        }

        public static ComplexExpressionType valueOf(String string2) {
            return Enum.valueOf(ComplexExpressionType.class, string2);
        }
    }
}

