/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.optimizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.optimizations.FoldConstantLowering;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0003$%&B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J.\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010#\u001a\u00020\u0014*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "floatSpecial", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "buildIrConstant", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "v", "", "coerceToDouble", "irConst", "constToString", "", "const", "fromFloatConstSafe", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "tryFoldingBinaryOps", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "tryFoldingBuiltinBinaryOps", "tryFoldingUnaryOps", "typeConstructorName", "BinaryOp", "Companion", "PrimitiveType", "ir.backend.common"})
public final class FoldConstantLowering
extends IrElementTransformerVoid
implements BodyLoweringPass {
    private final CommonBackendContext context;
    private final boolean floatSpecial;
    private static final PrimitiveType<Integer> INT;
    private static final PrimitiveType<Long> LONG;
    private static final PrimitiveType<Double> DOUBLE;
    private static final PrimitiveType<Float> FLOAT;
    private static final HashMap<BinaryOp, Function2<Object, Object, Object>> BINARY_OP_TO_EVALUATOR;
    @NotNull
    public static final Companion Companion;

    private final IrConst<?> fromFloatConstSafe(int startOffset, int endOffset, IrType type2, Object v) {
        IrConstImpl<Number> irConstImpl;
        if (!this.floatSpecial) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConstImpl = IrConstImpl.Companion.float(startOffset, endOffset, type2, ((Number)object).floatValue());
        } else if (v instanceof Float) {
            irConstImpl = IrConstImpl.Companion.float(startOffset, endOffset, type2, ((Number)v).floatValue());
        } else if (v instanceof Double) {
            irConstImpl = IrConstImpl.Companion.double(startOffset, endOffset, type2, ((Number)v).doubleValue());
        } else {
            String string2 = "Unexpected constant type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return irConstImpl;
    }

    private final IrConst<?> buildIrConstant(int startOffset, int endOffset, IrType type2, Object v) {
        IrConst irConst;
        IrType constType = IrTypesKt.makeNotNull(type2);
        if (IrTypePredicatesKt.isInt(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)object).intValue());
        } else if (IrTypePredicatesKt.isChar(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
            }
            irConst = IrConstImpl.Companion.char(startOffset, endOffset, constType, ((Character)object).charValue());
        } else if (IrTypePredicatesKt.isBoolean(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            irConst = IrConstImpl.Companion.boolean(startOffset, endOffset, constType, (Boolean)object);
        } else if (IrTypePredicatesKt.isByte(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)object).byteValue());
        } else if (IrTypePredicatesKt.isShort(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)object).shortValue());
        } else if (IrTypePredicatesKt.isLong(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)object).longValue());
        } else if (IrTypePredicatesKt.isDouble(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.double(startOffset, endOffset, constType, ((Number)object).doubleValue());
        } else if (IrTypePredicatesKt.isFloat(constType)) {
            irConst = this.fromFloatConstSafe(startOffset, endOffset, type2, v);
        } else if (IrTypePredicatesKt.isString(constType)) {
            Object object = v;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            irConst = IrConstImpl.Companion.string(startOffset, endOffset, constType, (String)object);
        } else {
            throw (Throwable)new IllegalArgumentException("Unexpected IrCall return type");
        }
        return irConst;
    }

    private final IrExpression tryFoldingUnaryOps(IrCall call2) {
        Object object;
        IrExpression irExpression = call2.getDispatchReceiver();
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        if (irConst == null) {
            return call2;
        }
        IrConst operand = irConst;
        String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "call.symbol.owner.name.toString()");
        String operationName = string2;
        if (Intrinsics.areEqual(operationName, "toString")) {
            object = this.constToString(operand);
        } else {
            if (Intrinsics.areEqual(operationName, "toFloat") && this.floatSpecial) {
                return call2;
            }
            String string3 = operand.getKind().toString();
            Object t = operand.getValue();
            Intrinsics.checkNotNull(t);
            object = ConstantExpressionEvaluatorKt.evaluateUnary(operationName, string3, t);
            if (object == null) {
                return call2;
            }
        }
        String evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final IrConst<?> coerceToDouble(IrConst<?> irConst) {
        if (!this.floatSpecial) {
            return irConst;
        }
        if (Intrinsics.areEqual(irConst.getKind(), IrConstKind.Float.INSTANCE)) {
            IrConst<?> irConst2 = irConst;
            boolean bl = false;
            boolean bl2 = false;
            IrConst<?> $this$run = irConst2;
            boolean bl3 = false;
            String string2 = String.valueOf($this$run.getValue());
            boolean bl4 = false;
            return new IrConstImpl<Double>($this$run.getStartOffset(), $this$run.getEndOffset(), this.context.getIrBuiltIns().getDoubleType(), IrConstKind.Double.INSTANCE, Double.parseDouble(string2));
        }
        return irConst;
    }

    private final String typeConstructorName(IrType $this$typeConstructorName) {
        IrType irType = $this$typeConstructorName;
        if (irType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        }
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        boolean bl = false;
        boolean bl2 = false;
        IrSimpleType $this$with = irSimpleType;
        boolean bl3 = false;
        IrClassifierSymbol irClassifierSymbol = $this$with.getClassifier();
        if (irClassifierSymbol == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        }
        IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
        boolean bl4 = false;
        boolean bl5 = false;
        IrClassSymbol $this$with2 = irClassSymbol;
        boolean bl6 = false;
        String string2 = ((IrClass)$this$with2.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "owner.name.asString()");
        return string2;
    }

    private final IrExpression tryFoldingBinaryOps(IrCall call2) {
        Object object;
        IrExpression irExpression = call2.getDispatchReceiver();
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        if (irConst == null) {
            return call2;
        }
        IrConst<?> lhs = this.coerceToDouble(irConst);
        IrExpression irExpression2 = call2.getValueArgument(0);
        if (!(irExpression2 instanceof IrConst)) {
            irExpression2 = null;
        }
        IrConst irConst2 = (IrConst)irExpression2;
        if (irConst2 == null) {
            return call2;
        }
        IrConst<?> rhs = this.coerceToDouble(irConst2);
        try {
            String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "call.symbol.owner.name.toString()");
            String string3 = lhs.getKind().toString();
            Object obj = lhs.getValue();
            Intrinsics.checkNotNull(obj);
            String string4 = this.typeConstructorName(((IrSimpleFunction)call2.getSymbol().getOwner()).getValueParameters().get(0).getType());
            Object obj2 = rhs.getValue();
            Intrinsics.checkNotNull(obj2);
            Object object2 = ConstantExpressionEvaluatorKt.evaluateBinary(string2, string3, obj, string4, obj2);
            if (object2 == null) {
                return call2;
            }
            object = object2;
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final IrExpression tryFoldingBuiltinBinaryOps(IrCall call2) {
        Object object;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)call2.getSymbol().getOwner());
        if (Intrinsics.areEqual(fqName2 != null ? fqName2.parent() : null, IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN()) ^ true) {
            return call2;
        }
        IrExpression irExpression = call2.getValueArgument(0);
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        if (irConst == null) {
            return call2;
        }
        IrConst lhs = irConst;
        IrExpression irExpression2 = call2.getValueArgument(1);
        if (!(irExpression2 instanceof IrConst)) {
            irExpression2 = null;
        }
        IrConst irConst2 = (IrConst)irExpression2;
        if (irConst2 == null) {
            return call2;
        }
        IrConst rhs = irConst2;
        try {
            String string2 = lhs.getKind().toString();
            String string3 = rhs.getKind().toString();
            String string4 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
            Intrinsics.checkNotNullExpressionValue(string4, "call.symbol.owner.name.toString()");
            Function2<Object, Object, Object> function2 = BINARY_OP_TO_EVALUATOR.get(new BinaryOp(string2, string3, string4));
            if (function2 == null) {
                return call2;
            }
            Intrinsics.checkNotNullExpressionValue(function2, "BINARY_OP_TO_EVALUATOR[B\u2026String())] ?: return call");
            Function2<Object, Object, Object> evaluator = function2;
            Object t = lhs.getValue();
            Intrinsics.checkNotNull(t);
            Object t2 = rhs.getValue();
            Intrinsics.checkNotNull(t2);
            object = evaluator.invoke(t, t2);
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final String constToString(IrConst<?> irConst) {
        boolean bl;
        IrConstKind<?> kind;
        if (this.floatSpecial) {
            kind = irConst.getKind();
            if (kind instanceof IrConstKind.Float) {
                float f;
                float f2 = f = ((Number)((IrConstKind.Float)kind).valueOf(irConst)).floatValue();
                bl = false;
                if (!Float.isInfinite(f2)) {
                    boolean bl2 = false;
                    if ((float)Math.floor(f) == f) {
                        return String.valueOf((int)f);
                    }
                }
            } else if (kind instanceof IrConstKind.Double) {
                double d;
                double d2 = d = ((Number)((IrConstKind.Double)kind).valueOf(irConst)).doubleValue();
                boolean bl3 = false;
                if (!Double.isInfinite(d2)) {
                    bl = false;
                    if (Math.floor(d) == d) {
                        return String.valueOf((long)d);
                    }
                }
            }
        }
        if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
            kind = irConst.getKind();
            if (kind instanceof IrConstKind.Byte) {
                byte by = ((Number)((IrConstKind.Byte)kind).valueOf(irConst)).byteValue();
                boolean bl4 = false;
                return UByte.toString-impl(UByte.constructor-impl(by));
            }
            if (kind instanceof IrConstKind.Short) {
                short s = ((Number)((IrConstKind.Short)kind).valueOf(irConst)).shortValue();
                boolean bl5 = false;
                return UShort.toString-impl(UShort.constructor-impl(s));
            }
            if (kind instanceof IrConstKind.Int) {
                int n = ((Number)((IrConstKind.Int)kind).valueOf(irConst)).intValue();
                boolean bl6 = false;
                return Integer.toUnsignedString(UInt.constructor-impl(n));
            }
            if (kind instanceof IrConstKind.Long) {
                long l = ((Number)((IrConstKind.Long)kind).valueOf(irConst)).longValue();
                bl = false;
                return Long.toUnsignedString(ULong.constructor-impl(l));
            }
        }
        return String.valueOf(irConst.getValue());
    }

    @Override
    @ExperimentalUnsignedTypes
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ FoldConstantLowering this$0;

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                return expression2.getExtensionReceiver() != null ? (IrExpression)expression2 : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 0 ? FoldConstantLowering.access$tryFoldingUnaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 1 ? FoldConstantLowering.access$tryFoldingBinaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() == null && expression2.getValueArgumentsCount() == 2 ? FoldConstantLowering.access$tryFoldingBuiltinBinaryOps(this.this$0, expression2) : (IrExpression)expression2)));
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                boolean bl = false;
                List folded = new ArrayList<E>();
                for (IrExpression next : expression2.getArguments()) {
                    Collection collection;
                    IrExpression last = (IrExpression)CollectionsKt.lastOrNull(folded);
                    if (!(next instanceof IrConst)) {
                        collection = folded;
                        boolean bl2 = false;
                        collection.add(next);
                        continue;
                    }
                    if (!(last instanceof IrConst)) {
                        collection = folded;
                        IrConstImpl<String> irConstImpl = IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), FoldConstantLowering.access$getContext$p(this.this$0).getIrBuiltIns().getStringType(), FoldConstantLowering.access$constToString(this.this$0, (IrConst)next));
                        boolean bl3 = false;
                        collection.add(irConstImpl);
                        continue;
                    }
                    folded.set(folded.size() - 1, IrConstImpl.Companion.string(last.getStartOffset(), next.getEndOffset(), FoldConstantLowering.access$getContext$p(this.this$0).getIrBuiltIns().getStringType(), FoldConstantLowering.access$constToString(this.this$0, (IrConst)last) + FoldConstantLowering.access$constToString(this.this$0, (IrConst)next)));
                }
                T t = CollectionsKt.singleOrNull(folded);
                if (!(t instanceof IrConst)) {
                    t = null;
                }
                IrConst irConst = (IrConst)t;
                return irConst != null ? (IrExpression)irConst : (IrExpression)new IrStringConcatenationImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), folded);
            }

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                IrExpression argument = expression2.getArgument();
                return argument instanceof IrConst && expression2.getOperator() == IrTypeOperator.IMPLICIT_INTEGER_COERCION ? (IrExpression)FoldConstantLowering.access$buildIrConstant(this.this$0, expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), ((IrConst)argument).getValue()) : (IrExpression)expression2;
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public FoldConstantLowering(@NotNull CommonBackendContext context2, boolean floatSpecial) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.floatSpecial = floatSpecial;
    }

    public /* synthetic */ FoldConstantLowering(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    static {
        Companion = new Companion(null);
        INT = new PrimitiveType("Int");
        LONG = new PrimitiveType("Long");
        DOUBLE = new PrimitiveType("Double");
        FLOAT = new PrimitiveType("Float");
        BINARY_OP_TO_EVALUATOR = new HashMap();
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "less", Companion.1.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "lessOrEqual", Companion.2.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greater", Companion.3.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greaterOrEqual", Companion.4.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "ieee754equals", Companion.5.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "less", Companion.6.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "lessOrEqual", Companion.7.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greater", Companion.8.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greaterOrEqual", Companion.9.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "ieee754equals", Companion.10.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "less", Companion.11.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "lessOrEqual", Companion.12.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greater", Companion.13.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greaterOrEqual", Companion.14.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "EQEQ", Companion.15.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "less", Companion.16.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "lessOrEqual", Companion.17.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greater", Companion.18.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greaterOrEqual", Companion.19.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "EQEQ", Companion.20.INSTANCE);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingUnaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingUnaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBinaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBuiltinBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBuiltinBinaryOps(call2);
    }

    public static final /* synthetic */ CommonBackendContext access$getContext$p(FoldConstantLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$constToString(FoldConstantLowering $this, IrConst irConst) {
        return $this.constToString(irConst);
    }

    public static final /* synthetic */ IrConst access$buildIrConstant(FoldConstantLowering $this, int startOffset, int endOffset, IrType type2, Object v) {
        return $this.buildIrConstant(startOffset, endOffset, type2, v);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$BinaryOp;", "", "lhsType", "", "rhsType", "operatorName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLhsType", "()Ljava/lang/String;", "getOperatorName", "getRhsType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.backend.common"})
    private static final class BinaryOp {
        private final String lhsType;
        private final String rhsType;
        private final String operatorName;

        @NotNull
        public final String getLhsType() {
            return this.lhsType;
        }

        @NotNull
        public final String getRhsType() {
            return this.rhsType;
        }

        @NotNull
        public final String getOperatorName() {
            return this.operatorName;
        }

        public BinaryOp(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkNotNullParameter(lhsType, "lhsType");
            Intrinsics.checkNotNullParameter(rhsType, "rhsType");
            Intrinsics.checkNotNullParameter(operatorName, "operatorName");
            this.lhsType = lhsType;
            this.rhsType = rhsType;
            this.operatorName = operatorName;
        }

        @NotNull
        public final String component1() {
            return this.lhsType;
        }

        @NotNull
        public final String component2() {
            return this.rhsType;
        }

        @NotNull
        public final String component3() {
            return this.operatorName;
        }

        @NotNull
        public final BinaryOp copy(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkNotNullParameter(lhsType, "lhsType");
            Intrinsics.checkNotNullParameter(rhsType, "rhsType");
            Intrinsics.checkNotNullParameter(operatorName, "operatorName");
            return new BinaryOp(lhsType, rhsType, operatorName);
        }

        public static /* synthetic */ BinaryOp copy$default(BinaryOp binaryOp, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = binaryOp.lhsType;
            }
            if ((n & 2) != 0) {
                string3 = binaryOp.rhsType;
            }
            if ((n & 4) != 0) {
                string4 = binaryOp.operatorName;
            }
            return binaryOp.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "BinaryOp(lhsType=" + this.lhsType + ", rhsType=" + this.rhsType + ", operatorName=" + this.operatorName + ")";
        }

        public int hashCode() {
            String string2 = this.lhsType;
            String string3 = this.rhsType;
            String string4 = this.operatorName;
            return ((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BinaryOp)) break block3;
                    BinaryOp binaryOp = (BinaryOp)object;
                    if (!Intrinsics.areEqual(this.lhsType, binaryOp.lhsType) || !Intrinsics.areEqual(this.rhsType, binaryOp.rhsType) || !Intrinsics.areEqual(this.operatorName, binaryOp.operatorName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$PrimitiveType;", "T", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.backend.common"})
    private static final class PrimitiveType<T> {
        private final String name;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public PrimitiveType(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final PrimitiveType<T> copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new PrimitiveType<T>(name);
        }

        public static /* synthetic */ PrimitiveType copy$default(PrimitiveType primitiveType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = primitiveType.name;
            }
            return primitiveType.copy(string2);
        }

        @NotNull
        public String toString() {
            return "PrimitiveType(name=" + this.name + ")";
        }

        public int hashCode() {
            String string2 = this.name;
            return string2 != null ? string2.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PrimitiveType)) break block3;
                    PrimitiveType primitiveType = (PrimitiveType)object;
                    if (!Intrinsics.areEqual(this.name, primitiveType.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00010\u0006H\u0002RV\u0010\u0003\u001aJ\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u00060\u0004j$\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$Companion;", "", "()V", "BINARY_OP_TO_EVALUATOR", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$BinaryOp;", "Lkotlin/Function2;", "Lkotlin/collections/HashMap;", "DOUBLE", "Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$PrimitiveType;", "", "FLOAT", "", "INT", "", "LONG", "", "registerBuiltinBinaryOp", "", "T", "operandType", "operatorName", "", "f", "ir.backend.common"})
    public static final class Companion {
        private final <T> void registerBuiltinBinaryOp(PrimitiveType<T> operandType, String operatorName, Function2<? super T, ? super T, ? extends Object> f) {
            Function2<? super T, ? super T, ? extends Object> function2 = f;
            if (function2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type (kotlin.Any?, kotlin.Any?) -> kotlin.Any");
            }
            ((Map)BINARY_OP_TO_EVALUATOR).put(new BinaryOp(operandType.getName(), operandType.getName(), operatorName), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function2, 2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

