/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirWhenSubject;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTypeOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenSubjectExpressionBuilder;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001af\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u001d\u0010\n\u001a\u0019\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0002\b\u000f2\u0019\u0010\u0010\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u000fH\u0000\u001ae\u0010\u0014\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u001f\u0010\u001b\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\b\u000f2\u0019\u0010\u001e\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u000fH\u0000\u00a2\u0006\u0002\u0010\u001f\u001aP\u0010\u0014\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u001f\u0010\u001b\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\b\u000f2\u0019\u0010\u001e\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u000fH\u0000\u00a8\u0006 "}, d2={"generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "", "extractAnnotationsTo", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "Lorg/jetbrains/kotlin/fir/builder/FirAnnotationContainerBuilder;", "", "Lkotlin/ExtensionFunctionType;", "toFirOrImplicitTypeRef", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toFirWhenCondition", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "baseSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "subject", "Lorg/jetbrains/kotlin/fir/FirWhenSubject;", "convert", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "toFirOrErrorTypeRef", "([Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/FirWhenSubject;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "psi2fir"})
public final class PsiConversionUtilsKt {
    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition $this$toFirWhenCondition, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        FirExpression firExpression2;
        Intrinsics.checkNotNullParameter($this$toFirWhenCondition, "$this$toFirWhenCondition");
        Intrinsics.checkNotNullParameter(subject, "subject");
        Intrinsics.checkNotNullParameter(convert, "convert");
        Intrinsics.checkNotNullParameter(toFirOrErrorTypeRef, "toFirOrErrorTypeRef");
        PsiElement $this$toFirPsiSourceElement$iv = $this$toFirWhenCondition;
        boolean $i$f$toFirPsiSourceElement = false;
        FirPsiSourceElement<PsiElement> baseSource = new FirPsiSourceElement<PsiElement>($this$toFirPsiSourceElement$iv);
        boolean $i$f$buildWhenSubjectExpression = false;
        boolean bl = false;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirWhenSubjectExpressionBuilder $this$buildWhenSubjectExpression = firWhenSubjectExpressionBuilder;
        boolean bl4 = false;
        $this$buildWhenSubjectExpression.setSource(baseSource);
        $this$buildWhenSubjectExpression.setWhenSubject(subject);
        FirWhenSubjectExpression firSubjectExpression = firWhenSubjectExpressionBuilder.build();
        KtWhenCondition ktWhenCondition = $this$toFirWhenCondition;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            FirPsiSourceElement<PsiElement> firPsiSourceElement;
            boolean $i$f$buildOperatorCall = false;
            bl2 = false;
            FirOperatorCallBuilder firOperatorCallBuilder = new FirOperatorCallBuilder();
            bl3 = false;
            boolean bl5 = false;
            FirOperatorCallBuilder $this$buildOperatorCall = firOperatorCallBuilder;
            boolean bl6 = false;
            KtExpression ktExpression = ((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression();
            if (ktExpression != null) {
                PsiElement $this$toFirPsiSourceElement$iv2 = ktExpression;
                boolean $i$f$toFirPsiSourceElement2 = false;
                firPsiSourceElement = new FirPsiSourceElement<PsiElement>($this$toFirPsiSourceElement$iv2);
            } else {
                firPsiSourceElement = null;
            }
            $this$buildOperatorCall.setSource(firPsiSourceElement);
            $this$buildOperatorCall.setOperation(FirOperation.EQ);
            $this$buildOperatorCall.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(firSubjectExpression, convert.invoke(((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression(), "No expression in condition with expression")));
            firExpression2 = firOperatorCallBuilder.build();
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            FirPsiSourceElement<PsiElement> firPsiSourceElement;
            boolean $i$f$toFirPsiSourceElement3;
            FirExpression firRange = convert.invoke(((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression(), "No range in condition with range");
            FirExpression firExpression3 = firSubjectExpression;
            boolean bl7 = ((KtWhenConditionInRange)$this$toFirWhenCondition).isNegated();
            KtExpression ktExpression = ((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression();
            if (ktExpression != null) {
                PsiElement $this$toFirPsiSourceElement$iv3 = ktExpression;
                $i$f$toFirPsiSourceElement3 = false;
                firPsiSourceElement = new FirPsiSourceElement<PsiElement>($this$toFirPsiSourceElement$iv3);
            } else {
                firPsiSourceElement = null;
            }
            FirSourceElement firSourceElement = firPsiSourceElement;
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtWhenConditionInRange)$this$toFirWhenCondition).getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "operationReference");
            PsiElement $this$toFirPsiSourceElement$iv4 = ktOperationReferenceExpression;
            $i$f$toFirPsiSourceElement3 = false;
            firExpression2 = ConversionUtilsKt.generateContainsOperation(firRange, firExpression3, bl7, firSourceElement, new FirPsiSourceElement<PsiElement>($this$toFirPsiSourceElement$iv4));
        } else if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            FirPsiSourceElement<PsiElement> firPsiSourceElement;
            boolean $i$f$buildTypeOperatorCall = false;
            bl2 = false;
            FirTypeOperatorCallBuilder firTypeOperatorCallBuilder = new FirTypeOperatorCallBuilder();
            bl3 = false;
            boolean bl8 = false;
            FirTypeOperatorCallBuilder $this$buildTypeOperatorCall = firTypeOperatorCallBuilder;
            boolean bl9 = false;
            KtTypeReference ktTypeReference = ((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference();
            if (ktTypeReference != null) {
                PsiElement $this$toFirPsiSourceElement$iv5 = ktTypeReference;
                boolean $i$f$toFirPsiSourceElement4 = false;
                firPsiSourceElement = new FirPsiSourceElement<PsiElement>($this$toFirPsiSourceElement$iv5);
            } else {
                firPsiSourceElement = null;
            }
            $this$buildTypeOperatorCall.setSource(firPsiSourceElement);
            $this$buildTypeOperatorCall.setOperation(((KtWhenConditionIsPattern)$this$toFirWhenCondition).isNegated() ? FirOperation.NOT_IS : FirOperation.IS);
            $this$buildTypeOperatorCall.setConversionTypeRef(toFirOrErrorTypeRef.invoke(((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference()));
            $this$buildTypeOperatorCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(firSubjectExpression));
            firExpression2 = firTypeOperatorCallBuilder.build();
        } else {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(baseSource, new ConeSimpleDiagnostic("Unsupported when condition: " + $this$toFirWhenCondition.getClass(), DiagnosticKind.Syntax));
        }
        return firExpression2;
    }

    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition[] $this$toFirWhenCondition, @Nullable FirSourceElement baseSource, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        Intrinsics.checkNotNullParameter($this$toFirWhenCondition, "$this$toFirWhenCondition");
        Intrinsics.checkNotNullParameter(subject, "subject");
        Intrinsics.checkNotNullParameter(convert, "convert");
        Intrinsics.checkNotNullParameter(toFirOrErrorTypeRef, "toFirOrErrorTypeRef");
        FirExpression firCondition = null;
        for (KtWhenCondition condition : $this$toFirWhenCondition) {
            FirExpression firConditionElement = PsiConversionUtilsKt.toFirWhenCondition(condition, subject, convert, toFirOrErrorTypeRef);
            FirExpression firExpression2 = firCondition;
            firCondition = firExpression2 == null ? firConditionElement : (FirExpression)ConversionUtilsKt.generateLazyLogicalOperation(firCondition, firConditionElement, false, baseSource);
        }
        FirExpression firExpression3 = firCondition;
        Intrinsics.checkNotNull(firExpression3);
        return firExpression3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session, @NotNull KtDestructuringDeclaration multiDeclaration, @NotNull FirVariable<?> container, boolean tmpVariable, @NotNull Function2<? super KtAnnotated, ? super FirAnnotationContainerBuilder, Unit> extractAnnotationsTo, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrImplicitTypeRef) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(multiDeclaration, "multiDeclaration");
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(extractAnnotationsTo, "extractAnnotationsTo");
        Intrinsics.checkNotNullParameter(toFirOrImplicitTypeRef, "toFirOrImplicitTypeRef");
        boolean $i$f$buildBlock = false;
        boolean bl = false;
        FirBlockBuilder firBlockBuilder = new FirBlockBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirBlockBuilder $this$buildBlock = firBlockBuilder;
        boolean bl4 = false;
        Object $this$toFirPsiSourceElement$iv = multiDeclaration;
        boolean $i$f$toFirPsiSourceElement2 = false;
        $this$buildBlock.setSource(new FirPsiSourceElement<PsiElement>((PsiElement)$this$toFirPsiSourceElement$iv));
        if (tmpVariable) {
            $this$toFirPsiSourceElement$iv = $this$buildBlock.getStatements();
            FirVariable<?> $i$f$toFirPsiSourceElement2 = container;
            boolean bl5 = false;
            $this$toFirPsiSourceElement$iv.add($i$f$toFirPsiSourceElement2);
        }
        boolean isVar = multiDeclaration.isVar();
        $i$f$toFirPsiSourceElement2 = false;
        List<KtDestructuringDeclarationEntry> list2 = multiDeclaration.getEntries();
        Intrinsics.checkNotNullExpressionValue(list2, "multiDeclaration.entries");
        Iterator iterator2 = ((Iterable)list2).iterator();
        while (iterator2.hasNext()) {
            void index2;
            void $this$buildComponentCall;
            Name name;
            KtDestructuringDeclarationEntry entry;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry = (KtDestructuringDeclarationEntry)iterator2.next();
            Intrinsics.checkNotNullExpressionValue(ktDestructuringDeclarationEntry, "entry");
            PsiElement $this$toFirPsiSourceElement$iv2 = ktDestructuringDeclarationEntry;
            boolean $i$f$toFirPsiSourceElement3 = false;
            FirPsiSourceElement<PsiElement> entrySource = new FirPsiSourceElement<PsiElement>($this$toFirPsiSourceElement$iv2);
            Intrinsics.checkNotNullExpressionValue(entry.getNameAsSafeName(), "entry.nameAsSafeName");
            Collection collection = $this$buildBlock.getStatements();
            boolean $i$f$buildProperty = false;
            boolean bl6 = false;
            FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
            boolean bl7 = false;
            boolean bl8 = false;
            FirPropertyBuilder $this$buildProperty = firPropertyBuilder;
            boolean bl9 = false;
            $this$buildProperty.setSource(entrySource);
            $this$buildProperty.setSession(session);
            $this$buildProperty.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$buildProperty.setReturnTypeRef(toFirOrImplicitTypeRef.invoke(entry.getTypeReference()));
            $this$buildProperty.setName(name);
            boolean $i$f$buildComponentCall = false;
            boolean bl10 = false;
            FirComponentCallBuilder firComponentCallBuilder = new FirComponentCallBuilder();
            boolean bl11 = false;
            boolean bl12 = false;
            FirComponentCallBuilder firComponentCallBuilder2 = firComponentCallBuilder;
            FirPropertyBuilder firPropertyBuilder2 = $this$buildProperty;
            boolean bl13 = false;
            $this$buildComponentCall.setSource(entrySource);
            $this$buildComponentCall.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(entrySource, container));
            $this$buildComponentCall.setComponentIndex((int)(index2 + true));
            Unit unit = Unit.INSTANCE;
            firPropertyBuilder2.setInitializer(firComponentCallBuilder.build());
            $this$buildProperty.setVar(isVar);
            $this$buildProperty.setLocal(true);
            Visibility visibility = Visibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue(visibility, "Visibilities.LOCAL");
            $this$buildProperty.setStatus(new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            $this$buildProperty.setSymbol(new FirPropertySymbol(name));
            extractAnnotationsTo.invoke(entry, $this$buildProperty);
            FirProperty firProperty = firPropertyBuilder.build();
            bl6 = false;
            collection.add(firProperty);
            ++index2;
        }
        return firBlockBuilder.build();
    }
}

