/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.ModuleEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.OrganisationEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.RevisionEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.Matcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.MatcherHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.PatternMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.namespace.Namespace;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.AbstractResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.DependencyResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;

public class SearchEngine {
    private IvySettings settings;

    public SearchEngine(IvySettings settings) {
        this.settings = settings;
    }

    public String[] listTokenValues(String token, Map<String, Object> otherTokenValues) {
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] values2;
            for (Map<String, String> value : values2 = resolver.listTokenValues(new String[]{token}, otherTokenValues)) {
                entries.add(value.get(token));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public OrganisationEntry[] listOrganisationEntries() {
        HashSet<OrganisationEntry> entries = new HashSet<OrganisationEntry>();
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] orgs;
            for (Map<String, String> oe : orgs = resolver.listTokenValues(new String[]{"organisation"}, new HashMap<String, Object>())) {
                String org = oe.get("organisation");
                entries.add(new OrganisationEntry(resolver, org));
            }
        }
        return entries.toArray(new OrganisationEntry[entries.size()]);
    }

    public String[] listOrganisations() {
        HashSet<String> entries = new HashSet<String>();
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] orgs;
            for (Map<String, String> org : orgs = resolver.listTokenValues(new String[]{"organisation"}, new HashMap<String, Object>())) {
                entries.add(org.get("organisation"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public ModuleEntry[] listModuleEntries(OrganisationEntry org) {
        HashSet<ModuleEntry> entries = new HashSet<ModuleEntry>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", org.getOrganisation());
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] modules;
            for (Map<String, String> me : modules = resolver.listTokenValues(new String[]{"module"}, tokenValues)) {
                String module = me.get("module");
                entries.add(new ModuleEntry(org, module));
            }
        }
        return entries.toArray(new ModuleEntry[entries.size()]);
    }

    public String[] listModules(String org) {
        HashSet<String> entries = new HashSet<String>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", org);
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] modules;
            for (Map<String, String> module : modules = resolver.listTokenValues(new String[]{"module"}, tokenValues)) {
                entries.add(module.get("module"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public RevisionEntry[] listRevisionEntries(ModuleEntry module) {
        HashSet<RevisionEntry> entries = new HashSet<RevisionEntry>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", module.getOrganisation());
        tokenValues.put("module", module.getModule());
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] revisions;
            for (Map<String, String> revision : revisions = resolver.listTokenValues(new String[]{"revision"}, tokenValues)) {
                entries.add(new RevisionEntry(module, revision.get("revision")));
            }
        }
        return entries.toArray(new RevisionEntry[entries.size()]);
    }

    public String[] listRevisions(String org, String module) {
        HashSet<String> entries = new HashSet<String>();
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        tokenValues.put("organisation", org);
        tokenValues.put("module", module);
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] revisions;
            for (Map<String, String> revision : revisions = resolver.listTokenValues(new String[]{"revision"}, tokenValues)) {
                entries.add(revision.get("revision"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public ModuleId[] listModules(ModuleId moduleCrit, PatternMatcher matcher) {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        this.addMatcher(matcher, moduleCrit.getOrganisation(), criteria, "organisation");
        this.addMatcher(matcher, moduleCrit.getName(), criteria, "module");
        String[] tokensToList = new String[]{"organisation", "module"};
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] moduleIdAsMap;
            for (Map<String, String> moduleId : moduleIdAsMap = resolver.listTokenValues(tokensToList, criteria)) {
                String org = moduleId.get("organisation");
                String name = moduleId.get("module");
                ModuleId modId = ModuleId.newInstance(org, name);
                ret.add(NameSpaceHelper.transform(modId, resolver.getNamespace().getToSystemTransformer()));
            }
        }
        return ret.toArray(new ModuleId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(ModuleRevisionId moduleCrit, PatternMatcher matcher) {
        ArrayList<ModuleRevisionId> ret = new ArrayList<ModuleRevisionId>();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : moduleCrit.getAttributes().entrySet()) {
            this.addMatcher(matcher, entry.getValue(), criteria, entry.getKey());
        }
        String[] tokensToList = moduleCrit.getAttributes().keySet().toArray(new String[moduleCrit.getAttributes().size()]);
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map<String, String>[] moduleIdAsMap;
            for (Map<String, String> moduleId : moduleIdAsMap = resolver.listTokenValues(tokensToList, criteria)) {
                String org = moduleId.get("organisation");
                String name = moduleId.get("module");
                String branch = moduleId.get("branch");
                String rev = moduleId.get("revision");
                HashMap<String, String> foundExtraAtts = new HashMap<String, String>();
                for (String qualifiedKey : moduleCrit.getQualifiedExtraAttributes().keySet()) {
                    String value = null;
                    int colonIndex = qualifiedKey.indexOf(58);
                    value = colonIndex == -1 ? moduleId.get(qualifiedKey) : moduleId.get(qualifiedKey.substring(colonIndex + 1));
                    if (value == null) continue;
                    foundExtraAtts.put(qualifiedKey, value);
                }
                ModuleRevisionId modRevId = ModuleRevisionId.newInstance(org, name, branch, rev, foundExtraAtts);
                ret.add(resolver.getNamespace().getToSystemTransformer().transform(modRevId));
            }
        }
        return ret.toArray(new ModuleRevisionId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(DependencyResolver resolver, ModuleRevisionId moduleCrit, PatternMatcher matcher) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : moduleCrit.getAttributes().entrySet()) {
            this.addMatcher(matcher, entry.getValue(), criteria, entry.getKey());
        }
        String[] tokensToList = moduleCrit.getAttributes().keySet().toArray(new String[moduleCrit.getAttributes().size()]);
        Map<String, String>[] moduleIdAsMap = resolver.listTokenValues(tokensToList, criteria);
        LinkedHashSet<ModuleRevisionId> result = new LinkedHashSet<ModuleRevisionId>();
        for (Map<String, String> moduleId : moduleIdAsMap) {
            String org = moduleId.get("organisation");
            String name = moduleId.get("module");
            String branch = moduleId.get("branch");
            String rev = moduleId.get("revision");
            HashMap<String, String> foundExtraAtts = new HashMap<String, String>();
            for (String qualifiedKey : moduleCrit.getQualifiedExtraAttributes().keySet()) {
                String value = null;
                int colonIndex = qualifiedKey.indexOf(58);
                value = colonIndex == -1 ? moduleId.get(qualifiedKey) : moduleId.get(qualifiedKey.substring(colonIndex + 1));
                if (value == null) continue;
                foundExtraAtts.put(qualifiedKey, value);
            }
            ModuleRevisionId modRevId = ModuleRevisionId.newInstance(org, name, branch, rev, foundExtraAtts);
            result.add(resolver.getNamespace().getToSystemTransformer().transform(modRevId));
        }
        return result.toArray(new ModuleRevisionId[result.size()]);
    }

    private void addMatcher(PatternMatcher patternMatcher, String expression, Map<String, Object> criteria, String key) {
        if (expression == null) {
            return;
        }
        Matcher matcher = patternMatcher.getMatcher(expression);
        if (matcher.isExact()) {
            criteria.put(key, expression);
        } else {
            criteria.put(key, matcher);
        }
    }

    public Collection<ModuleRevisionId> findModuleRevisionIds(DependencyResolver resolver, ModuleRevisionId pattern, PatternMatcher matcher) {
        ArrayList<ModuleRevisionId> mrids = new ArrayList<ModuleRevisionId>();
        String resolverName = resolver.getName();
        Message.verbose("looking for modules matching " + pattern + " using " + matcher.getName());
        Namespace fromNamespace = null;
        if (resolver instanceof AbstractResolver) {
            fromNamespace = resolver.getNamespace();
        }
        ArrayList<ModuleEntry> modules = new ArrayList<ModuleEntry>();
        OrganisationEntry[] orgs = resolver.listOrganisations();
        if (orgs == null || orgs.length == 0) {
            String org = pattern.getOrganisation();
            if (fromNamespace != null) {
                org = NameSpaceHelper.transform(pattern.getModuleId(), fromNamespace.getFromSystemTransformer()).getOrganisation();
            }
            modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
        } else {
            Matcher orgMatcher = matcher.getMatcher(pattern.getOrganisation());
            for (OrganisationEntry oe : orgs) {
                String systemOrg;
                String org = oe.getOrganisation();
                String string = systemOrg = fromNamespace == null ? org : NameSpaceHelper.transformOrganisation(org, fromNamespace.getToSystemTransformer());
                if (!orgMatcher.matches(systemOrg)) continue;
                modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
            }
        }
        Message.debug("found " + modules.size() + " modules for " + pattern.getOrganisation() + " on " + resolverName);
        boolean foundModule = false;
        for (ModuleEntry mEntry : modules) {
            ModuleId foundMid;
            ModuleId systemMid = foundMid = new ModuleId(mEntry.getOrganisation(), mEntry.getModule());
            if (fromNamespace != null) {
                systemMid = NameSpaceHelper.transform(foundMid, fromNamespace.getToSystemTransformer());
            }
            if (!MatcherHelper.matches(matcher, pattern.getModuleId(), systemMid)) continue;
            foundModule = true;
            RevisionEntry[] rEntries = resolver.listRevisions(mEntry);
            Message.debug("found " + rEntries.length + " revisions for [" + mEntry.getOrganisation() + ", " + mEntry.getModule() + "] on " + resolverName);
            boolean foundRevision = false;
            for (RevisionEntry rEntry : rEntries) {
                ModuleRevisionId foundMrid;
                ModuleRevisionId systemMrid = foundMrid = ModuleRevisionId.newInstance(mEntry.getOrganisation(), mEntry.getModule(), rEntry.getRevision());
                if (fromNamespace != null) {
                    systemMrid = fromNamespace.getToSystemTransformer().transform(foundMrid);
                }
                if (!MatcherHelper.matches(matcher, pattern, systemMrid)) continue;
                foundRevision = true;
                mrids.add(systemMrid);
            }
            if (foundRevision) continue;
            Message.debug("no revision found matching " + pattern + " in [" + mEntry.getOrganisation() + "," + mEntry.getModule() + "] using " + resolverName);
        }
        if (!foundModule) {
            Message.debug("no module found matching " + pattern + " using " + resolverName);
        }
        return mrids;
    }
}

