/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.IvyContext;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.event.IvyEvent;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.trigger.Trigger;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.Project;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.taskdefs.CallTarget;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.taskdefs.Property;

public class AntCallTrigger
extends AbstractTrigger
implements Trigger {
    private boolean onlyonce = true;
    private String target = null;
    private Collection<IvyEvent> calls = new ArrayList<IvyEvent>();
    private String prefix;

    @Override
    public void progress(IvyEvent event) {
        Project project = (Project)IvyContext.peekInContextStack("ant-project");
        if (project == null) {
            Message.info("ant call trigger can only be used from an ant build. Ignoring.");
            return;
        }
        if (this.onlyonce && this.isTriggered(event)) {
            Message.verbose("call already triggered for this event, skipping: " + event);
        } else {
            CallTarget call = new CallTarget();
            call.setProject(project);
            call.setTaskName("antcall");
            Map<String, String> attributes = event.getAttributes();
            String target = IvyPatternHelper.substituteTokens(this.getTarget(), attributes);
            call.setTarget(target);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                Property p = call.createParam();
                p.setName(this.prefix == null ? entry.getKey() : this.prefix + entry.getKey());
                p.setValue(entry.getValue() == null ? "" : entry.getValue());
            }
            Message.verbose("triggering ant call: target=" + target + " for " + event);
            call.execute();
            this.markTriggered(event);
            Message.debug("triggered ant call finished: target=" + target + " for " + event);
        }
    }

    private void markTriggered(IvyEvent event) {
        this.calls.add(event);
    }

    private boolean isTriggered(IvyEvent event) {
        return this.calls.contains(event);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isOnlyonce() {
        return this.onlyonce;
    }

    public void setOnlyonce(boolean onlyonce) {
        this.onlyonce = onlyonce;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (!prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }
}

