/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.impl.IrErrorDeclarationImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeAliasImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AnonymousInitializerGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.FunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.PropertyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ScriptGenerator;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u00101\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\u000e\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u0011J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J>\u00108\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u001e\u00109\u001a\u001a\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020<0:H\u0002J\n\u0010=\u001a\u00020>*\u00020?R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/Generator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "generateClassMemberDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateClassOrObjectDeclaration", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "generateEnumEntryDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "ktEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "generateFakeOverrideDeclaration", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "ktElement", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "generateFakeOverrideFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateFakeOverrideProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateGlobalTypeParametersDeclarations", "", "irTypeParametersOwner", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "from", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generateInitializerBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ktBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateMemberDeclaration", "generateScopedTypeParameterDeclarations", "generateSyntheticClassOrObject", "syntheticDeclaration", "generateTypeAliasDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "ktTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "generateTypeParameterDeclarations", "declareTypeParameter", "Lkotlin/Function3;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "ir.psi2ir"})
public final class DeclarationGenerator
implements Generator {
    private final TypeTranslator typeTranslator;
    @NotNull
    private final GeneratorContext context;

    @NotNull
    public final IrType toIrType(@NotNull KotlinType $this$toIrType) {
        Intrinsics.checkParameterIsNotNull($this$toIrType, "$this$toIrType");
        return this.typeTranslator.translateType($this$toIrType);
    }

    @Nullable
    public final IrDeclaration generateMemberDeclaration(@NotNull KtDeclaration ktDeclaration) {
        IrDeclaration irDeclaration2;
        Intrinsics.checkParameterIsNotNull(ktDeclaration, "ktDeclaration");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        if (ktDeclaration2 instanceof KtNamedFunction) {
            irDeclaration2 = new FunctionGenerator(this).generateFunctionDeclaration((KtNamedFunction)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtProperty) {
            irDeclaration2 = new PropertyGenerator(this).generatePropertyDeclaration((KtProperty)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtClassOrObject) {
            irDeclaration2 = this.generateClassOrObjectDeclaration((KtPureClassOrObject)((Object)ktDeclaration));
        } else if (ktDeclaration2 instanceof KtTypeAlias) {
            irDeclaration2 = this.generateTypeAliasDeclaration((KtTypeAlias)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtScript) {
            irDeclaration2 = new ScriptGenerator(this).generateScriptDeclaration((KtScript)ktDeclaration);
        } else {
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktDeclaration);
            int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
            ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
            Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.DECLARATION_TO_DESCRIPTOR");
            DeclarationDescriptor declarationDescriptor = GeneratorKt.getOrFail(this, readOnlySlice, ktDeclaration);
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "getOrFail(BindingContext\u2026ESCRIPTOR, ktDeclaration)");
            irDeclaration2 = new IrErrorDeclarationImpl(n, n2, declarationDescriptor);
        }
        return irDeclaration2;
    }

    @NotNull
    public final IrClass generateSyntheticClassOrObject(@NotNull KtPureClassOrObject syntheticDeclaration) {
        Intrinsics.checkParameterIsNotNull(syntheticDeclaration, "syntheticDeclaration");
        return this.generateClassOrObjectDeclaration(syntheticDeclaration);
    }

    @Nullable
    public final IrDeclaration generateClassMemberDeclaration(@NotNull KtDeclaration ktDeclaration, @NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(ktDeclaration, "ktDeclaration");
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        return ktDeclaration2 instanceof KtAnonymousInitializer ? new AnonymousInitializerGenerator(this).generateAnonymousInitializerDeclaration((KtAnonymousInitializer)ktDeclaration, irClass) : (ktDeclaration2 instanceof KtSecondaryConstructor ? (IrDeclaration)new FunctionGenerator(this).generateSecondaryConstructor((KtSecondaryConstructor)ktDeclaration) : (ktDeclaration2 instanceof KtEnumEntry ? (IrDeclaration)this.generateEnumEntryDeclaration((KtEnumEntry)ktDeclaration) : this.generateMemberDeclaration(ktDeclaration)));
    }

    private final IrEnumEntry generateEnumEntryDeclaration(KtEnumEntry ktEnumEntry) {
        return new ClassGenerator(this).generateEnumEntry(ktEnumEntry);
    }

    @NotNull
    public final IrClass generateClassOrObjectDeclaration(@NotNull KtPureClassOrObject ktClassOrObject) {
        Intrinsics.checkParameterIsNotNull(ktClassOrObject, "ktClassOrObject");
        return new ClassGenerator(this).generateClass(ktClassOrObject);
    }

    private final IrTypeAlias generateTypeAliasDeclaration(KtTypeAlias ktTypeAlias) {
        WritableSlice<PsiElement, TypeAliasDescriptor> writableSlice = BindingContext.TYPE_ALIAS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.TYPE_ALIAS");
        TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktTypeAlias);
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(typeAliasDescriptor2, "typeAliasDescriptor");
        IrTypeAlias irTypeAlias2 = symbolTable.declareTypeAlias(typeAliasDescriptor2, (Function1<? super IrTypeAliasSymbol, ? extends IrTypeAlias>)new Function1<IrTypeAliasSymbol, IrTypeAlias>(this, ktTypeAlias, typeAliasDescriptor){
            final /* synthetic */ DeclarationGenerator this$0;
            final /* synthetic */ KtTypeAlias $ktTypeAlias;
            final /* synthetic */ TypeAliasDescriptor $typeAliasDescriptor;

            @NotNull
            public final IrTypeAlias invoke(@NotNull IrTypeAliasSymbol symbol2) {
                Intrinsics.checkParameterIsNotNull(symbol2, "symbol");
                return IrTypeAliasImpl.Companion.fromSymbolDescriptor(PsiUtilsKt.getStartOffsetSkippingComments(this.$ktTypeAlias), PsiUtilsKt.getEndOffset(this.$ktTypeAlias), symbol2, this.this$0.toIrType(this.$typeAliasDescriptor.getExpandedType()), IrDeclarationOrigin.DEFINED.INSTANCE);
            }
            {
                this.this$0 = declarationGenerator;
                this.$ktTypeAlias = ktTypeAlias;
                this.$typeAliasDescriptor = typeAliasDescriptor;
                super(1);
            }
        });
        IrTypeParametersContainer irTypeParametersContainer = irTypeAlias2;
        List<TypeParameterDescriptor> list2 = typeAliasDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "typeAliasDescriptor.declaredTypeParameters");
        this.generateGlobalTypeParametersDeclarations(irTypeParametersContainer, list2);
        return irTypeAlias2;
    }

    public final void generateGlobalTypeParametersDeclarations(@NotNull IrTypeParametersContainer irTypeParametersOwner, @NotNull List<? extends TypeParameterDescriptor> from) {
        Intrinsics.checkParameterIsNotNull(irTypeParametersOwner, "irTypeParametersOwner");
        Intrinsics.checkParameterIsNotNull(from, "from");
        this.generateTypeParameterDeclarations(irTypeParametersOwner, from, (Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter>)new Function3<Integer, Integer, TypeParameterDescriptor, IrTypeParameter>(this){
            final /* synthetic */ DeclarationGenerator this$0;

            @NotNull
            public final IrTypeParameter invoke(int startOffset, int endOffset, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkParameterIsNotNull(typeParameterDescriptor, "typeParameterDescriptor");
                return SymbolTable.declareGlobalTypeParameter$default(this.this$0.getContext().getSymbolTable(), startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, typeParameterDescriptor, null, 16, null);
            }
            {
                this.this$0 = declarationGenerator;
                super(3);
            }
        });
    }

    public final void generateScopedTypeParameterDeclarations(@NotNull IrTypeParametersContainer irTypeParametersOwner, @NotNull List<? extends TypeParameterDescriptor> from) {
        Intrinsics.checkParameterIsNotNull(irTypeParametersOwner, "irTypeParametersOwner");
        Intrinsics.checkParameterIsNotNull(from, "from");
        this.generateTypeParameterDeclarations(irTypeParametersOwner, from, (Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter>)new Function3<Integer, Integer, TypeParameterDescriptor, IrTypeParameter>(this){
            final /* synthetic */ DeclarationGenerator this$0;

            @NotNull
            public final IrTypeParameter invoke(int startOffset, int endOffset, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkParameterIsNotNull(typeParameterDescriptor, "typeParameterDescriptor");
                return SymbolTable.declareScopedTypeParameter$default(this.this$0.getContext().getSymbolTable(), startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, typeParameterDescriptor, null, 16, null);
            }
            {
                this.this$0 = declarationGenerator;
                super(3);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTypeParameterDeclarations(IrTypeParametersContainer irTypeParametersOwner, List<? extends TypeParameterDescriptor> from, Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter> declareTypeParameter) {
        IrAnnotationContainer irAnnotationContainer;
        Object ktTypeParameterDeclaration;
        Collection collection;
        void $this$mapTo$iv;
        Iterable iterable = from;
        Collection destination$iv = irTypeParametersOwner.getTypeParameters();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            collection = destination$iv;
            boolean bl = false;
            ktTypeParameterDeclaration = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)typeParameterDescriptor);
            int startOffset = KotlinUtilsKt.getStartOffsetOrUndefined((PsiElement)ktTypeParameterDeclaration);
            int endOffset = KotlinUtilsKt.getEndOffsetOrUndefined((PsiElement)ktTypeParameterDeclaration);
            irAnnotationContainer = declareTypeParameter.invoke((Integer)startOffset, (Integer)endOffset, (TypeParameterDescriptor)typeParameterDescriptor);
            collection.add(irAnnotationContainer);
        }
        for (IrTypeParameter irTypeParameter : irTypeParametersOwner.getTypeParameters()) {
            void $this$mapTo$iv2;
            List<KotlinType> list2 = irTypeParameter.getDescriptor().getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list2, "irTypeParameter.descriptor.upperBounds");
            Iterable $i$f$mapTo2 = list2;
            Collection destination$iv2 = irTypeParameter.getSuperTypes();
            boolean $i$f$mapTo3 = false;
            for (Object item$iv : $this$mapTo$iv2) {
                void it;
                ktTypeParameterDeclaration = (KotlinType)item$iv;
                collection = destination$iv2;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull(v1, "it");
                irAnnotationContainer = this.toIrType((KotlinType)v1);
                collection.add(irAnnotationContainer);
            }
        }
    }

    @NotNull
    public final IrExpressionBody generateInitializerBody(@NotNull IrSymbol scopeOwnerSymbol, @NotNull KtExpression ktBody) {
        Intrinsics.checkParameterIsNotNull(scopeOwnerSymbol, "scopeOwnerSymbol");
        Intrinsics.checkParameterIsNotNull(ktBody, "ktBody");
        return DeclarationGeneratorKt.createBodyGenerator(this, scopeOwnerSymbol).generateExpressionBody(ktBody);
    }

    @Nullable
    public final IrDeclaration generateFakeOverrideDeclaration(@NotNull CallableMemberDescriptor memberDescriptor, @NotNull KtPureElement ktElement) {
        IrElement irElement;
        Intrinsics.checkParameterIsNotNull(memberDescriptor, "memberDescriptor");
        Intrinsics.checkParameterIsNotNull(ktElement, "ktElement");
        boolean bl = memberDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Fake override expected: " + memberDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        CallableMemberDescriptor callableMemberDescriptor = memberDescriptor;
        if (callableMemberDescriptor instanceof FunctionDescriptor) {
            irElement = this.generateFakeOverrideFunction((FunctionDescriptor)memberDescriptor, ktElement);
        } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
            irElement = this.generateFakeOverrideProperty((PropertyDescriptor)memberDescriptor, ktElement);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected member descriptor: " + memberDescriptor)));
        }
        return (IrDeclaration)irElement;
    }

    private final IrProperty generateFakeOverrideProperty(PropertyDescriptor propertyDescriptor, KtPureElement ktElement) {
        return new PropertyGenerator(this).generateFakeOverrideProperty(propertyDescriptor, ktElement);
    }

    private final IrSimpleFunction generateFakeOverrideFunction(FunctionDescriptor functionDescriptor, KtPureElement ktElement) {
        return new FunctionGenerator(this).generateFakeOverrideFunction(functionDescriptor, ktElement);
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    public DeclarationGenerator(@NotNull GeneratorContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
        this.typeTranslator = this.getContext().getTypeTranslator();
    }
}

