/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirSimpleFunctionImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirValueParameterImpl;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.ConeTypedProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "resolvedFunctionType", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "samConstructor", "buildSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firRegularClass", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamConstructor", "resolveFunctionTypeIfSamInterface", "shouldRunSamConversionForFunction", "", "firNamedFunction", "resolve"})
public final class FirSamResolverImpl
implements FirSamResolver {
    private final Map<FirRegularClass, Object> resolvedFunctionType;
    private final Map<FirRegularClass, Object> samConstructor;
    private final FirSession firSession;
    private final ScopeSession scopeSession;

    @Override
    @Nullable
    public ConeKotlinType getFunctionTypeForPossibleSamType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ConeKotlinType coneKotlinType2 = type2;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.getFunctionTypeForPossibleSamType((ConeClassLikeType)type2);
        } else if (coneKotlinType2 instanceof ConeFlexibleType) {
            ConeKotlinType coneKotlinType3 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getLowerBound());
            if (coneKotlinType3 == null) {
                return null;
            }
            ConeKotlinType coneKotlinType4 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getUpperBound());
            if (coneKotlinType4 == null) {
                return null;
            }
            coneKotlinType = new ConeFlexibleType(coneKotlinType3, coneKotlinType4);
        } else if (coneKotlinType2 instanceof ConeClassErrorType || coneKotlinType2 instanceof ConeStubType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeTypeParameterType || coneKotlinType2 instanceof ConeTypeVariableType || coneKotlinType2 instanceof ConeCapturedType || coneKotlinType2 instanceof ConeDefinitelyNotNullType || coneKotlinType2 instanceof ConeIntersectionType || coneKotlinType2 instanceof ConeIntegerLiteralType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
            coneKotlinType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type2) {
        Object object;
        Iterable iterable;
        ConeKotlinTypeProjection[] $this$mapTo$iv$iv;
        FirClassLikeSymbol<?> firClassLikeSymbol = ResolveUtilsKt.getFirSymbolProvider(this.firSession).getSymbolByLookupTag(type2.getLookupTag());
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
            firClassLikeDeclaration = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firClassLikeDeclaration;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        ConeKotlinType coneKotlinType = this.resolveFunctionTypeIfSamInterface(firRegularClass2);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType unsubstitutedFunctionType = coneKotlinType;
        ConeKotlinTypeProjection[] $this$map$iv = (ConeKotlinTypeProjection[])firRegularClass2.getTypeParameters();
        boolean $i$f$map = false;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameter firTypeParameter = (FirTypeParameter)t;
            iterable = destination$iv$iv;
            boolean bl = false;
            object = it.getSymbol();
            iterable.add(object);
        }
        $this$map$iv = type2.getTypeArguments();
        iterable = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray2 = $this$mapTo$iv$iv;
        int n = coneKotlinTypeProjectionArray2.length;
        for (int i = 0; i < n; ++i) {
            ConeTypedProjection coneTypedProjection;
            void it;
            ConeKotlinTypeProjection item$iv$iv;
            ConeKotlinTypeProjection coneKotlinTypeProjection = item$iv$iv = coneKotlinTypeProjectionArray2[i];
            object = destination$iv$iv;
            boolean bl = false;
            Object v4 = it;
            if (!(v4 instanceof ConeTypedProjection)) {
                v4 = null;
            }
            if ((coneTypedProjection = (ConeTypedProjection)v4) == null || (coneTypedProjection = coneTypedProjection.getType()) == null) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = new ConeClassLikeLookupTagImpl(StandardClassIds.INSTANCE.getAny());
                ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray3 = new ConeKotlinTypeProjection[]{};
                boolean bl2 = true;
                ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray4 = coneKotlinTypeProjectionArray3;
                ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
                coneTypedProjection = new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneKotlinTypeProjectionArray4, bl2);
            }
            ConeTypedProjection coneTypedProjection2 = coneTypedProjection;
            object.add(coneTypedProjection2);
        }
        object = (List)destination$iv$iv;
        ConeSubstitutor substitutor2 = ConeSubstitutorKt.substitutorByMap(MapsKt.toMap(CollectionsKt.zip(iterable, (Iterable)object)));
        ConeKotlinType result2 = ResolveUtilsKt.withNullability(substitutor2.substituteOrSelf(unsubstitutedFunctionType), ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), SessionUtilsKt.getInferenceContext(this.firSession));
        boolean bl = result2 instanceof ConeLookupTagBasedType;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(result2.getClass()) + " was found";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return (ConeLookupTagBasedType)result2;
    }

    @Override
    @Nullable
    public FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firRegularClass) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull(firRegularClass, "firRegularClass");
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.samConstructor;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            boolean bl = false;
            Object object3 = this.buildSamConstructor(firRegularClass);
            if (object3 == null) {
                object3 = SamResolutionKt.access$getNULL_STUB$p();
            }
            FirSimpleFunction answer$iv = object3;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = object = value$iv;
        }
        if (!(object2 instanceof FirSimpleFunction)) {
            object = null;
        }
        return (FirSimpleFunction)object;
    }

    /*
     * WARNING - void declaration
     */
    private final FirSimpleFunction buildSamConstructor(FirRegularClass firRegularClass) {
        void $this$isActual$iv;
        FirMemberDeclaration $this$isExpect$iv;
        void $this$toTypedArray$iv;
        Collection newTypeParameter;
        FirTypeParameterImpl $this$mapTo$iv$iv;
        Object item$iv$iv32;
        void $this$mapTo$iv$iv2;
        Object object;
        Object object2;
        Collection collection;
        Object object3;
        ConeKotlinType coneKotlinType = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType functionType = coneKotlinType;
        ClassId classId = FirDeclarationUtilKt.getClassId(firRegularClass);
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        FqName fqName3 = classId.getRelativeClassName().parent();
        FqName fqName4 = fqName2;
        boolean bl = false;
        boolean bl2 = false;
        FqName fqName5 = fqName3;
        boolean bl3 = false;
        FqName fqName6 = fqName5;
        Intrinsics.checkExpressionValueIsNotNull(fqName6, "it");
        FqName fqName7 = !fqName6.isRoot() ? fqName3 : null;
        Name name = classId.getShortClassName();
        Intrinsics.checkExpressionValueIsNotNull(name, "classId.shortClassName");
        Name name2 = name;
        FqName fqName8 = fqName7;
        FqName fqName9 = fqName4;
        CallableId callableId = new CallableId(fqName9, fqName8, name2);
        FirSyntheticFunctionSymbol symbol2 = new FirSyntheticFunctionSymbol(callableId);
        Iterable $this$map$iv = firRegularClass.getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : iterable) {
            void typeParameter;
            object3 = (FirTypeParameter)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl4 = false;
            FirTypeParameterImpl firTypeParameterImpl = new FirTypeParameterImpl(typeParameter.getSource(), this.firSession, typeParameter.getName(), new FirTypeParameterSymbol(), Variance.INVARIANT, false);
            boolean bl5 = false;
            boolean bl6 = false;
            FirTypeParameterImpl $this$apply = firTypeParameterImpl;
            boolean bl7 = false;
            object2 = $this$apply.getAnnotations();
            Iterable iterable2 = typeParameter.getAnnotations();
            boolean bl8 = false;
            CollectionsKt.addAll(object2, iterable2);
            object = firTypeParameterImpl;
            collection.add(object);
        }
        List newTypeParameters = (List)destination$iv$iv;
        Iterable $this$map$iv2 = newTypeParameters;
        boolean bl9 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv32 : $this$mapTo$iv$iv2) {
            void it2;
            FirTypeParameterImpl bl4 = (FirTypeParameterImpl)item$iv$iv32;
            collection = destination$iv$iv2;
            boolean bl92 = false;
            object = new ConeTypeParameterTypeImpl(it2.getSymbol().toLookupTag(), false);
            collection.add(object);
        }
        List newTypeParameterTypes = (List)destination$iv$iv2;
        Iterable iterable3 = firRegularClass.getTypeParameters();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = iterable3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable3, 10));
        boolean $i$f$mapTo322 = false;
        item$iv$iv32 = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv32.hasNext()) {
            void it3;
            Object item$iv$iv4 = item$iv$iv32.next();
            FirTypeParameter bl92 = (FirTypeParameter)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl10 = false;
            object = it3.getSymbol();
            collection.add(object);
        }
        ConeSubstitutor substitutor2 = ConeSubstitutorKt.substitutorByMap(MapsKt.toMap(CollectionsKt.zip((Iterable)((List)destination$iv$iv3), newTypeParameterTypes)));
        for (Pair pair : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapNotNullTo$iv$iv;
            $this$mapTo$iv$iv = (FirTypeParameterImpl)pair.component1();
            FirTypeParameter oldTypeParameter = (FirTypeParameter)pair.component2();
            Collection $i$f$mapTo322 = ((FirTypeParameterImpl)((Object)newTypeParameter)).getBounds();
            Iterable $this$mapNotNull$iv = oldTypeParameter.getBounds();
            boolean $i$f$mapNotNull = false;
            Iterable it3 = $this$mapNotNull$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                FirResolvedTypeRefImpl firResolvedTypeRefImpl;
                void $this$coneTypeSafe$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl11 = false;
                FirTypeRef typeRef = (FirTypeRef)element$iv$iv;
                boolean bl12 = false;
                FirTypeRef firTypeRef = typeRef;
                ConeSubstitutor coneSubstitutor = substitutor2;
                FirSourceElement firSourceElement = typeRef.getSource();
                boolean $i$f$coneTypeSafe = false;
                Object v4 = $this$coneTypeSafe$iv;
                if (!(v4 instanceof FirResolvedTypeRef)) {
                    v4 = null;
                }
                FirResolvedTypeRef firResolvedTypeRef = v4;
                ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                    coneKotlinType2 = null;
                }
                ConeKotlinType coneKotlinType3 = coneKotlinType2;
                ConeKotlinType coneKotlinType4 = coneKotlinType3;
                if (coneKotlinType4 == null) {
                    Object var33_73 = null;
                    firResolvedTypeRefImpl = var33_73;
                } else {
                    FirSourceElement firSourceElement2;
                    ConeKotlinType coneKotlinType5 = coneSubstitutor.substituteOrSelf(coneKotlinType4);
                    firResolvedTypeRefImpl = new FirResolvedTypeRefImpl(firSourceElement2, coneKotlinType5);
                }
                if (firResolvedTypeRefImpl == null) continue;
                FirResolvedTypeRefImpl firResolvedTypeRefImpl2 = firResolvedTypeRefImpl;
                boolean bl10 = false;
                boolean bl13 = false;
                FirResolvedTypeRefImpl it$iv$iv = firResolvedTypeRefImpl2;
                boolean bl15 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            object3 = (List)destination$iv$iv4;
            $i$f$mapNotNull = false;
            CollectionsKt.addAll($i$f$mapTo322, object3);
        }
        ConeKotlinType coneKotlinType6 = substitutor2.substituteOrSelf(functionType);
        newTypeParameter = newTypeParameterTypes;
        Object object4 = firRegularClass.getSymbol().toLookupTag();
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray = thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]);
        if (coneTypeParameterTypeImplArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray2 = coneTypeParameterTypeImplArray;
        boolean bl14 = false;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = coneTypeParameterTypeImplArray2;
        ConeClassLikeLookupTag coneClassLikeLookupTag = object4;
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag, coneKotlinTypeProjectionArray, bl14);
        FirMemberDeclaration $this$visibility$iv = firRegularClass;
        boolean $i$f$getVisibility = false;
        object4 = $this$visibility$iv.getStatus().getVisibility();
        Modality modality = Modality.FINAL;
        Object object5 = object4;
        FirPureAbstractElement firPureAbstractElement = new FirDeclarationStatusImpl((Visibility)object5, modality);
        boolean bl15 = false;
        boolean bl16 = false;
        FirDeclarationStatusImpl $this$apply = firPureAbstractElement;
        boolean bl19 = false;
        FirMemberDeclaration destination$iv$iv4 = firRegularClass;
        Object object6 = $this$apply;
        boolean $i$f$isExpect = false;
        boolean bl17 = $this$isExpect$iv.getStatus().isExpect();
        ((FirDeclarationStatusImpl)object6).setExpect(bl17);
        $this$isExpect$iv = firRegularClass;
        object6 = $this$apply;
        boolean $i$f$isActual = false;
        bl17 = $this$isActual$iv.getStatus().isActual();
        ((FirDeclarationStatusImpl)object6).setActual(bl17);
        $this$apply.setOverride(false);
        $this$apply.setOperator(false);
        $this$apply.setInfix(false);
        $this$apply.setExternal(false);
        $this$apply.setInline(false);
        $this$apply.setSuspend(false);
        $this$apply.setTailRec(false);
        FirDeclarationStatusImpl status2 = firPureAbstractElement;
        FirTypeRef firTypeRef = new FirResolvedTypeRefImpl(null, substitutedReturnType);
        Name name3 = classId.getShortClassName();
        Intrinsics.checkExpressionValueIsNotNull(name3, "classId.shortClassName");
        firPureAbstractElement = new FirSimpleFunctionImpl(null, this.firSession, firTypeRef, null, name3, status2, symbol2);
        bl15 = false;
        bl16 = false;
        $this$apply = firPureAbstractElement;
        boolean bl21 = false;
        Collection collection2 = ((FirSimpleFunctionImpl)((Object)$this$apply)).getValueParameters();
        object6 = CollectionsKt.listOf(new FirValueParameterImpl(((FirSimpleFunctionImpl)((Object)$this$apply)).getSource(), ((FirSimpleFunctionImpl)((Object)$this$apply)).getSession(), new FirResolvedTypeRefImpl(firRegularClass.getSource(), coneKotlinType6), SamResolutionKt.getSAM_PARAMETER_NAME(), new FirVariableSymbol<FirValueParameter>(SamResolutionKt.getSAM_PARAMETER_NAME()), null, false, false, false));
        boolean bl18 = false;
        CollectionsKt.addAll(collection2, object6);
        collection2 = ((FirSimpleFunctionImpl)((Object)$this$apply)).getTypeParameters();
        object6 = newTypeParameters;
        bl18 = false;
        CollectionsKt.addAll(collection2, object6);
        ((FirSimpleFunctionImpl)((Object)$this$apply)).setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        return (FirSimpleFunction)firPureAbstractElement;
    }

    private final ConeKotlinType resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        Object object;
        Object object2;
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.resolvedFunctionType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            Object object3;
            boolean bl = false;
            FirSimpleFunction firSimpleFunction = SamResolutionKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.firSession, this.scopeSession);
            if (firSimpleFunction == null) {
                object3 = SamResolutionKt.access$getNULL_STUB$p();
            } else {
                FirSimpleFunction abstractMethod = firSimpleFunction;
                object3 = SamResolutionKt.access$getFunctionTypeForAbstractMethod(abstractMethod);
            }
            Object answer$iv = object3;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = object = value$iv;
        }
        if (!(object2 instanceof ConeKotlinType)) {
            object = null;
        }
        return (ConeKotlinType)object;
    }

    @Override
    public boolean shouldRunSamConversionForFunction(@NotNull FirSimpleFunction firNamedFunction) {
        Intrinsics.checkParameterIsNotNull(firNamedFunction, "firNamedFunction");
        return true;
    }

    public FirSamResolverImpl(@NotNull FirSession firSession, @NotNull ScopeSession scopeSession) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(firSession, "firSession");
        Intrinsics.checkParameterIsNotNull(scopeSession, "scopeSession");
        this.firSession = firSession;
        this.scopeSession = scopeSession;
        FirSamResolverImpl firSamResolverImpl = this;
        boolean bl = false;
        firSamResolverImpl.resolvedFunctionType = map2 = (Map)new LinkedHashMap();
        firSamResolverImpl = this;
        bl = false;
        firSamResolverImpl.samConstructor = map2 = (Map)new LinkedHashMap();
    }
}

