/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.runner.FindCompilerKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\f\u001a\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\tH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"COMPILER_JARS", "", "", "FILE_PROTOCOL", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "findCompilerJar", "Ljava/io/File;", "classFromJarInTheSameLocation", "Ljava/lang/Class;", "kotlinHome", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "aClass", "matchMaybeVersionedFile", "", "baseName", "toFileOrNull", "kotlin-runner"})
public final class FindCompilerKt {
    private static final List<String> COMPILER_JARS = CollectionsKt.listOf("kotlin-compiler", "kotlin-stdlib", "kotlin-reflect");
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_SEPARATOR = "!/";
    private static final String SCHEME_SEPARATOR = "://";

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final List<File> findCompilerJar(@NotNull Class<?> classFromJarInTheSameLocation, @NotNull File kotlinHome) {
        Intrinsics.checkParameterIsNotNull(classFromJarInTheSameLocation, "classFromJarInTheSameLocation");
        Intrinsics.checkParameterIsNotNull(kotlinHome, "kotlinHome");
        v0 = FindCompilerKt.tryGetResourcePathForClass(classFromJarInTheSameLocation);
        if (v0 == null || (v0 = v0.getParentFile()) == null) {
            v0 = kotlinHome;
        }
        var3_2 = v0;
        var4_3 = false;
        var5_5 = false;
        it = var3_2;
        $i$a$-takeIf-FindCompilerKt$findCompilerJar$baseDir$1 = false;
        v1 = it.isDirectory() != false ? var3_2 : null;
        if (v1 == null) {
            return CollectionsKt.emptyList();
        }
        baseDir = v1;
        v2 /* !! */  = baseDir.listFiles(findCompilerJar.compilerJars.1.INSTANCE);
        if (v2 /* !! */  == null) ** GOTO lbl-1000
        var4_4 = v2 /* !! */ ;
        var5_5 = false;
        var6_7 = false;
        it = var4_4;
        $i$a$-takeIf-FindCompilerKt$findCompilerJar$compilerJars$2 = false;
        v2 /* !! */  = it.length >= FindCompilerKt.COMPILER_JARS.size() != false ? var4_4 : null;
        if (v2 /* !! */  != null) {
            v3 /* !! */  = ArraysKt.toList(v2 /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v3 /* !! */  = null;
        }
        if ((v4 = (compilerJars = v3 /* !! */ )) == null) {
            v4 = CollectionsKt.emptyList();
        }
        return v4;
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file;
        Intrinsics.checkParameterIsNotNull(aClass, "aClass");
        StringBuilder stringBuilder = new StringBuilder().append("/");
        String string = aClass.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "aClass.name");
        String path = stringBuilder.append(StringsKt.replace$default(string, '.', '/', false, 4, null)).append(".class").toString();
        String string2 = FindCompilerKt.getResourceRoot(aClass, path);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            file = new File(it).getAbsoluteFile();
        } else {
            file = null;
        }
        return file;
    }

    private static final String getResourceRoot(Class<?> context, String path) {
        URL url = context.getResource(path);
        if (url == null) {
            String string = path;
            int n = 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string3);
        }
        return url != null ? FindCompilerKt.extractRoot(url, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, '/', false, 2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, '\\', false, 2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual(protocol, FILE_PROTOCOL)) {
            String path;
            File file = FindCompilerKt.toFileOrNull(resourceURL);
            if (file == null) {
                Intrinsics.throwNpe();
            }
            String string = path = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            String testPath = StringsKt.replace$default(string, '\\', '/', false, 4, null);
            String testResourcePath = StringsKt.replace$default(resourcePath, '\\', '/', false, 4, null);
            if (StringsKt.endsWith(testPath, testResourcePath, true)) {
                String string2 = path;
                int n = 0;
                int n2 = path.length() - resourcePath.length();
                boolean bl = false;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                resultPath = string3;
            }
        } else if (Intrinsics.areEqual(protocol, JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string = resourceURL.getFile();
            Intrinsics.checkExpressionValueIsNotNull(string, "resourceURL.file");
            Pair<String, String> pair = paths = FindCompilerKt.splitJarUrl(string);
            if ((pair != null ? pair.getFirst() : null) != null) {
                resultPath = new File(paths.getFirst()).getCanonicalPath();
            }
        }
        String string = resultPath;
        return string != null ? StringsKt.trimEnd(string, File.separatorChar) : null;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block13: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, JAR_SEPARATOR, 0, false, 6, null);
            boolean bl = false;
            int n2 = 0;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            Integer n3 = it >= 0 ? n : null;
            if (n3 == null) {
                return null;
            }
            int pivot = n3;
            String string = url;
            n2 = pivot + 2;
            int n4 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
            resourcePath = string3;
            String string4 = url;
            n4 = 0;
            int n5 = 0;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n4, pivot);
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarPath = string6;
            if (StringsKt.startsWith$default(jarPath, "jar:", false, 2, null)) {
                string4 = jarPath;
                n4 = 4;
                n5 = 0;
                String string7 = string4;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n4);
                Intrinsics.checkExpressionValueIsNotNull(string8, "(this as java.lang.String).substring(startIndex)");
                jarPath = string8;
            }
            if (StringsKt.startsWith$default(jarPath, FILE_PROTOCOL, false, 2, null)) {
                try {
                    File file = FindCompilerKt.toFileOrNull(new URL(jarPath));
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    String string9 = file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull(string9, "URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default(string9, '\\', '/', false, 4, null);
                }
                catch (Exception e) {
                    String string10 = jarPath;
                    n5 = FILE_PROTOCOL.length();
                    boolean bl3 = false;
                    String string11 = string10;
                    if (string11 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.substring(n5);
                    Intrinsics.checkExpressionValueIsNotNull(string12, "(this as java.lang.String).substring(startIndex)");
                    jarPath = string12;
                    if (StringsKt.startsWith$default(jarPath, SCHEME_SEPARATOR, false, 2, null)) {
                        string10 = jarPath;
                        n5 = SCHEME_SEPARATOR.length();
                        bl3 = false;
                        String string13 = string10;
                        if (string13 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string14 = string13.substring(n5);
                        Intrinsics.checkExpressionValueIsNotNull(string14, "(this as java.lang.String).substring(startIndex)");
                        jarPath = string14;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, ':', false, 2, null)) break block13;
                    string10 = jarPath;
                    n5 = 1;
                    bl3 = false;
                    String string15 = string10;
                    if (string15 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string16 = string15.substring(n5);
                    Intrinsics.checkExpressionValueIsNotNull(string16, "(this as java.lang.String).substring(startIndex)");
                    jarPath = string16;
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    private static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file;
        Serializable serializable;
        try {
            serializable = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            serializable = null;
        }
        catch (URISyntaxException e) {
            serializable = null;
        }
        if ((file = serializable) == null) {
            serializable = $this$toFileOrNull;
            boolean bl = false;
            boolean bl2 = false;
            Serializable $this$run = serializable;
            boolean bl3 = false;
            file = Intrinsics.areEqual(((URL)$this$run).getProtocol(), FILE_PROTOCOL) ^ true ? null : new File(((URL)$this$run).getFile());
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchMaybeVersionedFile(@NotNull File $this$matchMaybeVersionedFile, String baseName) {
        if (Intrinsics.areEqual($this$matchMaybeVersionedFile.getName(), baseName)) return true;
        if (Intrinsics.areEqual($this$matchMaybeVersionedFile.getName(), StringsKt.removeSuffix(baseName, (CharSequence)".jar"))) return true;
        Regex regex = new Regex(Regex.Companion.escape(StringsKt.removeSuffix(baseName, (CharSequence)".jar")) + "(-\\d.*)?\\.jar");
        String string = $this$matchMaybeVersionedFile.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "name");
        if (!regex.matches(string)) return false;
        return true;
    }

    public static final /* synthetic */ List access$getCOMPILER_JARS$p() {
        return COMPILER_JARS;
    }

    public static final /* synthetic */ boolean access$matchMaybeVersionedFile(File $this$access_u24matchMaybeVersionedFile, String baseName) {
        return FindCompilerKt.matchMaybeVersionedFile($this$access_u24matchMaybeVersionedFile, baseName);
    }
}

