/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

final class CollectPreconditions {
    static void checkEntryNotNull(Object key, Object value2) {
        if (key == null) {
            throw new NullPointerException("null key in entry: null=" + value2);
        }
        if (value2 == null) {
            throw new NullPointerException("null value in entry: " + key + "=null");
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value2, String name) {
        if (value2 < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value2);
        }
        return value2;
    }

    static void checkPositive(int value2, String name) {
        if (value2 <= 0) {
            throw new IllegalArgumentException(name + " must be positive but was: " + value2);
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

