/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageOrClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"resolveToPackageOrClass", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageOrClass;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "resolve"})
public final class FirImportResolveTransformerKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PackageOrClass resolveToPackageOrClass(@NotNull FirSymbolProvider symbolProvider2, @NotNull FqName fqName2) {
        void $this$mapTo$iv$iv;
        int prefixSize;
        Intrinsics.checkParameterIsNotNull(symbolProvider2, "symbolProvider");
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        FqName currentPackage = fqName2;
        List<Name> list2 = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "fqName.pathSegments()");
        List<Name> pathSegments = list2;
        for (prefixSize = pathSegments.size(); !currentPackage.isRoot() && prefixSize > 0 && symbolProvider2.getPackage(currentPackage) == null; --prefixSize) {
            Intrinsics.checkExpressionValueIsNotNull(currentPackage.parent(), "currentPackage.parent()");
        }
        if (Intrinsics.areEqual(currentPackage, fqName2)) {
            return new PackageOrClass(currentPackage, null);
        }
        Iterable $this$map$iv = RangesKt.until(prefixSize, pathSegments.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = pathSegments.get((int)it).asString();
            collection.add(string2);
        }
        FqName fqName3 = FqName.fromSegments((List)destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "FqName.fromSegments((pre\u2026egments[it].asString() })");
        FqName relativeClassFqName = fqName3;
        ClassId classId = new ClassId(currentPackage, relativeClassFqName, false);
        if (symbolProvider2.getClassLikeSymbolByFqName(classId) == null) {
            return null;
        }
        return new PackageOrClass(currentPackage, relativeClassFqName);
    }
}

