/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    public static final TextAttributesKey[] EMPTY_ARRAY = new TextAttributesKey[0];
    private static final Logger LOG = Logger.getInstance(TextAttributesKey.class);
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = new ConcurrentHashMap<String, TextAttributesKey>();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        @Override
        @Nullable
        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    private final String myExternalName;
    private final TextAttributes myDefaultAttributes;
    private final TextAttributesKey myFallbackAttributeKey;
    private static final ThreadLocal<Set<String>> CALLED_RECURSIVELY = ThreadLocal.withInitial(() -> new THashSet());
    @Deprecated
    static final TextAttributesKey DUMMY_DEPRECATED_ATTRIBUTES = TextAttributesKey.createTextAttributesKey("__deprecated__");

    private TextAttributesKey(@NotNull String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        JBIterable<TextAttributesKey> it;
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(0);
        }
        this.myExternalName = externalName;
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = fallbackAttributeKey;
        if (fallbackAttributeKey != null && this.equals((it = JBIterable.generate(this.myFallbackAttributeKey, o -> o == this ? null : o.myFallbackAttributeKey)).find(o -> this.equals(o)))) {
            throw new IllegalArgumentException("Can't use this fallback key: " + fallbackAttributeKey + ": Cycle detected: " + StringUtil.join(it, "->"));
        }
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(2);
        }
        TextAttributesKey textAttributesKey = ourRegistry.computeIfAbsent(externalName, name -> new TextAttributesKey((String)name, null, null));
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(3);
        }
        return textAttributesKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        if (key == null) {
            TextAttributesKey.$$$reportNull$$$0(5);
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(6);
        }
        TextAttributesKey textAttributesKey = TextAttributesKey.find(externalName);
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(7);
        }
        return textAttributesKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextAttributesKey";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeKeys";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempTextAttributesKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTextAttributesKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mergeKeys";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTempTextAttributesKey";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeTextAttributesKey";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isTemp";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface TextAttributeKeyDefaultsProvider {
    }
}

