/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Configuration;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.DownloadStatus;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNode;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.ResolveData;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.repo.RepoDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.util.Version;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.url.URLRepository;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.url.URLResource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.BasicResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;

public abstract class AbstractOSGiResolver
extends BasicResolver {
    private static final String CAPABILITY_EXTRA_ATTR = "osgi_bundle";
    protected static final RepoDescriptor FAILING_REPO_DESCRIPTOR = new EditableRepoDescriptor(null, null);
    private RepoDescriptor repoDescriptor = null;
    private URLRepository repository = new URLRepository();
    private RequirementStrategy requirementStrategy = RequirementStrategy.noambiguity;

    public void setRequirementStrategy(RequirementStrategy importPackageStrategy) {
        this.requirementStrategy = importPackageStrategy;
    }

    public void setRequirementStrategy(String strategy) {
        this.setRequirementStrategy(RequirementStrategy.valueOf(strategy));
    }

    protected void setRepoDescriptor(RepoDescriptor repoDescriptor) {
        this.repoDescriptor = repoDescriptor;
    }

    public URLRepository getRepository() {
        return this.repository;
    }

    protected void ensureInit() {
        if (this.repoDescriptor == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                this.repoDescriptor = FAILING_REPO_DESCRIPTOR;
                throw new RuntimeException("Error while loading the OSGi repo descriptor" + e.getMessage() + " (" + e.getClass().getName() + ")", e);
            }
        } else if (this.repoDescriptor == FAILING_REPO_DESCRIPTOR) {
            throw new RuntimeException("The repository " + this.getName() + " already failed to load");
        }
    }

    protected abstract void init();

    public RepoDescriptor getRepoDescriptor() {
        this.ensureInit();
        return this.repoDescriptor;
    }

    @Override
    public boolean isAllownomd() {
        return false;
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        String osgiType = mrid.getOrganisation();
        if (osgiType == null) {
            throw new RuntimeException("Unsupported OSGi module Id: " + mrid.getModuleId());
        }
        String id = mrid.getName();
        Collection<ModuleDescriptor> mds = ModuleDescriptorWrapper.unwrap(this.getRepoDescriptor().findModules(osgiType, id));
        if (mds == null || mds.isEmpty()) {
            Message.verbose("\t " + id + " not found.");
            return null;
        }
        ResolvedResource[] ret = "bundle".equals(osgiType) ? this.findBundle(dd, data, mds) : this.findCapability(dd, data, mds);
        ResolvedResource found = this.findResource(ret, this.getDefaultRMDParser(dd.getDependencyId()), mrid, data.getDate());
        if (found == null) {
            Message.debug("\t" + this.getName() + ": no resource found for " + mrid);
        }
        return found;
    }

    public ResolvedResource[] findBundle(DependencyDescriptor dd, ResolveData data, Collection<ModuleDescriptor> mds) {
        ResolvedResource[] ret = new ResolvedResource[mds.size()];
        int i = 0;
        for (ModuleDescriptor md : mds) {
            MetadataArtifactDownloadReport report = new MetadataArtifactDownloadReport(null);
            report.setDownloadStatus(DownloadStatus.NO);
            report.setSearched(true);
            ResolvedModuleRevision rmr = new ResolvedModuleRevision(this, this, md, report);
            MDResolvedResource mdrr = new MDResolvedResource(null, md.getRevision(), rmr);
            ret[i++] = mdrr;
        }
        return ret;
    }

    public ResolvedResource[] findCapability(DependencyDescriptor dd, ResolveData data, Collection<ModuleDescriptor> mds) {
        ResolvedResource[] ret = new ResolvedResource[mds.size()];
        int i = 0;
        for (ModuleDescriptor md : mds) {
            IvyNode node = data.getNode(md.getModuleRevisionId());
            if (node != null && node.getDescriptor() != null) {
                return new ResolvedResource[]{this.buildResolvedCapabilityMd(dd, node.getDescriptor())};
            }
            ret[i++] = this.buildResolvedCapabilityMd(dd, md);
        }
        return ret;
    }

    private MDResolvedResource buildResolvedCapabilityMd(DependencyDescriptor dd, ModuleDescriptor md) {
        String org = dd.getDependencyRevisionId().getOrganisation();
        String name = dd.getDependencyRevisionId().getName();
        String rev = md.getExtraInfoContentByTagName("_osgi_export_" + name);
        ModuleRevisionId capabilityRev = ModuleRevisionId.newInstance(org, name, rev, Collections.singletonMap(CAPABILITY_EXTRA_ATTR, md.getModuleRevisionId().toString()));
        DefaultModuleDescriptor capabilityMd = new DefaultModuleDescriptor(capabilityRev, this.getSettings().getStatusManager().getDefaultStatus(), new Date());
        String useConf = "use_" + dd.getDependencyRevisionId().getName();
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_DEFAULT);
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_OPTIONAL);
        capabilityMd.addConfiguration(BundleInfoAdapter.CONF_TRANSITIVE_OPTIONAL);
        capabilityMd.addConfiguration(new Configuration(useConf));
        DefaultDependencyDescriptor capabilityDD = new DefaultDependencyDescriptor(md.getModuleRevisionId(), false);
        capabilityDD.addDependencyConfiguration("default", "default");
        capabilityDD.addDependencyConfiguration("optional", "optional");
        capabilityDD.addDependencyConfiguration("transitive-optional", "transitive-optional");
        capabilityDD.addDependencyConfiguration(useConf, useConf);
        capabilityMd.addDependency(capabilityDD);
        MetadataArtifactDownloadReport report = new MetadataArtifactDownloadReport(null);
        report.setDownloadStatus(DownloadStatus.NO);
        report.setSearched(true);
        ResolvedModuleRevision rmr = new ResolvedModuleRevision(this, this, capabilityMd, report);
        return new MDResolvedResource(null, capabilityMd.getRevision(), rmr);
    }

    @Override
    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date) {
        ResolvedResource found = super.findResource(rress, rmdparser, mrid, date);
        if (found == null) {
            return null;
        }
        String osgiType = mrid.getOrganisation();
        if (!"bundle".equals(osgiType)) {
            if (rress.length != 1) {
                HashMap<String, ArrayList<MDResolvedResource>> matching = new HashMap<String, ArrayList<MDResolvedResource>>();
                for (int i = 0; i < rress.length; ++i) {
                    String name = ((MDResolvedResource)rress[i]).getResolvedModuleRevision().getDescriptor().getExtraAttribute(CAPABILITY_EXTRA_ATTR);
                    ArrayList<MDResolvedResource> list = (ArrayList<MDResolvedResource>)matching.get(name);
                    if (list == null) {
                        list = new ArrayList<MDResolvedResource>();
                        matching.put(name, list);
                    }
                    list.add((MDResolvedResource)rress[i]);
                }
                if (matching.keySet().size() != 1) {
                    if (this.requirementStrategy == RequirementStrategy.first) {
                        Message.warn("Ambiguity for the '" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision());
                        for (Map.Entry entry : matching.entrySet()) {
                            Message.warn("\t" + (String)entry.getKey());
                            for (MDResolvedResource c : (List)entry.getValue()) {
                                Message.warn("\t\t" + c.getRevision() + (found == c ? " (selected)" : ""));
                            }
                        }
                    } else if (this.requirementStrategy == RequirementStrategy.noambiguity) {
                        Message.error("Ambiguity for the '" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision());
                        for (Map.Entry entry : matching.entrySet()) {
                            Message.error("\t" + (String)entry.getKey());
                            for (MDResolvedResource c : (List)entry.getValue()) {
                                Message.error("\t\t" + c.getRevision() + (found == c ? " (best match)" : ""));
                            }
                        }
                        return null;
                    }
                }
            }
            Message.info("'" + osgiType + "' requirement " + mrid.getName() + ";version=" + mrid.getRevision() + " satisfied by " + ((MDResolvedResource)found).getResolvedModuleRevision().getId().getName() + ";" + found.getRevision());
        }
        return found;
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        URL url = artifact.getUrl();
        if (url == null) {
            return null;
        }
        Message.verbose("\tusing url for " + artifact + ": " + url);
        this.logArtifactAttempt(artifact, url.toExternalForm());
        URLResource resource = new URLResource(url);
        return new ResolvedResource(resource, artifact.getModuleRevisionId().getRevision());
    }

    @Override
    protected void checkModuleDescriptorRevision(ModuleDescriptor systemMd, ModuleRevisionId systemMrid) {
        String osgiType = systemMrid.getOrganisation();
        if (osgiType == null || osgiType.equals("bundle")) {
            super.checkModuleDescriptorRevision(systemMd, systemMrid);
        }
    }

    @Override
    protected Collection filterNames(Collection names) {
        this.getSettings().filterIgnore(names);
        return names;
    }

    @Override
    protected Collection findNames(Map tokenValues, String token) {
        if ("organisation".equals(token)) {
            return this.getRepoDescriptor().getCapabilities();
        }
        String osgiType = (String)tokenValues.get("organisation");
        if (osgiType == null || osgiType.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        if ("module".equals(token)) {
            return this.getRepoDescriptor().getCapabilityValues(osgiType);
        }
        if ("revision".equals(token)) {
            String name = (String)tokenValues.get("module");
            ArrayList<String> versions = new ArrayList<String>();
            Set<ModuleDescriptorWrapper> mds = this.getRepoDescriptor().findModules(osgiType, name);
            if (mds != null) {
                for (ModuleDescriptorWrapper md : mds) {
                    versions.add(md.getBundleInfo().getVersion().toString());
                }
            }
            return versions;
        }
        if ("conf".equals(token)) {
            String name = (String)tokenValues.get("module");
            if (name == null) {
                return Collections.EMPTY_LIST;
            }
            if (osgiType.equals("package")) {
                return Collections.singletonList("use_" + name);
            }
            Collection<ModuleDescriptor> mds = ModuleDescriptorWrapper.unwrap(this.getRepoDescriptor().findModules(osgiType, name));
            if (mds == null) {
                return Collections.EMPTY_LIST;
            }
            String version = (String)tokenValues.get("revision");
            if (version == null) {
                return Collections.EMPTY_LIST;
            }
            ModuleDescriptor found = null;
            for (ModuleDescriptor md : mds) {
                if (!md.getRevision().equals(version)) continue;
                found = md;
            }
            if (found == null) {
                return Collections.EMPTY_LIST;
            }
            List<String> confs = Arrays.asList(found.getConfigurationsNames());
            return confs;
        }
        return Collections.EMPTY_LIST;
    }

    private void filterCapabilityValues(Set<String> capabilityValues, Map<String, Set<ModuleDescriptor>> moduleByCapbilityValue, Map<String, String> tokenValues, String rev) {
        if (rev == null) {
            capabilityValues.addAll(moduleByCapbilityValue.keySet());
        } else {
            for (Map.Entry<String, Set<ModuleDescriptor>> entry : moduleByCapbilityValue.entrySet()) {
                Iterator<ModuleDescriptor> itModules = entry.getValue().iterator();
                boolean moduleMatchRev = false;
                while (!moduleMatchRev && itModules.hasNext()) {
                    ModuleDescriptor md = itModules.next();
                    moduleMatchRev = rev.equals(md.getRevision());
                }
                if (!moduleMatchRev) continue;
                capabilityValues.add(entry.getKey());
            }
        }
    }

    @Override
    public Map[] listTokenValues(String[] tokens, Map criteria) {
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        Set<Map<String, String>> listTokenValues = this.listTokenValues(tokenSet, (Map<String, String>)criteria);
        return listTokenValues.toArray(new Map[listTokenValues.size()]);
    }

    private Set<Map<String, String>> listTokenValues(Set<String> tokens, Map<String, String> criteria) {
        if (tokens.isEmpty()) {
            return Collections.singleton(criteria);
        }
        HashSet<String> remainingTokens = new HashSet<String>(tokens);
        HashMap<String, String> values2 = new HashMap<String, String>();
        remainingTokens.remove("organisation");
        String osgiType = criteria.get("organisation");
        if (osgiType == null || osgiType.length() == 0) {
            return Collections.emptySet();
        }
        values2.put("organisation", osgiType);
        if (osgiType == null) {
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>();
            HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
            newCriteria.put("organisation", "bundle");
            tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            newCriteria = new HashMap<String, String>(criteria);
            newCriteria.put("organisation", "package");
            tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            newCriteria = new HashMap<String, String>(criteria);
            newCriteria.put("organisation", "service");
            tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            return tokenValues;
        }
        Set<String> capabilities = this.getRepoDescriptor().getCapabilityValues(osgiType);
        if (capabilities == null || capabilities.isEmpty()) {
            return Collections.emptySet();
        }
        remainingTokens.remove("module");
        String module = criteria.get("module");
        if (module == null) {
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>();
            for (String name : capabilities) {
                HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
                newCriteria.put("module", name);
                tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            }
            return tokenValues;
        }
        values2.put("module", module);
        remainingTokens.remove("revision");
        String rev = criteria.get("revision");
        if (rev == null) {
            Set<ModuleDescriptorWrapper> mdws = this.getRepoDescriptor().findModules(osgiType, module);
            if (mdws == null || mdws.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>();
            for (ModuleDescriptorWrapper mdw : mdws) {
                HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
                newCriteria.put("revision", mdw.getBundleInfo().getVersion().toString());
                tokenValues.addAll(this.listTokenValues(remainingTokens, newCriteria));
            }
            return tokenValues;
        }
        values2.put("revision", rev);
        remainingTokens.remove("conf");
        String conf = criteria.get("conf");
        if (conf == null) {
            Version v;
            if (osgiType.equals("package")) {
                values2.put("conf", "use_" + module);
                return Collections.singleton(values2);
            }
            Set<ModuleDescriptorWrapper> bundles = this.getRepoDescriptor().findModules(osgiType, module);
            if (bundles == null) {
                return Collections.emptySet();
            }
            try {
                v = new Version(rev);
            }
            catch (ParseException e) {
                return Collections.emptySet();
            }
            ModuleDescriptorWrapper found = null;
            for (ModuleDescriptorWrapper bundle : bundles) {
                if (!bundle.getBundleInfo().getVersion().equals(v)) continue;
                found = bundle;
            }
            if (found == null) {
                return Collections.emptySet();
            }
            HashSet<Map<String, String>> tokenValues = new HashSet<Map<String, String>>();
            List<String> configurations = BundleInfoAdapter.getConfigurations(found.getBundleInfo());
            for (int i = 0; i < configurations.size(); ++i) {
                HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
                newCriteria.put("conf", configurations.get(i));
                tokenValues.add(newCriteria);
            }
            return tokenValues;
        }
        values2.put("conf", conf);
        return Collections.singleton(values2);
    }

    @Override
    protected long get(Resource resource, File dest) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + dest);
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        this.getRepository().get(resource.getName(), dest);
        return dest.length();
    }

    @Override
    protected Resource getResource(String source) throws IOException {
        return this.getRepository().getResource(source);
    }

    @Override
    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static class RequirementStrategy {
        public static RequirementStrategy first = new RequirementStrategy();
        public static RequirementStrategy noambiguity = new RequirementStrategy();

        public static RequirementStrategy valueOf(String strategy) {
            if (strategy.equals("first")) {
                return first;
            }
            if (strategy.equals("noambiguity")) {
                return noambiguity;
            }
            throw new IllegalStateException();
        }
    }
}

