/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.ModuleEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.OrganisationEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.search.RevisionEntry;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.Matcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.MatcherHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.PatternMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.namespace.Namespace;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.AbstractResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.DependencyResolver;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;

public class SearchEngine {
    private IvySettings settings;

    public SearchEngine(IvySettings settings) {
        this.settings = settings;
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        LinkedHashSet entries = new LinkedHashSet();
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] values2 = resolver.listTokenValues(new String[]{token}, otherTokenValues);
            for (int i = 0; i < values2.length; ++i) {
                entries.add(values2[i].get(token));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public OrganisationEntry[] listOrganisationEntries() {
        HashSet<OrganisationEntry> entries = new HashSet<OrganisationEntry>();
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] orgs = resolver.listTokenValues(new String[]{"organisation"}, new HashMap());
            for (int i = 0; i < orgs.length; ++i) {
                String org = (String)orgs[i].get("organisation");
                entries.add(new OrganisationEntry(resolver, org));
            }
        }
        return entries.toArray(new OrganisationEntry[entries.size()]);
    }

    public String[] listOrganisations() {
        HashSet entries = new HashSet();
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] orgs = resolver.listTokenValues(new String[]{"organisation"}, new HashMap());
            for (int i = 0; i < orgs.length; ++i) {
                entries.add(orgs[i].get("organisation"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public ModuleEntry[] listModuleEntries(OrganisationEntry org) {
        HashSet<ModuleEntry> entries = new HashSet<ModuleEntry>();
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org.getOrganisation());
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] modules = resolver.listTokenValues(new String[]{"module"}, tokenValues);
            for (int i = 0; i < modules.length; ++i) {
                String module = (String)modules[i].get("module");
                entries.add(new ModuleEntry(org, module));
            }
        }
        return entries.toArray(new ModuleEntry[entries.size()]);
    }

    public String[] listModules(String org) {
        HashSet entries = new HashSet();
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org);
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] modules = resolver.listTokenValues(new String[]{"module"}, tokenValues);
            for (int i = 0; i < modules.length; ++i) {
                entries.add(modules[i].get("module"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public RevisionEntry[] listRevisionEntries(ModuleEntry module) {
        HashSet<RevisionEntry> entries = new HashSet<RevisionEntry>();
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", module.getOrganisation());
        tokenValues.put("module", module.getModule());
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] revisions = resolver.listTokenValues(new String[]{"revision"}, tokenValues);
            for (int i = 0; i < revisions.length; ++i) {
                String revision = (String)revisions[i].get("revision");
                entries.add(new RevisionEntry(module, revision));
            }
        }
        return entries.toArray(new RevisionEntry[entries.size()]);
    }

    public String[] listRevisions(String org, String module) {
        HashSet entries = new HashSet();
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org);
        tokenValues.put("module", module);
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] revisions = resolver.listTokenValues(new String[]{"revision"}, tokenValues);
            for (int i = 0; i < revisions.length; ++i) {
                entries.add(revisions[i].get("revision"));
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    public ModuleId[] listModules(ModuleId moduleCrit, PatternMatcher matcher) {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        HashMap criteria = new HashMap();
        this.addMatcher(matcher, moduleCrit.getOrganisation(), criteria, "organisation");
        this.addMatcher(matcher, moduleCrit.getName(), criteria, "module");
        String[] tokensToList = new String[]{"organisation", "module"};
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] moduleIdAsMap = resolver.listTokenValues(tokensToList, criteria);
            for (int i = 0; i < moduleIdAsMap.length; ++i) {
                String org = (String)moduleIdAsMap[i].get("organisation");
                String name = (String)moduleIdAsMap[i].get("module");
                ModuleId modId = ModuleId.newInstance(org, name);
                ret.add(NameSpaceHelper.transform(modId, resolver.getNamespace().getToSystemTransformer()));
            }
        }
        return ret.toArray(new ModuleId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(ModuleRevisionId moduleCrit, PatternMatcher matcher) {
        ArrayList<ModuleRevisionId> ret = new ArrayList<ModuleRevisionId>();
        HashMap criteria = new HashMap();
        for (Map.Entry entry : moduleCrit.getAttributes().entrySet()) {
            this.addMatcher(matcher, (String)entry.getValue(), criteria, (String)entry.getKey());
        }
        String[] tokensToList = moduleCrit.getAttributes().keySet().toArray(new String[moduleCrit.getAttributes().size()]);
        for (DependencyResolver resolver : this.settings.getResolvers()) {
            Map[] moduleIdAsMap = resolver.listTokenValues(tokensToList, criteria);
            for (int i = 0; i < moduleIdAsMap.length; ++i) {
                String org = (String)moduleIdAsMap[i].get("organisation");
                String name = (String)moduleIdAsMap[i].get("module");
                String branch = (String)moduleIdAsMap[i].get("branch");
                String rev = (String)moduleIdAsMap[i].get("revision");
                HashMap<String, String> foundExtraAtts = new HashMap<String, String>();
                Set qualAttributes = moduleCrit.getQualifiedExtraAttributes().keySet();
                for (String qualifiedKey : qualAttributes) {
                    String value = null;
                    int colonIndex = qualifiedKey.indexOf(58);
                    value = colonIndex == -1 ? (String)moduleIdAsMap[i].get(qualifiedKey) : (String)moduleIdAsMap[i].get(qualifiedKey.substring(colonIndex + 1));
                    if (value == null) continue;
                    foundExtraAtts.put(qualifiedKey, value);
                }
                ModuleRevisionId modRevId = ModuleRevisionId.newInstance(org, name, branch, rev, foundExtraAtts);
                ret.add(resolver.getNamespace().getToSystemTransformer().transform(modRevId));
            }
        }
        return ret.toArray(new ModuleRevisionId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(DependencyResolver resolver, ModuleRevisionId moduleCrit, PatternMatcher matcher) {
        HashMap criteria = new HashMap();
        for (Map.Entry entry : moduleCrit.getAttributes().entrySet()) {
            this.addMatcher(matcher, (String)entry.getValue(), criteria, (String)entry.getKey());
        }
        String[] tokensToList = moduleCrit.getAttributes().keySet().toArray(new String[moduleCrit.getAttributes().size()]);
        Map[] moduleIdAsMap = resolver.listTokenValues(tokensToList, criteria);
        LinkedHashSet<ModuleRevisionId> result = new LinkedHashSet<ModuleRevisionId>();
        for (int i = 0; i < moduleIdAsMap.length; ++i) {
            String org = (String)moduleIdAsMap[i].get("organisation");
            String name = (String)moduleIdAsMap[i].get("module");
            String branch = (String)moduleIdAsMap[i].get("branch");
            String rev = (String)moduleIdAsMap[i].get("revision");
            HashMap<String, String> foundExtraAtts = new HashMap<String, String>();
            Set qualExtraAttributes = moduleCrit.getQualifiedExtraAttributes().keySet();
            for (String qualifiedKey : qualExtraAttributes) {
                String value = null;
                int colonIndex = qualifiedKey.indexOf(58);
                value = colonIndex == -1 ? (String)moduleIdAsMap[i].get(qualifiedKey) : (String)moduleIdAsMap[i].get(qualifiedKey.substring(colonIndex + 1));
                if (value == null) continue;
                foundExtraAtts.put(qualifiedKey, value);
            }
            ModuleRevisionId modRevId = ModuleRevisionId.newInstance(org, name, branch, rev, foundExtraAtts);
            result.add(resolver.getNamespace().getToSystemTransformer().transform(modRevId));
        }
        return result.toArray(new ModuleRevisionId[result.size()]);
    }

    private void addMatcher(PatternMatcher patternMatcher, String expression, Map criteria, String key) {
        if (expression == null) {
            return;
        }
        Matcher matcher = patternMatcher.getMatcher(expression);
        if (matcher.isExact()) {
            criteria.put(key, expression);
        } else {
            criteria.put(key, matcher);
        }
    }

    public Collection findModuleRevisionIds(DependencyResolver resolver, ModuleRevisionId pattern, PatternMatcher matcher) {
        ArrayList<ModuleRevisionId> mrids = new ArrayList<ModuleRevisionId>();
        String resolverName = resolver.getName();
        Message.verbose("looking for modules matching " + pattern + " using " + matcher.getName());
        Namespace fromNamespace = null;
        if (resolver instanceof AbstractResolver) {
            fromNamespace = ((AbstractResolver)resolver).getNamespace();
        }
        ArrayList<ModuleEntry> modules = new ArrayList<ModuleEntry>();
        OrganisationEntry[] orgs = resolver.listOrganisations();
        if (orgs == null || orgs.length == 0) {
            String org = pattern.getOrganisation();
            if (fromNamespace != null) {
                org = NameSpaceHelper.transform(pattern.getModuleId(), fromNamespace.getFromSystemTransformer()).getOrganisation();
            }
            modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
        } else {
            Matcher orgMatcher = matcher.getMatcher(pattern.getOrganisation());
            for (int i = 0; i < orgs.length; ++i) {
                String org;
                String systemOrg = org = orgs[i].getOrganisation();
                if (fromNamespace != null) {
                    systemOrg = NameSpaceHelper.transformOrganisation(org, fromNamespace.getToSystemTransformer());
                }
                if (!orgMatcher.matches(systemOrg)) continue;
                modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
            }
        }
        Message.debug("found " + modules.size() + " modules for " + pattern.getOrganisation() + " on " + resolverName);
        boolean foundModule = false;
        for (ModuleEntry mEntry : modules) {
            ModuleId foundMid;
            ModuleId systemMid = foundMid = new ModuleId(mEntry.getOrganisation(), mEntry.getModule());
            if (fromNamespace != null) {
                systemMid = NameSpaceHelper.transform(foundMid, fromNamespace.getToSystemTransformer());
            }
            if (!MatcherHelper.matches(matcher, pattern.getModuleId(), systemMid)) continue;
            foundModule = true;
            RevisionEntry[] rEntries = resolver.listRevisions(mEntry);
            Message.debug("found " + rEntries.length + " revisions for [" + mEntry.getOrganisation() + ", " + mEntry.getModule() + "] on " + resolverName);
            boolean foundRevision = false;
            for (int j = 0; j < rEntries.length; ++j) {
                ModuleRevisionId foundMrid;
                RevisionEntry rEntry = rEntries[j];
                ModuleRevisionId systemMrid = foundMrid = ModuleRevisionId.newInstance(mEntry.getOrganisation(), mEntry.getModule(), rEntry.getRevision());
                if (fromNamespace != null) {
                    systemMrid = fromNamespace.getToSystemTransformer().transform(foundMrid);
                }
                if (!MatcherHelper.matches(matcher, pattern, systemMrid)) continue;
                foundRevision = true;
                mrids.add(systemMrid);
            }
            if (foundRevision) continue;
            Message.debug("no revision found matching " + pattern + " in [" + mEntry.getOrganisation() + "," + mEntry.getModule() + "] using " + resolverName);
        }
        if (!foundModule) {
            Message.debug("no module found matching " + pattern + " using " + resolverName);
        }
        return mrids;
    }
}

