/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedClassDescriptor;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.ir.SourceManager;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.PsiSourceManager;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FileClassLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "createFileClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileClassMembers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lower", "", "backend.jvm"})
final class FileClassLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        ArrayList<IrDeclaration> classes2 = new ArrayList<IrDeclaration>();
        ArrayList<IrDeclaration> fileClassMembers = new ArrayList<IrDeclaration>();
        Iterable $this$forEach$iv = irFile.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (it instanceof IrClass) {
                classes2.add(it);
                continue;
            }
            fileClassMembers.add(it);
        }
        if (fileClassMembers.isEmpty()) {
            MetadataSource.File file2 = irFile.getMetadata();
            $this$forEach$iv = file2 != null ? file2.getDescriptors() : null;
            boolean bl = false;
            boolean bl2 = false;
            if ($this$forEach$iv == null || $this$forEach$iv.isEmpty()) {
                return;
            }
        }
        IrClass irFileClass = this.createFileClass(irFile, (List<? extends IrDeclaration>)fileClassMembers);
        classes2.add(irFileClass);
        irFile.getDeclarations().clear();
        irFile.getDeclarations().addAll((Collection<IrDeclaration>)classes2);
    }

    private final IrClass createFileClass(IrFile irFile, List<? extends IrDeclaration> fileClassMembers) {
        SourceManager.FileEntry fileEntry;
        SourceManager.FileEntry fileEntry2 = fileEntry = irFile.getFileEntry();
        if (fileEntry2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi2ir.PsiSourceManager.PsiFileEntry");
        }
        KtFile ktFile = this.context.getPsiSourceManager().getKtFile((PsiSourceManager.PsiFileEntry)fileEntry2);
        if (ktFile == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected file entry: " + fileEntry)));
        }
        KtFile ktFile2 = ktFile;
        JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile2);
        WrappedClassDescriptor descriptor2 = new WrappedClassDescriptor(null, new KotlinSourceElement(ktFile2), 1, null);
        int n = fileEntry.getMaxOffset();
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.FILE_CLASS.INSTANCE;
        IrClassSymbol irClassSymbol = new IrClassSymbolImpl(descriptor2);
        Name name = fileClassInfo.getFileClassFqName().shortName();
        Intrinsics.checkExpressionValueIsNotNull(name, "fileClassInfo.fileClassFqName.shortName()");
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PUBLIC");
        IrClassImpl irClassImpl = new IrClassImpl(0, n, irDeclarationOrigin, irClassSymbol, name, ClassKind.CLASS, visibility, Modality.FINAL, false, false, false, false, false);
        boolean bl = false;
        boolean bl2 = false;
        IrClassImpl $this$apply = irClassImpl;
        boolean bl3 = false;
        descriptor2.bind((IrDeclaration)$this$apply);
        $this$apply.getSuperTypes().add(this.context.getIrBuiltIns().getAnyType());
        $this$apply.setParent(irFile);
        $this$apply.getDeclarations().addAll((Collection<IrDeclaration>)fileClassMembers);
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$apply);
        Iterable $this$forEach$iv = fileClassMembers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunction it;
            IrOverridableDeclaration<IrSimpleFunctionSymbol> irOverridableDeclaration;
            boolean bl4;
            boolean bl5;
            IrDeclaration it2 = (IrDeclaration)element$iv;
            boolean bl6 = false;
            it2.setParent($this$apply);
            if (!(it2 instanceof IrProperty)) continue;
            if (((IrProperty)it2).getGetter() != null) {
                bl5 = false;
                bl4 = false;
                it = irOverridableDeclaration;
                boolean bl7 = false;
                it.setParent($this$apply);
            }
            if (((IrProperty)it2).getSetter() != null) {
                bl5 = false;
                bl4 = false;
                it = irOverridableDeclaration;
                boolean bl8 = false;
                it.setParent($this$apply);
            }
            if (((IrProperty)it2).getBackingField() == null) continue;
            bl5 = false;
            bl4 = false;
            it = irOverridableDeclaration;
            boolean bl9 = false;
            it.setParent($this$apply);
        }
        $this$apply.setMetadata(irFile.getMetadata());
        Type type2 = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFileClassFqName());
        Intrinsics.checkExpressionValueIsNotNull(type2, "AsmUtil.asmTypeByFqNameW\u2026lassInfo.fileClassFqName)");
        Type partClassType = type2;
        Type facadeClassType = fileClassInfo.getWithJvmMultifileClass() ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFacadeClassFqName()) : null;
        PackagePartRegistry packagePartRegistry = this.context.getState().getFactory().getPackagePartRegistry();
        FqName fqName2 = irFile.getFqName();
        String string = partClassType.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "partClassType.internalName");
        Type type3 = facadeClassType;
        packagePartRegistry.addPart(fqName2, string, type3 != null ? type3.getInternalName() : null);
        return irClassImpl;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public FileClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }
}

