/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.extensions;

import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.extensions.ReplFactoryExtension;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiler;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.repl.GenericReplCompiler;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/scripting/extensions/JvmStandardReplFactoryExtension;", "Lorg/jetbrains/kotlin/cli/common/extensions/ReplFactoryExtension;", "()V", "makeReplCompiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "templateClassName", "", "templateClasspath", "", "Ljava/io/File;", "baseClassLoader", "Ljava/lang/ClassLoader;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "projectEnvironment", "Lcom/intellij/core/JavaCoreProjectEnvironment;", "makeScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "kotlin-scripting-compiler-impl"})
public final class JvmStandardReplFactoryExtension
implements ReplFactoryExtension {
    @NotNull
    public ReplCompiler makeReplCompiler(@NotNull String templateClassName, @NotNull List<? extends File> templateClasspath, @Nullable ClassLoader baseClassLoader, @NotNull CompilerConfiguration configuration, @NotNull JavaCoreProjectEnvironment projectEnvironment) {
        Intrinsics.checkParameterIsNotNull((Object)templateClassName, (String)"templateClassName");
        Intrinsics.checkParameterIsNotNull(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)projectEnvironment, (String)"projectEnvironment");
        Disposable disposable = projectEnvironment.getParentDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"projectEnvironment.parentDisposable");
        KotlinScriptDefinition kotlinScriptDefinition = this.makeScriptDefinition(templateClasspath, templateClassName, baseClassLoader);
        Object object = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return new GenericReplCompiler(disposable, kotlinScriptDefinition, configuration, (MessageCollector)object);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinScriptDefinition makeScriptDefinition(List<? extends File> templateClasspath, String templateClassName, ClassLoader baseClassLoader) {
        KotlinScriptDefinitionFromAnnotatedTemplate kotlinScriptDefinitionFromAnnotatedTemplate;
        try {
            Class<?> cls;
            Collection<URL> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = templateClasspath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                URL uRL = it.toURI().toURL();
                collection.add(uRL);
            }
            collection = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            collection = uRLArray;
            ClassLoader classLoader2 = baseClassLoader;
            URL[] uRLArray2 = (URL[])collection;
            URLClassLoader classloader = new URLClassLoader(uRLArray2, classLoader2);
            Class<?> clazz = cls = classloader.loadClass(templateClassName);
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"cls");
            kotlinScriptDefinitionFromAnnotatedTemplate = new KotlinScriptDefinitionFromAnnotatedTemplate(JvmClassMappingKt.getKotlinClass(clazz), MapsKt.emptyMap(), null, 4, null);
        }
        catch (ClassNotFoundException ex) {
            throw (Throwable)new IllegalStateException("Cannot find script definition template class " + templateClassName, ex);
        }
        catch (Exception ex) {
            throw (Throwable)new IllegalStateException("Error loading script definition template " + templateClassName, ex);
        }
        return kotlinScriptDefinitionFromAnnotatedTemplate;
    }
}

