/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant.IvyPostResolveTask;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.ResolveReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNode;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNodeCallers;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNodeEviction;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.BuildException;

public class IvyDependencyTree
extends IvyPostResolveTask {
    private Map dependencies = new HashMap();
    private boolean showEvicted = false;

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        ResolveReport report = this.getResolvedReport();
        this.log("Dependency tree for " + report.getResolveId());
        ModuleRevisionId mrid = report.getModuleDescriptor().getModuleRevisionId();
        for (IvyNode dependency : report.getDependencies()) {
            this.populateDependencyTree(dependency, mrid, report);
        }
        this.printDependencies((List)this.dependencies.get(mrid), 0);
    }

    private void printDependencies(List dependencyList, int indent) {
        Iterator iterator = dependencyList.iterator();
        while (iterator.hasNext()) {
            IvyNode dependency = (IvyNode)iterator.next();
            boolean evicted = dependency.isEvicted(this.getConf());
            if (evicted && !this.showEvicted) continue;
            StringBuffer sb = new StringBuffer();
            if (indent > 0) {
                for (int i = 0; i < indent; ++i) {
                    if (i == indent - 1 && !iterator.hasNext() && !this.hasDependencies(dependency)) {
                        sb.append("   ");
                        continue;
                    }
                    sb.append("|  ");
                }
            }
            if (iterator.hasNext()) {
                sb.append("+- ");
            } else {
                sb.append("\\- ");
            }
            sb.append(dependency.getId().toString());
            if (evicted && this.showEvicted) {
                IvyNodeEviction.EvictionData evictedData = dependency.getEvictedData(this.getConf());
                if (evictedData.isTransitivelyEvicted()) {
                    sb.append(" transitively");
                } else {
                    sb.append(" evicted by ");
                    sb.append(evictedData.getSelected());
                    sb.append(" in ").append(evictedData.getParent());
                    if (evictedData.getDetail() != null) {
                        sb.append(" ").append(evictedData.getDetail());
                    }
                }
            }
            this.log(sb.toString());
            this.printDependencies((List)this.dependencies.get(dependency.getId()), indent + 1);
        }
    }

    private boolean hasDependencies(IvyNode dependency) {
        List dependencyList = (List)this.dependencies.get(dependency.getId());
        return dependencyList.size() > 0;
    }

    private void populateDependencyTree(IvyNode dependency, ModuleRevisionId currentMrid, ResolveReport report) {
        this.registerNodeIfNecessary(dependency.getId());
        for (int i = 0; i < dependency.getAllCallers().length; ++i) {
            IvyNodeCallers.Caller caller = dependency.getAllCallers()[i];
            this.addDependency(caller.getModuleRevisionId(), dependency);
        }
    }

    private void registerNodeIfNecessary(ModuleRevisionId moduleRevisionId) {
        if (!this.dependencies.containsKey(moduleRevisionId)) {
            this.dependencies.put(moduleRevisionId, new ArrayList());
        }
    }

    private void addDependency(ModuleRevisionId moduleRevisionId, IvyNode dependency) {
        this.registerNodeIfNecessary(moduleRevisionId);
        List list = (List)this.dependencies.get(moduleRevisionId);
        list.add(dependency);
    }

    public boolean isShowEvicted() {
        return this.showEvicted;
    }

    public void setShowEvicted(boolean showEvicted) {
        this.showEvicted = showEvicted;
    }
}

