/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolveUtilKt;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.AstLoadingFilter;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 I2\u00020\u0001:\u0001IBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ4\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ@\u0010(\u001a\u0016\u0012\u0004\u0012\u00020*\u0012\f\u0012\n\u0012\u0004\u0012\u00020,\u0018\u00010+0)2\u0006\u0010-\u001a\u00020.2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030/2\u0006\u00100\u001a\u0002012\u0006\u0010$\u001a\u00020%H\u0002J \u00102\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u00103\u001a\u0002042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u0002072\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001bJ4\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u0002072\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J4\u00108\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J:\u0010;\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010<0)2\u0006\u00106\u001a\u0002072\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010=\u001a\u00020>2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020B2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010C\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u000207H\u0002J\u0010\u0010F\u001a\u00020>2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001a\u0010G\u001a\b\u0012\u0004\u0012\u0002040H*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "checkSelectorTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "selectorTypeInfo", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getCallExpressionTypeInfo", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getCallExpressionTypeInfoWithoutFinalTypeCheck", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "callOperationNode", "Lcom/intellij/lang/ASTNode;", "initialDataFlowInfoForArguments", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getQualifiedExpressionTypeInfo", "expression", "getResolvedCallForFunction", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "getSafeOrUnsafeSelectorTypeInfo", "element", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "getSimpleNameExpressionTypeInfo", "nameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getUnsafeSelectorTypeInfo", "selectorExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getVariableType", "Lorg/jetbrains/kotlin/types/KotlinType;", "recordResultTypeInfo", "", "resultTypeInfo", "resolveDeferredReceiverInQualifiedExpression", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "resolveSimpleName", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "setExpressionTypingServices", "elementChain", "", "Companion", "frontend"})
public final class CallExpressionResolver {
    private ExpressionTypingServices expressionTypingServices;
    private final CallResolver callResolver;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final KotlinBuiltIns builtIns;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;
    public static final Companion Companion = new Companion(null);

    @Inject
    public final void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        this.expressionTypingServices = expressionTypingServices;
    }

    private final Pair<Boolean, ResolvedCall<FunctionDescriptor>> getResolvedCallForFunction(Call call2, ResolutionContext<?> context, CheckArgumentTypesMode checkArguments, DataFlowInfo initialDataFlowInfoForArguments) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call2, checkArguments, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call2)));
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults, "callResolver.resolveFunc\u2026)\n            )\n        )");
        OverloadResolutionResults<FunctionDescriptor> results = overloadResolutionResults;
        return !results.isNothing() ? new Pair<Boolean, ResolvedCall<FunctionDescriptor>>(true, OverloadResolutionResultsUtil.getResultingCall(results, context)) : new Pair<Boolean, Object>(false, null);
    }

    private final Pair<Boolean, KotlinType> getVariableType(KtSimpleNameExpression nameExpression, Receiver receiver2, ASTNode callOperationNode2, ExpressionTypingContext context) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
        Call call2 = CallMaker.makePropertyCall(receiver2, callOperationNode2, nameExpression);
        Intrinsics.checkExpressionValueIsNotNull(call2, "CallMaker.makePropertyCa\u2026tionNode, nameExpression)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "BasicCallResolutionConte\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults, "callResolver.resolveSimp\u2026perty(contextForVariable)");
        OverloadResolutionResults<VariableDescriptor> resolutionResult = overloadResolutionResults;
        boolean isLHSOfDot = KtPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                temporaryForVariable.commit();
                return new Pair<Boolean, Object>(true, (resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null));
            }
        }
        temporaryForVariable.commit();
        return new Pair<Boolean, Object>(!resolutionResult.isNothing(), (resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null));
    }

    @NotNull
    public final KotlinTypeInfo getSimpleNameExpressionTypeInfo(@NotNull KtSimpleNameExpression nameExpression, @Nullable Receiver receiver2, @Nullable ASTNode callOperationNode2, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(nameExpression, "nameExpression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        return this.getSimpleNameExpressionTypeInfo(nameExpression, receiver2, callOperationNode2, context, dataFlowInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeInfo getSimpleNameExpressionTypeInfo(KtSimpleNameExpression nameExpression, Receiver receiver2, ASTNode callOperationNode2, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        void resolveResult;
        void notNothing;
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", nameExpression);
        Object Context2 = context.replaceTraceAndCache(temporaryForVariable);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceTraceAndCache(temporaryForVariable)");
        Pair<Boolean, KotlinType> pair = this.getVariableType(nameExpression, receiver2, callOperationNode2, (ExpressionTypingContext)Context2);
        boolean bl = pair.component1();
        KotlinType type2 = pair.component2();
        if (notNothing != false) {
            temporaryForVariable.commit();
            return TypeInfoFactoryKt.createTypeInfo(type2, initialDataFlowInfoForArguments);
        }
        Call call2 = CallMaker.makeCall(nameExpression, receiver2, callOperationNode2, nameExpression, CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull(call2, "CallMaker.makeCall(nameE\u2026eExpression, emptyList())");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", nameExpression);
        Object Context3 = context.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkExpressionValueIsNotNull(Context3, "context.replaceTraceAndCache(temporaryForFunction)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context3;
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair2 = this.getResolvedCallForFunction(call3, newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean bl2 = pair2.component1();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = pair2.component2();
        if (resolveResult != false) {
            FunctionDescriptor functionDescriptor;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor2 = functionDescriptor = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            if (!(functionDescriptor instanceof ConstructorDescriptor)) {
                temporaryForFunction.commit();
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)nameExpression), nameExpression, hasValueParameters));
                FunctionDescriptor functionDescriptor3 = functionDescriptor;
                return TypeInfoFactoryKt.createTypeInfo(functionDescriptor3 != null ? functionDescriptor3.getReturnType() : null, context);
            }
        }
        TemporaryTraceAndCache temporaryForQualifier = TemporaryTraceAndCache.create(context, "trace to resolve as qualifier", nameExpression);
        Object Context4 = context.replaceTraceAndCache(temporaryForQualifier);
        Intrinsics.checkExpressionValueIsNotNull(Context4, "context.replaceTraceAndC\u2026he(temporaryForQualifier)");
        ExpressionTypingContext contextForQualifier = (ExpressionTypingContext)Context4;
        Qualifier qualifier = this.qualifiedExpressionResolver.resolveNameExpressionAsQualifierForDiagnostics(nameExpression, receiver2, contextForQualifier);
        if (qualifier != null) {
            Qualifier qualifier2;
            Qualifier it = qualifier2 = qualifier;
            QualifiedExpressionResolveUtilKt.resolveQualifierAsStandaloneExpression(it, contextForQualifier);
            temporaryForQualifier.commit();
        } else {
            temporaryForVariable.commit();
        }
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @NotNull
    public final KotlinTypeInfo getCallExpressionTypeInfo(@NotNull KtCallExpression callExpression, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(callExpression, "callExpression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        KotlinTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, null, null, context, dataFlowInfo);
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (KtExpression)callExpression, (ResolutionContext)context);
        }
        return typeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(KtCallExpression callExpression, Receiver receiver2, ASTNode callOperationNode2, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        void resolveResult;
        Call call2 = CallMaker.makeCall(receiver2, callOperationNode2, callExpression);
        Intrinsics.checkExpressionValueIsNotNull(call2, "CallMaker.makeCall(recei\u2026tionNode, callExpression)");
        Call call3 = call2;
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", callExpression);
        Object Context2 = context.replaceTraceAndCache(temporaryForFunction);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceTraceAndCache(temporaryForFunction)");
        Pair<Boolean, ResolvedCall<FunctionDescriptor>> pair = this.getResolvedCallForFunction(call3, (ResolutionContext<?>)Context2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, initialDataFlowInfoForArguments);
        boolean bl = pair.component1();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = pair.component2();
        if (resolveResult != false) {
            DataFlowInfo resultFlowInfo;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getLambdaArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on((KtExpression)((PsiElement)callExpression), callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "functionDescriptor.constructedClass");
                ClassDescriptor constructedClass = classDescriptor2;
                if (DescriptorUtils.isAnnotationClass(constructedClass)) {
                    BindingTrace bindingTrace = context.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                    if (!CallExpressionResolver.Companion.canInstantiateAnnotationClass(callExpression, bindingTrace)) {
                        context.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                    }
                }
                if (DescriptorUtils.isEnumClass(constructedClass)) {
                    context.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
                if (DescriptorUtils.isSealedClass(constructedClass)) {
                    context.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on((KtCallExpression)((PsiElement)callExpression)));
                }
            }
            KotlinType type2 = functionDescriptor.getReturnType();
            List<KtValueArgument> list2 = callExpression.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "callExpression.valueArguments");
            List<KtValueArgument> arguments2 = list2;
            DataFlowInfoForArguments dataFlowInfoForArguments = resolvedCall2.getDataFlowInfoForArguments();
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfoForArguments, "resolvedCall.dataFlowInfoForArguments");
            DataFlowInfo dataFlowInfo = dataFlowInfoForArguments.getResultInfo();
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "resolvedCall.dataFlowInfoForArguments.resultInfo");
            DataFlowInfo jumpFlowInfo = resultFlowInfo = dataFlowInfo;
            boolean jumpOutPossible = false;
            for (KtValueArgument argument : arguments2) {
                KotlinTypeInfo argTypeInfo = (KotlinTypeInfo)context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, argument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            return TypeInfoFactoryKt.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            void notNothing;
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", callExpression);
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)calleeExpression;
            Object Context3 = context.replaceTraceAndCache(temporaryForVariable);
            Intrinsics.checkExpressionValueIsNotNull(Context3, "context.replaceTraceAndCache(temporaryForVariable)");
            Pair<Boolean, KotlinType> jumpFlowInfo = this.getVariableType(ktSimpleNameExpression, receiver2, callOperationNode2, (ExpressionTypingContext)Context3);
            boolean arguments2 = jumpFlowInfo.component1();
            KotlinType type3 = jumpFlowInfo.component2();
            TemporaryBindingTrace temporaryBindingTrace = temporaryForVariable.trace;
            WritableSlice<KtExpression, Qualifier> writableSlice = BindingContext.QUALIFIER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.QUALIFIER");
            Qualifier qualifier = (Qualifier)temporaryBindingTrace.get(writableSlice, calleeExpression);
            if (!(notNothing == false || qualifier != null && qualifier instanceof PackageQualifier)) {
                KtElement ktElement = callExpression;
                TemporaryBindingTrace temporaryBindingTrace2 = temporaryForVariable.trace;
                Intrinsics.checkExpressionValueIsNotNull(temporaryBindingTrace2, "temporaryForVariable.trace");
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(ktElement, temporaryBindingTrace2.getBindingContext());
                ResolvedCall<? extends CallableDescriptor> it = resolvedCall4;
                ResolvedCall<? extends CallableDescriptor> resolvedCall5 = it;
                if (!(resolvedCall5 instanceof ResolvedCallImpl)) {
                    resolvedCall5 = null;
                }
                ResolvedCallImpl resolvedCallImpl = (ResolvedCallImpl)resolvedCall5;
                if (resolvedCallImpl != null) {
                    resolvedCallImpl.addStatus(ResolutionStatus.OTHER_ERROR);
                }
                temporaryForVariable.commit();
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = calleeExpression;
                KotlinType kotlinType2 = type3;
                if (kotlinType2 == null) {
                    kotlinType2 = ErrorUtils.createErrorType("");
                }
                bindingTrace.report(Errors.FUNCTION_EXPECTED.on((KtExpression)psiElement, calleeExpression, kotlinType2));
                this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(BasicCallResolutionContext.create(context, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, new DataFlowInfoForArgumentsImpl(initialDataFlowInfoForArguments, call3)), ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
                return TypeInfoFactoryKt.noTypeInfo(context);
            }
        }
        temporaryForFunction.commit();
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    private final List<CallExpressionElement> elementChain(@NotNull KtQualifiedExpression $receiver, ExpressionTypingContext context) {
        return this.qualifiedExpressionResolver.resolveQualifierInExpressionAndUnroll($receiver, context, (Function1<? super KtSimpleNameExpression, Boolean>)new Function1<KtSimpleNameExpression, Boolean>(this, context){
            final /* synthetic */ CallExpressionResolver this$0;
            final /* synthetic */ ExpressionTypingContext $context;

            public final boolean invoke(@NotNull KtSimpleNameExpression nameExpression) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(nameExpression, "nameExpression");
                OverloadResolutionResults resolutionResult = CallExpressionResolver.access$resolveSimpleName(this.this$0, this.$context, nameExpression);
                if (resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject) {
                    bl = false;
                } else {
                    switch (CallExpressionResolver$WhenMappings.$EnumSwitchMapping$0[resolutionResult.getResultCode().ordinal()]) {
                        case 1: 
                        case 2: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = !this.$context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) || resolutionResult.isSuccess();
                        }
                    }
                }
                return bl;
            }
            {
                this.this$0 = callExpressionResolver;
                this.$context = expressionTypingContext;
                super(1);
            }
        });
    }

    private final OverloadResolutionResults<VariableDescriptor> resolveSimpleName(ExpressionTypingContext context, KtSimpleNameExpression expression2) {
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", expression2);
        Call call2 = CallMaker.makePropertyCall(null, null, expression2);
        Intrinsics.checkExpressionValueIsNotNull(call2, "CallMaker.makePropertyCall(null, null, expression)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "BasicCallResolutionConte\u2026VALUE_ARGUMENTS\n        )");
        BasicCallResolutionContext contextForVariable = basicCallResolutionContext;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.callResolver.resolveSimpleProperty(contextForVariable);
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults, "callResolver.resolveSimp\u2026perty(contextForVariable)");
        return overloadResolutionResults;
    }

    private final KotlinTypeInfo getUnsafeSelectorTypeInfo(Receiver receiver2, ASTNode callOperationNode2, KtExpression selectorExpression, ExpressionTypingContext context, DataFlowInfo initialDataFlowInfoForArguments) {
        KotlinTypeInfo kotlinTypeInfo;
        KtExpression ktExpression = selectorExpression;
        if (ktExpression instanceof KtCallExpression) {
            kotlinTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((KtCallExpression)selectorExpression, receiver2, callOperationNode2, context, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            kotlinTypeInfo = this.getSimpleNameExpressionTypeInfo((KtSimpleNameExpression)selectorExpression, receiver2, callOperationNode2, context, initialDataFlowInfoForArguments);
        } else if (ktExpression instanceof KtExpression) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
            }
            expressionTypingServices.getTypeInfo(selectorExpression, context);
            context.trace.report(Errors.ILLEGAL_SELECTOR.on((KtExpression)((PsiElement)selectorExpression)));
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        } else {
            kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        return kotlinTypeInfo;
    }

    private final KotlinTypeInfo getSafeOrUnsafeSelectorTypeInfo(Receiver receiver2, CallExpressionElement element, ExpressionTypingContext context) {
        KotlinType selectorType;
        DataFlowValue dataFlowValue2;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        DataFlowInfo initialDataFlowInfoForArguments = dataFlowInfo;
        Receiver receiver3 = receiver2;
        if (!(receiver3 instanceof ReceiverValue)) {
            receiver3 = null;
        }
        ReceiverValue receiverValue = (ReceiverValue)receiver3;
        if (receiverValue != null) {
            ReceiverValue receiverValue2;
            ReceiverValue it = receiverValue2 = receiverValue;
            dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(it, context);
        } else {
            dataFlowValue2 = null;
        }
        DataFlowValue receiverDataFlowValue = dataFlowValue2;
        boolean receiverCanBeNull = receiverDataFlowValue != null && initialDataFlowInfoForArguments.getStableNullability(receiverDataFlowValue).canBeNull();
        PsiFile psiFile = element.getQualified().getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull(psiFile, "element.qualified.containingFile");
        ASTNode callOperationNode2 = (ASTNode)AstLoadingFilter.forceAllowTreeLoading(psiFile, (ThrowableComputable)new ThrowableComputable<ASTNode, Throwable>(element){
            final /* synthetic */ CallExpressionElement $element;

            public final ASTNode compute() {
                return this.$element.getNode();
            }
            {
                this.$element = callExpressionElement;
            }
        });
        if (receiverDataFlowValue != null && element.getSafe()) {
            if (receiverCanBeNull) {
                initialDataFlowInfoForArguments = initialDataFlowInfoForArguments.disequate(receiverDataFlowValue, DataFlowValue.Companion.nullValue(this.builtIns), this.languageVersionSettings);
            } else if (receiver2 instanceof ReceiverValue) {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                KotlinType kotlinType2 = ((ReceiverValue)receiver2).getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiver.type");
                Companion.reportUnnecessarySafeCall(bindingTrace, kotlinType2, callOperationNode2, receiver2);
            }
        }
        KtExpression selector = element.getSelector();
        KotlinTypeInfo selectorTypeInfo = this.getUnsafeSelectorTypeInfo(receiver2, callOperationNode2, selector, context, initialDataFlowInfoForArguments);
        if (receiver2 instanceof Qualifier) {
            this.resolveDeferredReceiverInQualifiedExpression((Qualifier)receiver2, selector, context);
        }
        if ((selectorType = selectorTypeInfo.getType()) != null) {
            if (element.getSafe() && receiverCanBeNull) {
                selectorTypeInfo = selectorTypeInfo.replaceType(TypeUtils.makeNullable(selectorType));
            }
            if (selector != null) {
                context.trace.recordType(selector, selectorTypeInfo.getType());
            }
        }
        return selectorTypeInfo;
    }

    private final KotlinTypeInfo checkSelectorTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo selectorTypeInfo, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo;
        CallExpressionResolver.Companion.checkNestedClassAccess(qualified, context);
        KtExpression ktExpression = qualified;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        CompileTimeConstant<?> value = this.constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, context.expectedType);
        if (value != null && value.isPure()) {
            KotlinTypeInfo kotlinTypeInfo2 = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value, qualified, context);
            kotlinTypeInfo = kotlinTypeInfo2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo2, "dataFlowAnalyzer.createC\u2026alue, qualified, context)");
        } else {
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                this.dataFlowAnalyzer.checkType(selectorTypeInfo.getType(), (KtExpression)qualified, (ResolutionContext)context);
            }
            kotlinTypeInfo = selectorTypeInfo;
        }
        return kotlinTypeInfo;
    }

    private final void recordResultTypeInfo(KtQualifiedExpression qualified, KotlinTypeInfo resultTypeInfo, ExpressionTypingContext context) {
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        BindingTrace trace = bindingTrace;
        if (Intrinsics.areEqual((Boolean)trace.get(BindingContext.PROCESSED, qualified), true) ^ true) {
            trace.record(BindingContext.PROCESSED, qualified);
            trace.record(BindingContext.EXPRESSION_TYPE_INFO, qualified, resultTypeInfo);
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingContextUtilsKt.recordScope(trace, lexicalScope, qualified);
            Object Context2 = context.replaceDataFlowInfo(resultTypeInfo.getDataFlowInfo());
            Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceDataFlowI\u2026ultTypeInfo.dataFlowInfo)");
            BindingContextUtilsKt.recordDataFlowInfo(Context2, qualified);
        }
    }

    @NotNull
    public final KotlinTypeInfo getQualifiedExpressionTypeInfo(@NotNull KtQualifiedExpression expression2, @NotNull ExpressionTypingContext context) {
        KotlinTypeInfo receiverTypeInfo;
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object Context2 = ((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceExpectedT\u2026xtDependency(INDEPENDENT)");
        ExpressionTypingContext currentContext = (ExpressionTypingContext)Context2;
        BindingTrace bindingTrace = currentContext.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "currentContext.trace");
        BindingTrace trace = bindingTrace;
        List<CallExpressionElement> elementChain2 = this.elementChain(expression2, currentContext);
        KtExpression firstReceiver = CollectionsKt.first(elementChain2).getReceiver();
        Qualifier qualifier = (Qualifier)trace.get(BindingContext.QUALIFIER, firstReceiver);
        if (qualifier == null) {
            ExpressionTypingServices expressionTypingServices = this.expressionTypingServices;
            if (expressionTypingServices == null) {
                Intrinsics.throwUninitializedPropertyAccessException("expressionTypingServices");
            }
            kotlinTypeInfo = expressionTypingServices.getTypeInfo(firstReceiver, currentContext);
        } else {
            DataFlowInfo dataFlowInfo = currentContext.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "currentContext.dataFlowInfo");
            kotlinTypeInfo = new KotlinTypeInfo(null, dataFlowInfo, false, null, 12, null);
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "when (trace.get(BindingC\u2026t.dataFlowInfo)\n        }");
        KotlinTypeInfo resultTypeInfo = receiverTypeInfo = kotlinTypeInfo;
        boolean allUnsafe = true;
        DataFlowInfo branchPointDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        for (CallExpressionElement element : elementChain2) {
            Receiver receiver2;
            Object receiver3;
            KotlinType kotlinType2 = receiverTypeInfo.getType();
            if (kotlinType2 == null) {
                SimpleType simpleType2 = ErrorUtils.createErrorType("Type for " + ((receiver3 = element.getReceiver()) instanceof KtNameReferenceExpression ? ((KtNameReferenceExpression)receiver3).getReferencedName() : receiver3.getText()));
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorTy\u2026      }\n                )");
                kotlinType2 = simpleType2;
            }
            KotlinType receiverType = kotlinType2;
            Qualifier qualifier2 = (Qualifier)trace.get(BindingContext.QUALIFIER, element.getReceiver());
            if (qualifier2 != null) {
                receiver2 = qualifier2;
            } else {
                KtExpression ktExpression = element.getReceiver();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
                receiver2 = ExpressionReceiver.Companion.create(ktExpression, receiverType, bindingContext);
            }
            receiver3 = receiver2;
            KtQualifiedExpression qualifiedExpression = element.getQualified();
            boolean lastStage = qualifiedExpression == expression2;
            Object Context3 = (lastStage ? context : currentContext).replaceDataFlowInfo(receiver3 instanceof ReceiverValue && TypeUtils.isNullableType(((ReceiverValue)receiver3).getType()) && !element.getSafe() ? branchPointDataFlowInfo : receiverTypeInfo.getDataFlowInfo());
            Intrinsics.checkExpressionValueIsNotNull(Context3, "(if (lastStage) context \u2026          }\n            )");
            ExpressionTypingContext contextForSelector = (ExpressionTypingContext)Context3;
            KotlinTypeInfo selectorTypeInfo = this.getSafeOrUnsafeSelectorTypeInfo((Receiver)receiver3, element, contextForSelector);
            boolean bl = allUnsafe = allUnsafe && !element.getSafe();
            if (allUnsafe) {
                branchPointDataFlowInfo = selectorTypeInfo.getDataFlowInfo();
            }
            resultTypeInfo = this.checkSelectorTypeInfo(qualifiedExpression, selectorTypeInfo, contextForSelector).replaceDataFlowInfo(branchPointDataFlowInfo);
            if (!lastStage) {
                this.recordResultTypeInfo(qualifiedExpression, resultTypeInfo, contextForSelector);
            }
            receiverTypeInfo = selectorTypeInfo;
        }
        return resultTypeInfo;
    }

    private final void resolveDeferredReceiverInQualifiedExpression(Qualifier qualifier, KtExpression selectorExpression, ExpressionTypingContext context) {
        DeclarationDescriptor declarationDescriptor;
        KtExpression calleeExpression = KtPsiUtil.deparenthesize(CallUtilKt.getCalleeExpressionIfAny(selectorExpression));
        KtExpression ktExpression = calleeExpression;
        if (!(ktExpression instanceof KtReferenceExpression)) {
            ktExpression = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
        if (ktReferenceExpression != null) {
            KtReferenceExpression ktReferenceExpression2;
            KtReferenceExpression it = ktReferenceExpression2 = ktReferenceExpression;
            declarationDescriptor = (DeclarationDescriptor)context.trace.get(BindingContext.REFERENCE_TARGET, it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor selectorDescriptor = declarationDescriptor;
        QualifiedExpressionResolveUtilKt.resolveQualifierAsReceiverInExpression(qualifier, selectorDescriptor, context);
    }

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull KotlinBuiltIns builtIns, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull(callResolver, "callResolver");
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(dataFlowValueFactory, "dataFlowValueFactory");
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.builtIns = builtIns;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    public static final /* synthetic */ OverloadResolutionResults access$resolveSimpleName(CallExpressionResolver $this, ExpressionTypingContext context, KtSimpleNameExpression expression2) {
        return $this.resolveSimpleName(context, expression2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver$Companion;", "", "()V", "canInstantiateAnnotationClass", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkNestedClassAccess", "", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "isUnderAnnotationClassDeclaration", "parent", "Lcom/intellij/psi/PsiElement;", "reportUnnecessarySafeCall", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "callOperationNode", "Lcom/intellij/lang/ASTNode;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "frontend"})
    public static final class Companion {
        private final boolean canInstantiateAnnotationClass(KtCallExpression expression2, BindingTrace trace) {
            Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtValueArgument.class, KtParameter.class);
            if (parent2 instanceof KtValueArgument) {
                Object $receiver$iv;
                Object t = parent2;
                boolean strict$iv = true;
                if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtAnnotationEntry.class, strict$iv) != null) {
                    return true;
                }
                $receiver$iv = parent2;
                strict$iv = true;
                if ((parent2 = PsiTreeUtil.getParentOfType($receiver$iv, KtParameter.class, strict$iv)) != null) {
                    return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
                }
            } else if (parent2 instanceof KtParameter) {
                return this.isUnderAnnotationClassDeclaration(trace, (PsiElement)parent2);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isUnderAnnotationClassDeclaration(BindingTrace trace, PsiElement parent2) {
            boolean bl;
            void $receiver$iv;
            PsiElement psiElement = parent2;
            boolean strict$iv = true;
            KtClass ktClass = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, strict$iv);
            if (ktClass != null) {
                PsiElement it = psiElement = ktClass;
                bl = DescriptorUtils.isAnnotationClass(trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it));
            } else {
                bl = false;
            }
            return bl;
        }

        public final void reportUnnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, @NotNull ASTNode callOperationNode2, @Nullable Receiver explicitReceiver) {
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(callOperationNode2, "callOperationNode");
            trace.report(explicitReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)explicitReceiver).getExpression() instanceof KtSuperExpression ? (ParametrizedDiagnostic)Errors.UNEXPECTED_SAFE_CALL.on(callOperationNode2.getPsi()) : Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode2.getPsi(), type2));
        }

        private final void checkNestedClassAccess(KtQualifiedExpression expression2, ExpressionTypingContext context) {
            KtExpression ktExpression = expression2.getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression selectorExpression = ktExpression;
            Qualifier expressionQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression2);
            Qualifier receiverQualifier = (Qualifier)context.trace.get(BindingContext.QUALIFIER, expression2.getReceiverExpression());
            if (receiverQualifier == null && expressionQualifier != null) {
                boolean bl = expressionQualifier instanceof ClassifierQualifier;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                ClassifierDescriptorWithTypeParameters descriptor2 = ((ClassifierQualifier)expressionQualifier).getDescriptor();
                context.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on((KtExpression)((PsiElement)selectorExpression), descriptor2));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

