/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.backend.jvm.JvmIrCodegenFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.DefaultCodegenFactory;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.GenerationStateEventCallback;
import org.jetbrains.kotlin.codegen.state.GenerationStateKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.modules.TargetIdKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.script.ReflectionUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0005J+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0000\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ+\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u000e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0012H\u0002J8\u0010+\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020\t2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\u00122\b\u0010.\u001a\u0004\u0018\u00010\u0019H\u0002J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J&\u00101\u001a\u0004\u0018\u00010\t2\b\u0010,\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0002J\"\u00105\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010'H\u0002J\u0016\u00109\u001a\u00020:*\u00020:2\b\u0010.\u001a\u0004\u0018\u00010\u0019H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler;", "", "()V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "environment", "targetDescription", "", "analyzeAndGenerate", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "compileAndExecuteScript", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "scriptArgs", "", "compileBunchOfSources", "", "compileModules", "buildFile", "Ljava/io/File;", "chunk", "Lorg/jetbrains/kotlin/modules/Module;", "compileModules$cli", "compileScript", "Ljava/lang/Class;", "parentClassLoader", "Ljava/lang/ClassLoader;", "configureSourceRoots", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configureSourceRoots$cli", "createOutputFilesFlushingCallbackIfPossible", "Lorg/jetbrains/kotlin/codegen/state/GenerationStateEventCallback;", "findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "generationState", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "generate", "result", "sourceFiles", "module", "getAbsolutePaths", "sourceFilePaths", "repeatAnalysisIfNeeded", "reportExceptionFromScript", "exception", "", "writeOutput", "outputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "mainClass", "withModule", "Lorg/jetbrains/kotlin/codegen/state/GenerationState$Builder;", "DirectoriesScope", "cli"})
public final class KotlinToJVMBytecodeCompiler {
    public static final KotlinToJVMBytecodeCompiler INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void writeOutput(CompilerConfiguration configuration, OutputFileCollection outputFiles, FqName mainClass) {
        boolean reportOutputFiles = configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES);
        File jarPath = configuration.get(JVMConfigurationKeys.OUTPUT_JAR);
        MessageCollector messageCollector2 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        if (jarPath != null) {
            boolean includeRuntime = configuration.get(JVMConfigurationKeys.INCLUDE_RUNTIME, false);
            CompileEnvironmentUtil.writeToJar(jarPath, includeRuntime, mainClass, outputFiles);
            if (reportOutputFiles) {
                String message;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)outputFiles.asList();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    OutputFile it = (OutputFile)element$iv$iv;
                    Iterable list$iv$iv = it.getSourceFiles();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                String string = message = OutputMessageUtil.formatOutputMessage(CollectionsKt.distinct((List)destination$iv$iv), jarPath);
                Intrinsics.checkExpressionValueIsNotNull(string, "message");
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.OUTPUT, string, null, 4, null);
            }
            return;
        }
        File file2 = configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY);
        if (file2 == null) {
            file2 = new File(".");
        }
        File outputDir2 = file2;
        OutputUtilsKt.writeAll(outputFiles, outputDir2, messageCollector2, reportOutputFiles);
    }

    private final GenerationStateEventCallback createOutputFilesFlushingCallbackIfPossible(CompilerConfiguration configuration) {
        if (configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY) == null) {
            return GenerationStateEventCallback.Companion.getDO_NOTHING();
        }
        return GenerationStateKt.GenerationStateEventCallback((Function1<? super GenerationState, Unit>)new Function1<GenerationState, Unit>(configuration){
            final /* synthetic */ CompilerConfiguration $configuration;

            public final void invoke(@NotNull GenerationState state2) {
                Intrinsics.checkParameterIsNotNull(state2, "state");
                List<OutputFile> list2 = state2.getFactory().getCurrentOutput();
                Intrinsics.checkExpressionValueIsNotNull(list2, "state.factory.currentOutput");
                SimpleOutputFileCollection currentOutput = new SimpleOutputFileCollection(list2);
                KotlinToJVMBytecodeCompiler.access$writeOutput(KotlinToJVMBytecodeCompiler.INSTANCE, this.$configuration, currentOutput, null);
                if (!this.$configuration.get(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, false).booleanValue()) {
                    state2.getFactory().releaseGeneratedOutput();
                }
            }
            {
                this.$configuration = compilerConfiguration;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final boolean compileModules$cli(@NotNull KotlinCoreEnvironment environment, @NotNull File buildFile, @NotNull List<? extends Module> chunk) {
        Intrinsics.checkParameterIsNotNull(environment, "environment");
        Intrinsics.checkParameterIsNotNull(buildFile, "buildFile");
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment.getProject());
        projectConfiguration = environment.getConfiguration();
        for (Module module : chunk) {
            moduleVisibilityManager.addModule(module);
        }
        friendPaths = environment.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        var8_8 = friendPaths.iterator();
        while (var8_8.hasNext()) {
            v0 = path = (String)var8_8.next();
            Intrinsics.checkExpressionValueIsNotNull(v0, "path");
            moduleVisibilityManager.addFriendPath(v0);
        }
        targetDescription = "in targets [" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.targetDescription.1.INSTANCE, 31, null) + "]";
        result = this.repeatAnalysisIfNeeded(this.analyze(environment, targetDescription), environment, targetDescription);
        if (result == null || !result.getShouldGenerateCode()) {
            return false;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        result.throwIfError();
        outputs = org.jetbrains.kotlin.utils.CollectionsKt.newLinkedHashMapWithExpectedSize(chunk.size());
        localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        for (Object module : chunk) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            var16_23 = this.getAbsolutePaths(buildFile, module.getSourceFiles());
            var17_24 = $receiver$iv;
            destination$iv$iv = new ArrayList<E>();
            $receiver$iv$iv$iv = $receiver$iv$iv;
            var20_27 = $receiver$iv$iv$iv.iterator();
            while (var20_27.hasNext()) {
                element$iv$iv$iv = var20_27.next();
                element$iv$iv = element$iv$iv$iv;
                p1 = (String)element$iv$iv;
                if (localFileSystem.findFileByPath(p1) == null) continue;
                it$iv$iv = var25_32;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            first$iv /* !! */  = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $receiver$iv) {
                p1 = (VirtualFile)element$iv;
                if (p1.isDirectory()) {
                    first$iv /* !! */ .add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            var15_22 = new Pair<ArrayList<E>, ArrayList<E>>(first$iv /* !! */ , second$iv);
            var13_16 = var15_22.component1();
            moduleSourceFiles = var15_22.component2();
            $receiver$iv = environment.getSourceFiles();
            first$iv /* !! */  = $receiver$iv;
            destination$iv$iv = new ArrayList<E>();
            $receiver$iv$iv$iv = $receiver$iv$iv.iterator();
            while ($receiver$iv$iv$iv.hasNext()) {
                block27: {
                    element$iv$iv = $receiver$iv$iv$iv.next();
                    file = (KtFile)element$iv$iv;
                    virtualFile = file.getVirtualFile();
                    if (moduleSourceFiles.contains(virtualFile)) ** GOTO lbl-1000
                    $receiver$iv = (Iterable)moduleSourceDirs;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            dir = (VirtualFile)element$iv;
                            if (!VfsUtilCore.isAncestor(dir, virtualFile, true)) continue;
                            v1 = true;
                            break block27;
                        }
                        v1 = false;
                    }
                }
                if (v1) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ktFiles = (List)destination$iv$iv;
            if (!UtilsKt.checkKotlinPackageUsage(environment, ktFiles)) {
                return false;
            }
            $receiver = $receiver$iv$iv = projectConfiguration.copy();
            $receiver.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(module.getOutputDirectory()));
            moduleConfiguration = $receiver$iv$iv;
            $receiver$iv$iv = outputs;
            v3 = moduleConfiguration;
            Intrinsics.checkExpressionValueIsNotNull(v3, "moduleConfiguration");
            $receiver = this.generate(environment, v3, result, ktFiles, (Module)module);
            $receiver$iv$iv.put(module, $receiver);
        }
        try {
            moduleSourceDirs = outputs;
            var12_11 = moduleSourceDirs.entrySet().iterator();
            while (var12_11.hasNext()) {
                moduleSourceFiles = module = (Map.Entry)var12_11.next();
                state = (GenerationState)moduleSourceFiles.getValue();
                ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
                this.writeOutput(state.getConfiguration(), state.getFactory(), null);
            }
            if (projectConfiguration.getBoolean(JVMConfigurationKeys.COMPILE_JAVA)) {
                singleModule = CollectionsKt.singleOrNull(chunk);
                if (singleModule != null) {
                    var12_11 = JavacWrapper.Companion.getInstance(environment.getProject());
                    state = null;
                    try {
                        it = (JavacWrapper)var12_11;
                        it = it.compile(new File(singleModule.getOutputDirectory()));
                    }
                    catch (Throwable it) {
                        state = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var12_11, (Throwable)state);
                    }
                    var12_12 = it;
                    return var12_12;
                }
                MessageCollector.DefaultImpls.report$default(projectConfiguration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.WARNING, "A chunk contains multiple modules (" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.4.INSTANCE, 31, null) + "). " + "-Xuse-javac option couldn't be used to compile java files", null, 4, null);
                JavacWrapper.Companion.getInstance(environment.getProject()).close();
            }
            var11_14 = true;
            return var11_14;
        }
        finally {
            v4 = outputs.values();
            Intrinsics.checkExpressionValueIsNotNull(v4, "outputs.values");
            $receiver$iv = v4;
            for (T element$iv : $receiver$iv) {
                p1 = (GenerationState)element$iv;
                p1.destroy();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void configureSourceRoots$cli(@NotNull CompilerConfiguration configuration, @NotNull List<? extends Module> chunk, @NotNull File buildFile) {
        boolean bl;
        block19: {
            boolean bl2;
            Iterable iterable;
            block21: {
                Intrinsics.checkParameterIsNotNull(configuration, "configuration");
                Intrinsics.checkParameterIsNotNull(chunk, "chunk");
                Intrinsics.checkParameterIsNotNull(buildFile, "buildFile");
                for (Module module2 : chunk) {
                    Set set = CollectionsKt.toSet((Iterable)this.getAbsolutePaths(buildFile, module2.getCommonSourceFiles()));
                    for (String string : this.getAbsolutePaths(buildFile, module2.getSourceFiles())) {
                        ContentRootsKt.addKotlinSourceRoot(configuration, string, set.contains(string));
                    }
                }
                for (Module module3 : chunk) {
                    for (JavaRootPath javaRootPath : module3.getJavaSourceRoots()) {
                        String path2 = javaRootPath.component1();
                        String packagePrefix = javaRootPath.component2();
                        JvmContentRootsKt.addJavaSourceRoot(configuration, new File(path2), packagePrefix);
                    }
                }
                iterable = chunk;
                if (!(iterable instanceof Collection) || !((Collection)iterable).isEmpty()) break block21;
                bl = false;
                break block19;
            }
            Iterator iterator2 = iterable.iterator();
            block4: do {
                boolean bl3;
                Iterable $receiver$iv;
                if (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    Module module4 = (Module)t;
                    $receiver$iv = module4.getJavaSourceRoots();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl2 = false;
                        continue;
                    }
                } else {
                    bl = false;
                    break block19;
                }
                Iterator iterator3 = $receiver$iv.iterator();
                do {
                    block23: {
                        block24: {
                            boolean bl4;
                            block20: {
                                int n;
                                File[] fileArray;
                                block25: {
                                    block22: {
                                        File[] $receiver$iv2;
                                        if (!iterator3.hasNext()) break block22;
                                        Object element$iv = iterator3.next();
                                        JavaRootPath $path_packagePrefix = (JavaRootPath)element$iv;
                                        String path3 = $path_packagePrefix.component1();
                                        String packagePrefix = $path_packagePrefix.component2();
                                        File file2 = new File(path3);
                                        if (packagePrefix != null) break block23;
                                        if (Intrinsics.areEqual(file2.getName(), "module-info.java")) break block24;
                                        if (!file2.isDirectory()) break block23;
                                        Intrinsics.checkExpressionValueIsNotNull(file2.listFiles(), "file.listFiles()");
                                        fileArray = $receiver$iv2;
                                        n = fileArray.length;
                                        break block25;
                                    }
                                    bl2 = false;
                                    continue block4;
                                }
                                for (int i = 0; i < n; ++i) {
                                    File element$iv;
                                    File it;
                                    File file3 = it = (element$iv = fileArray[i]);
                                    Intrinsics.checkExpressionValueIsNotNull(file3, "it");
                                    if (!Intrinsics.areEqual(file3.getName(), "module-info.java")) continue;
                                    bl4 = true;
                                    break block20;
                                }
                                bl4 = false;
                            }
                            if (!bl4) break block23;
                        }
                        bl3 = true;
                        continue;
                    }
                    bl3 = false;
                } while (!bl3);
                bl2 = true;
            } while (!bl2);
            bl = true;
        }
        boolean bl5 = bl;
        Iterator<? extends Module> iterator4 = chunk.iterator();
        block7: while (true) {
            if (!iterator4.hasNext()) {
                for (Module module5 : chunk) {
                    String string = module5.getModularJdkRoot();
                    if (string == null) continue;
                    configuration.put(JVMConfigurationKeys.JDK_HOME, new File(string));
                    break;
                }
                configuration.addAll(JVMConfigurationKeys.MODULES, (Collection)chunk);
                return;
            }
            Module module6 = iterator4.next();
            Iterator<String> iterator5 = module6.getClasspathRoots().iterator();
            while (true) {
                if (!iterator5.hasNext()) continue block7;
                String string = iterator5.next();
                configuration.add(CLIConfigurationKeys.CONTENT_ROOTS, bl5 ? (JvmContentRoot)new JvmModulePathRoot(new File(string)) : (JvmContentRoot)new JvmClasspathRoot(new File(string)));
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAbsolutePaths(File buildFile, List<String> sourceFilePaths) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)sourceFilePaths;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void path2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file2 = new File((String)path2);
            File p1 = file2;
            File file3 = p1.isAbsolute() ? file2 : null;
            if (file3 == null) {
                file3 = FilesKt.resolveSibling(buildFile, (String)path2);
            }
            String string2 = file3.getAbsolutePath();
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FqName findMainClass(GenerationState generationState, List<? extends KtFile> files2) {
        Object v0;
        block2: {
            void $receiver$iv;
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext(), generationState.getLanguageVersionSettings());
            Sequence sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)files2), (Function1)new Function1<KtFile, FqName>(mainFunctionDetector){
                final /* synthetic */ MainFunctionDetector $mainFunctionDetector;

                @Nullable
                public final FqName invoke(@NotNull KtFile file2) {
                    Intrinsics.checkParameterIsNotNull(file2, "file");
                    return this.$mainFunctionDetector.hasMain(file2.getDeclarations()) ? JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFacadeClassFqName() : null;
                }
                {
                    this.$mainFunctionDetector = mainFunctionDetector;
                    super(1);
                }
            });
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                if (!(it != null)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileBunchOfSources(@NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkParameterIsNotNull(environment, "environment");
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment.getProject());
        List friendPaths = environment.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        Iterator iterator2 = friendPaths.iterator();
        while (iterator2.hasNext()) {
            String path2;
            String string = path2 = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            moduleVisibilityManager.addFriendPath(string);
        }
        if (!UtilsKt.checkKotlinPackageUsage(environment, (Collection<? extends KtFile>)environment.getSourceFiles())) {
            return false;
        }
        GenerationState generationState = this.analyzeAndGenerate(environment);
        if (generationState == null) {
            return false;
        }
        GenerationState generationState2 = generationState;
        FqName mainClass = this.findMainClass(generationState2, environment.getSourceFiles());
        try {
            this.writeOutput(environment.getConfiguration(), generationState2.getFactory(), mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExitCode compileAndExecuteScript(@NotNull KotlinCoreEnvironment environment, @NotNull List<String> scriptArgs) {
        Intrinsics.checkParameterIsNotNull(environment, "environment");
        Intrinsics.checkParameterIsNotNull(scriptArgs, "scriptArgs");
        Class clazz = KotlinToJVMBytecodeCompiler.compileScript$default(this, environment, null, 2, null);
        if (clazz == null) {
            return ExitCode.COMPILATION_ERROR;
        }
        Class scriptClass = clazz;
        try {
            try {
                if (ReflectionUtilKt.tryConstructClassFromStringArgs(scriptClass, scriptArgs) == null) {
                    throw (Throwable)new RuntimeException("unable to find appropriate constructor for class " + scriptClass.getName() + " accepting arguments " + scriptArgs + '\n');
                }
            }
            finally {
                System.out.flush();
                System.err.flush();
            }
        }
        catch (Throwable e) {
            this.reportExceptionFromScript(e);
            return ExitCode.SCRIPT_EXECUTION_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final AnalysisResult repeatAnalysisIfNeeded(AnalysisResult result2, KotlinCoreEnvironment environment, String targetDescription2) {
        if (result2 instanceof AnalysisResult.RetryWithAdditionalJavaRoots) {
            CompilerConfiguration configuration = environment.getConfiguration();
            boolean oldReadOnlyValue = configuration.isReadOnly();
            configuration.setReadOnly(false);
            JvmContentRootsKt.addJavaSourceRoots$default(configuration, ((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAdditionalJavaRoots(), null, 2, null);
            configuration.setReadOnly(oldReadOnlyValue);
            if (((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAddToEnvironment()) {
                Collection<JavaSourceRoot> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = ((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAdditionalJavaRoots();
                KotlinCoreEnvironment kotlinCoreEnvironment = environment;
                void var7_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    JavaSourceRoot javaSourceRoot = new JavaSourceRoot((File)it, null);
                    collection.add(javaSourceRoot);
                }
                collection = (List)destination$iv$iv;
                kotlinCoreEnvironment.updateClasspath((List<? extends ContentRoot>)collection);
            }
            KotlinJavaPsiFacade.getInstance(environment.getProject()).clearPackageCaches();
            MessageCollector messageCollector2 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector2 != null) {
                messageCollector2.clear();
            }
            return this.analyze(environment, targetDescription2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportExceptionFromScript(Throwable exception) {
        PrintStream stream2 = System.err;
        Throwable cause = exception.getCause();
        if (!(exception instanceof InvocationTargetException) || cause == null) {
            exception.printStackTrace(stream2);
            return;
        }
        stream2.println(cause);
        StackTraceElement[] fullTrace = cause.getStackTrace();
        int n = 0;
        int n2 = fullTrace.length - ((InvocationTargetException)exception).getStackTrace().length;
        while (n < n2) {
            void i;
            stream2.println("\tat " + fullTrace[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Class<?> compileScript(@NotNull KotlinCoreEnvironment environment, @Nullable ClassLoader parentClassLoader) {
        Intrinsics.checkParameterIsNotNull(environment, "environment");
        GenerationState generationState = this.analyzeAndGenerate(environment);
        if (generationState == null) {
            return null;
        }
        GenerationState state2 = generationState;
        try {
            Object element$iv$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            List list2 = environment.getConfiguration().getList(CLIConfigurationKeys.CONTENT_ROOTS);
            Intrinsics.checkExpressionValueIsNotNull(list2, "environment.configuratio\u2026rationKeys.CONTENT_ROOTS)");
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            Iterator $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                File file2;
                element$iv$iv$iv = iterator2.next();
                Object element$iv$iv = element$iv$iv$iv;
                ContentRoot root2 = (ContentRoot)element$iv$iv;
                ContentRoot contentRoot = root2;
                File file3 = contentRoot instanceof JvmModulePathRoot ? ((JvmModulePathRoot)root2).getFile() : (contentRoot instanceof JvmClasspathRoot ? ((JvmClasspathRoot)root2).getFile() : null);
                if (file3 == null) continue;
                File it$iv$iv = file2 = file3;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                element$iv$iv$iv = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                URL uRL = it.toURI().toURL();
                collection.add(uRL);
            }
            List urls = (List)destination$iv$iv;
            ClassFileFactory classFileFactory = state2.getFactory();
            ClassLoader classLoader = parentClassLoader;
            if (classLoader == null) {
                void $receiver$iv2;
                $receiver$iv$iv = urls;
                ClassFileFactory classFileFactory2 = classFileFactory;
                void thisCollection$iv = $receiver$iv2;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                URL[] uRLArray2 = uRLArray;
                classFileFactory = classFileFactory2;
                ClassLoader classLoader2 = null;
                URL[] uRLArray3 = uRLArray2;
                classLoader = new URLClassLoader(uRLArray3, classLoader2);
            }
            URL[] uRLArray = new URL[]{};
            ClassLoader classLoader3 = classLoader;
            ClassFileFactory classFileFactory3 = classFileFactory;
            GeneratedClassLoader classLoader4 = new GeneratedClassLoader(classFileFactory3, classLoader3, uRLArray);
            KtScript ktScript = environment.getSourceFiles().get(0).getScript();
            if (ktScript == null) {
                String string = "Script must be parsed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtScript script = ktScript;
            return classLoader4.loadClass(script.getFqName().asString());
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static /* synthetic */ Class compileScript$default(KotlinToJVMBytecodeCompiler kotlinToJVMBytecodeCompiler, KotlinCoreEnvironment kotlinCoreEnvironment, ClassLoader classLoader, int n, Object object) {
        if ((n & 2) != 0) {
            classLoader = null;
        }
        return kotlinToJVMBytecodeCompiler.compileScript(kotlinCoreEnvironment, classLoader);
    }

    @Nullable
    public final GenerationState analyzeAndGenerate(@NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkParameterIsNotNull(environment, "environment");
        AnalysisResult analysisResult2 = this.repeatAnalysisIfNeeded(this.analyze(environment, null), environment, null);
        if (analysisResult2 == null) {
            return null;
        }
        AnalysisResult result2 = analysisResult2;
        if (!result2.getShouldGenerateCode()) {
            return null;
        }
        result2.throwIfError();
        return this.generate(environment, environment.getConfiguration(), result2, environment.getSourceFiles(), null);
    }

    private final AnalysisResult analyze(KotlinCoreEnvironment environment, String targetDescription2) {
        CommonCompilerPerformanceManager performanceManager;
        List<KtFile> sourceFiles2 = environment.getSourceFiles();
        MessageCollector collector2 = this.getMessageCollector(environment);
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = performanceManager = environment.getConfiguration().get(CLIConfigurationKeys.PERF_MANAGER);
        if (commonCompilerPerformanceManager != null) {
            commonCompilerPerformanceManager.notifyAnalysisStarted();
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2, CommonConfigurationKeysKt.getLanguageVersionSettings(environment.getConfiguration()));
        analyzerWithCompilerReport.analyzeAndReport((Collection<? extends KtFile>)sourceFiles2, (Function0<? extends AnalysisResult>)new Function0<AnalysisResult>(environment, sourceFiles2){
            final /* synthetic */ KotlinCoreEnvironment $environment;
            final /* synthetic */ List $sourceFiles;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AnalysisResult invoke() {
                GlobalSearchScope globalSearchScope;
                Set<T> set;
                HashSet hashSet;
                Set<T> $receiver$iv;
                Project project = this.$environment.getProject();
                List<Module> list2 = this.$environment.getConfiguration().get(JVMConfigurationKeys.MODULES);
                if (list2 != null) {
                    void destination$iv;
                    Iterable iterable = list2;
                    Collection collection = new HashSet<E>();
                    Set<T> $receiver$iv$iv = $receiver$iv;
                    for (T element$iv$iv : $receiver$iv$iv) {
                        VirtualFile virtualFile2;
                        T element$iv = element$iv$iv;
                        Module module2 = (Module)element$iv;
                        if (this.$environment.findLocalFile$cli(module2.getOutputDirectory()) == null) continue;
                        VirtualFile it$iv = virtualFile2;
                        destination$iv.add(it$iv);
                    }
                    hashSet = (HashSet)destination$iv;
                } else {
                    hashSet = null;
                }
                if ((set = ($receiver$iv = (Set<T>)hashSet)) == null) {
                    set = SetsKt.emptySet();
                }
                Set<T> moduleOutputs = set;
                GlobalSearchScope sourcesOnly = TopDownAnalyzerFacadeForJVM.INSTANCE.newModuleSearchScope(project, this.$sourceFiles);
                if (moduleOutputs.isEmpty()) {
                    globalSearchScope = sourcesOnly;
                } else {
                    GlobalSearchScope globalSearchScope2 = sourcesOnly.uniteWith(new DirectoriesScope(project, moduleOutputs));
                    globalSearchScope = globalSearchScope2;
                    Intrinsics.checkExpressionValueIsNotNull(globalSearchScope2, "sourcesOnly.uniteWith(Di\u2026(project, moduleOutputs))");
                }
                GlobalSearchScope scope = globalSearchScope;
                return TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration$default(project, this.$sourceFiles, new NoScopeRecordCliBindingTrace(), this.$environment.getConfiguration(), new Function1<GlobalSearchScope, JvmPackagePartProvider>(this.$environment){

                    @NotNull
                    public final JvmPackagePartProvider invoke(@NotNull GlobalSearchScope p1) {
                        Intrinsics.checkParameterIsNotNull(p1, "p1");
                        return ((KotlinCoreEnvironment)this.receiver).createPackagePartProvider(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class);
                    }

                    public final String getName() {
                        return "createPackagePartProvider";
                    }

                    public final String getSignature() {
                        return "createPackagePartProvider(Lcom/intellij/psi/search/GlobalSearchScope;)Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;";
                    }
                }, null, scope, 32, null);
            }
            {
                this.$environment = kotlinCoreEnvironment;
                this.$sourceFiles = list2;
                super(0);
            }
        });
        CommonCompilerPerformanceManager commonCompilerPerformanceManager2 = performanceManager;
        if (commonCompilerPerformanceManager2 != null) {
            commonCompilerPerformanceManager2.notifyAnalysisFinished(sourceFiles2.size(), environment.countLinesOfCode$cli(sourceFiles2), targetDescription2);
        }
        AnalysisResult analysisResult2 = analyzerWithCompilerReport.getAnalysisResult();
        return !analyzerWithCompilerReport.hasErrors() || analysisResult2 instanceof AnalysisResult.RetryWithAdditionalJavaRoots ? analysisResult2 : null;
    }

    private final GenerationState.Builder withModule(@NotNull GenerationState.Builder $receiver, Module module2) {
        Serializable serializable;
        TargetId targetId;
        Serializable serializable2;
        Module it;
        GenerationState.Builder builder;
        Module module3;
        GenerationState.Builder builder2;
        GenerationState.Builder $receiver2;
        GenerationState.Builder builder3 = $receiver2 = (builder2 = $receiver);
        Module module4 = module2;
        if (module4 != null) {
            module3 = module4;
            builder = builder3;
            it = module3;
            serializable2 = TargetIdKt.TargetId(it);
            builder3 = builder;
            targetId = serializable2;
        } else {
            targetId = null;
        }
        builder3.targetId(targetId);
        Module module5 = module2;
        $receiver2.moduleName(module5 != null ? module5.getModuleName() : null);
        GenerationState.Builder builder4 = $receiver2;
        Module module6 = module2;
        if (module6 != null) {
            module3 = module6;
            builder = builder4;
            it = module3;
            serializable2 = new File(it.getOutputDirectory());
            builder4 = builder;
            serializable = serializable2;
        } else {
            serializable = null;
        }
        builder4.outDirectory((File)serializable);
        return builder2;
    }

    private final GenerationState generate(KotlinCoreEnvironment environment, CompilerConfiguration configuration, AnalysisResult result2, List<? extends KtFile> sourceFiles2, Module module2) {
        CommonCompilerPerformanceManager performanceManager;
        Project project = environment.getProject();
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkExpressionValueIsNotNull(classBuilderFactory, "ClassBuilderFactories.BINARIES");
        GenerationState generationState = this.withModule(new GenerationState.Builder(project, classBuilderFactory, result2.getModuleDescriptor(), result2.getBindingContext(), sourceFiles2, configuration).codegenFactory(configuration.getBoolean(JVMConfigurationKeys.IR) ? (CodegenFactory)JvmIrCodegenFactory.INSTANCE : (CodegenFactory)DefaultCodegenFactory.INSTANCE), module2).onIndependentPartCompilationEnd(this.createOutputFilesFlushingCallbackIfPossible(configuration)).build();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = performanceManager = environment.getConfiguration().get(CLIConfigurationKeys.PERF_MANAGER);
        if (commonCompilerPerformanceManager != null) {
            commonCompilerPerformanceManager.notifyGenerationStarted();
        }
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        CommonCompilerPerformanceManager commonCompilerPerformanceManager2 = performanceManager;
        if (commonCompilerPerformanceManager2 != null) {
            commonCompilerPerformanceManager2.notifyGenerationFinished(sourceFiles2.size(), environment.countLinesOfCode$cli(sourceFiles2), module2 != null ? "target " + module2.getModuleName() + "-" + module2.getModuleType() + " " : "");
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Diagnostics diagnostics2 = generationState.getCollectedExtraJvmDiagnostics();
        Diagnostics diagnostics3 = result2.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull(diagnostics3, "result.bindingContext.diagnostics");
        AnalyzerWithCompilerReport.Companion.reportDiagnostics((Diagnostics)new FilteredJvmDiagnostics(diagnostics2, diagnostics3), this.getMessageCollector(environment));
        BindingContext bindingContext = generationState.getExtraJvmDiagnosticsTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "generationState.extraJvm\u2026sticsTrace.bindingContext");
        AnalyzerWithCompilerReport.Companion.reportBytecodeVersionErrors(bindingContext, this.getMessageCollector(environment));
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        return generationState;
    }

    private final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $receiver) {
        return $receiver.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
    }

    private KotlinToJVMBytecodeCompiler() {
    }

    static {
        KotlinToJVMBytecodeCompiler kotlinToJVMBytecodeCompiler;
        INSTANCE = kotlinToJVMBytecodeCompiler = new KotlinToJVMBytecodeCompiler();
    }

    public static final /* synthetic */ void access$writeOutput(KotlinToJVMBytecodeCompiler $this, CompilerConfiguration configuration, OutputFileCollection outputFiles, FqName mainClass) {
        $this.writeOutput(configuration, outputFiles, mainClass);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$DirectoriesScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "directories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "fileSystems", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "Lkotlin/collections/HashSet;", "contains", "", "file", "toString", "", "cli"})
    public static final class DirectoriesScope
    extends DelegatingGlobalSearchScope {
        private final HashSet<VirtualFileSystem> fileSystems;
        private final Set<VirtualFile> directories;

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            if (!this.fileSystems.contains(file2.getFileSystem())) {
                return false;
            }
            VirtualFile parent2 = file2;
            while (!this.directories.contains(parent2)) {
                if (parent2.getParent() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public String toString() {
            return "All files under: " + this.directories;
        }

        /*
         * WARNING - void declaration
         */
        public DirectoriesScope(@NotNull Project project, @NotNull Set<? extends VirtualFile> directories) {
            void destination$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(project, "project");
            Intrinsics.checkParameterIsNotNull(directories, "directories");
            super(GlobalSearchScope.allScope(project));
            this.directories = directories;
            Iterable iterable = this.directories;
            DirectoriesScope directoriesScope = this;
            HashSet<VirtualFileSystem> hashSet = new HashSet<VirtualFileSystem>();
            Collection collection = hashSet;
            for (Object item$iv : $receiver$iv) {
                void p1;
                VirtualFile virtualFile2 = (VirtualFile)item$iv;
                hashSet = destination$iv;
                VirtualFileSystem virtualFileSystem = p1.getFileSystem();
                hashSet.add(virtualFileSystem);
            }
            hashSet = destination$iv;
            directoriesScope.fileSystems = hashSet;
        }
    }
}

