/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.WalkingState;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import gnu.trove.TLongHashSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class IntervalTreeImpl<T>
extends RedBlackTree<T> {
    static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.RangeMarkerTree");
    static final boolean DEBUG = LOG.isDebugEnabled() || ApplicationManager.getApplication() != null && (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal());
    private int keySize;
    final ReadWriteLock l = new ReentrantReadWriteLock();
    private final ReferenceQueue<T> myReferenceQueue = new ReferenceQueue();
    private int deadReferenceCount;
    private boolean firingBeforeRemove;
    private static final IntervalTreeGuide INTERVAL_TREE_GUIDE_INSTANCE = new IntervalTreeGuide();

    IntervalTreeImpl() {
    }

    protected abstract int compareEqualStartIntervals(@NotNull IntervalNode<T> var1, @NotNull IntervalNode<T> var2);

    private void assertUnderWriteLock() {
        if (DEBUG && !ApplicationInfoImpl.isInStressTest()) assert (IntervalTreeImpl.isAcquired(this.l.writeLock())) : this.l.writeLock();
    }

    private static boolean isAcquired(@NotNull Lock l) {
        if (l == null) {
            IntervalTreeImpl.$$$reportNull$$$0(0);
        }
        String s = l.toString();
        return s.contains("Locked by thread");
    }

    private void pushDeltaFromRoot(@Nullable IntervalNode<T> node) {
        if (node != null) {
            long packedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
            if (IntervalNode.allDeltasUpAreNull(packedOffsets) && node.isValid() && IntervalNode.modCount(packedOffsets) == this.getModCount()) {
                return;
            }
            this.pushDeltaFromRoot((IntervalNode<T>)node.getParent());
            this.pushDelta(node);
        }
    }

    protected abstract IntervalNode<T> lookupNode(@NotNull T var1);

    protected abstract void setNode(@NotNull T var1, @Nullable IntervalNode<T> var2);

    private int compareNodes(@NotNull IntervalNode<T> i1, int delta1, @NotNull IntervalNode<T> i2, int delta2, @NotNull List<? super IntervalNode<T>> invalid) {
        int start2;
        int start1;
        if (i1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(1);
        }
        if (i2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(2);
        }
        if (invalid == null) {
            IntervalTreeImpl.$$$reportNull$$$0(3);
        }
        if (!i2.hasAliveKey(false)) {
            invalid.add(i2);
        }
        if ((start1 = i1.intervalStart() + delta1) != (start2 = i2.intervalStart() + delta2)) {
            return start1 - start2;
        }
        return this.compareEqualStartIntervals(i1, i2);
    }

    protected IntervalNode<T> getRoot() {
        return (IntervalNode)this.root;
    }

    private boolean overlaps(@Nullable IntervalNode<T> root2, @NotNull TextRangeInterval rangeInterval, int deltaUpToRootExclusive) {
        if (rangeInterval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(15);
        }
        if (root2 == null) {
            return false;
        }
        int delta = root2.delta + deltaUpToRootExclusive;
        int start = root2.intervalStart() + delta;
        int end = root2.intervalEnd() + delta;
        return rangeInterval.intersects(start, end);
    }

    @NotNull
    IntervalNode<T> findOrInsert(@NotNull IntervalNode<T> node) {
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(16);
        }
        this.assertUnderWriteLock();
        node.setRed();
        node.setParent(null);
        node.setValid(true);
        node.maxEnd = 0;
        node.clearDelta();
        node.setLeft(null);
        node.setRight(null);
        SmartList<IntervalNode<T>> gced = new SmartList<IntervalNode<T>>();
        if (this.root == null) {
            this.root = node;
        } else {
            RedBlackTree.Node current = this.getRoot();
            while (true) {
                this.pushDelta((IntervalNode<T>)current);
                int compResult = this.compareNodes(node, 0, (IntervalNode<T>)current, 0, (List<? super IntervalNode<T>>)gced);
                if (compResult == 0) {
                    IntervalNode<T> intervalNode = current;
                    if (intervalNode == null) {
                        IntervalTreeImpl.$$$reportNull$$$0(17);
                    }
                    return intervalNode;
                }
                if (compResult < 0) {
                    if (current.getLeft() == null) {
                        current.setLeft(node);
                        break;
                    }
                    current = current.getLeft();
                    continue;
                }
                if (current.getRight() == null) {
                    current.setRight(node);
                    break;
                }
                current = current.getRight();
            }
            node.setParent(current);
        }
        ((IntervalNode)node).setCachedValues(0, true, this.getModCount());
        this.correctMaxUp(node);
        this.onInsertNode();
        this.keySize += node.intervals.size();
        this.insertCase1(node);
        ((IntervalNode)node).setAttachedToTree(true);
        this.verifyProperties();
        this.deleteNodes(gced);
        IntervalNode<T> intervalNode = node;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(18);
        }
        return intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodes(@NotNull List<IntervalNode<T>> collectedAway) {
        if (collectedAway == null) {
            IntervalTreeImpl.$$$reportNull$$$0(19);
        }
        if (collectedAway.isEmpty()) {
            return;
        }
        try {
            this.l.writeLock().lock();
            for (IntervalNode<T> node : collectedAway) {
                this.removeNode(node);
            }
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    boolean checkMax(boolean assertInvalid) {
        return VERIFY && this.doCheckMax(assertInvalid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckMax(boolean assertInvalid) {
        try {
            this.l.readLock().lock();
            AtomicBoolean allValid = new AtomicBoolean(true);
            int[] keyCounter = new int[1];
            int[] nodeCounter = new int[1];
            TLongHashSet ids = new TLongHashSet(this.keySize);
            this.checkMax(this.getRoot(), 0, assertInvalid, allValid, keyCounter, nodeCounter, ids, true);
            if (assertInvalid) {
                assert (this.nodeSize() == nodeCounter[0]) : "node size: " + this.nodeSize() + "; actual: " + nodeCounter[0];
                assert (this.keySize == keyCounter[0]) : "key size: " + this.keySize + "; actual: " + keyCounter[0];
                assert (this.keySize >= this.nodeSize()) : this.keySize + "; " + this.nodeSize();
            }
            boolean bl = allValid.get();
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private IntTrinity checkMax(@Nullable IntervalNode<T> root2, int deltaUpToRootExclusive, boolean assertInvalid, @NotNull AtomicBoolean allValid, @NotNull int[] keyCounter, @NotNull int[] nodeCounter, @NotNull TLongHashSet ids, boolean allDeltasUpAreNull) {
        if (allValid == null) {
            IntervalTreeImpl.$$$reportNull$$$0(22);
        }
        if (keyCounter == null) {
            IntervalTreeImpl.$$$reportNull$$$0(23);
        }
        if (nodeCounter == null) {
            IntervalTreeImpl.$$$reportNull$$$0(24);
        }
        if (ids == null) {
            IntervalTreeImpl.$$$reportNull$$$0(25);
        }
        if (root2 == null) {
            return new IntTrinity(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        long packedOffsets = ((IntervalNode)root2).cachedDeltaUpToRoot;
        if (IntervalNode.modCount(packedOffsets) == this.getModCount()) {
            assert (IntervalNode.allDeltasUpAreNull(packedOffsets) == (root2.delta == 0 && allDeltasUpAreNull));
            assert (IntervalNode.deltaUpToRoot(packedOffsets) == root2.delta + deltaUpToRootExclusive);
        }
        T liveInterval = null;
        for (int i = root2.intervals.size() - 1; i >= 0; --i) {
            Object t = root2.intervals.get(i).get();
            if (t == null) continue;
            liveInterval = (T)t;
            this.checkBelongsToTheTree(t, false);
            boolean added = ids.add(((RangeMarkerImpl)t).getId());
            assert (added) : t;
        }
        if (assertInvalid && liveInterval != null) {
            this.checkBelongsToTheTree(liveInterval, true);
        }
        keyCounter[0] = keyCounter[0] + root2.intervals.size();
        nodeCounter[0] = nodeCounter[0] + 1;
        int delta = deltaUpToRootExclusive + (root2.isValid() ? root2.delta : 0);
        IntTrinity l = this.checkMax((IntervalNode<T>)root2.getLeft(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root2.delta == 0 && allDeltasUpAreNull);
        int minLeftStart = l.first;
        int maxLeftStart = l.second;
        int maxLeftEnd = l.third;
        IntTrinity r = this.checkMax((IntervalNode<T>)root2.getRight(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root2.delta == 0 && allDeltasUpAreNull);
        int maxRightEnd = r.third;
        int minRightStart = r.first;
        int maxRightStart = r.second;
        if (!root2.isValid()) {
            allValid.set(false);
            if (assertInvalid) assert (false) : root2;
            return new IntTrinity(Math.min(minLeftStart, minRightStart), Math.max(maxLeftStart, maxRightStart), Math.max(maxRightEnd, maxLeftEnd));
        }
        RedBlackTree.Node parent2 = root2.getParent();
        if (parent2 != null && assertInvalid && root2.hasAliveKey(false)) {
            int c = this.compareNodes(root2, delta, (IntervalNode<T>)parent2, delta - root2.delta, new SmartList());
            assert (c != 0);
            assert (c < 0 && ((IntervalNode)parent2).getLeft() == root2 || c > 0 && ((IntervalNode)parent2).getRight() == root2);
        }
        assert (delta + root2.maxEnd == Math.max(maxLeftEnd, Math.max(maxRightEnd, delta + root2.intervalEnd())));
        int myStartOffset = delta + root2.intervalStart();
        assert (maxLeftStart <= myStartOffset);
        assert (minRightStart >= myStartOffset);
        assert (myStartOffset >= 0);
        assert (minLeftStart == Integer.MAX_VALUE || minLeftStart <= myStartOffset);
        assert (maxRightStart == Integer.MIN_VALUE || maxRightStart >= myStartOffset);
        int minStart = Math.min(minLeftStart, myStartOffset);
        int maxStart = Math.max(myStartOffset, Math.max(maxLeftStart, maxRightStart));
        assert (minStart <= maxStart);
        return new IntTrinity(minStart, maxStart, root2.maxEnd + delta);
    }

    @Override
    @NotNull
    protected RedBlackTree.Node<T> maximumNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(26);
        }
        RedBlackTree.Node root2 = (IntervalNode)n;
        this.pushDelta((IntervalNode<T>)root2.getParent());
        this.pushDelta((IntervalNode<T>)root2);
        while (root2.getRight() != null) {
            root2 = root2.getRight();
            this.pushDelta((IntervalNode<T>)root2);
        }
        IntervalNode intervalNode = root2;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(27);
        }
        return intervalNode;
    }

    private void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        IntervalNode<T> root2;
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(28);
        }
        if ((root2 = this.lookupNode(interval)) == null) {
            return;
        }
        assert (root2.getTree() == this) : root2.getTree() + "; this: " + this;
        if (!VERIFY) {
            return;
        }
        if (assertInvalid) {
            assert (!root2.intervals.isEmpty());
            boolean contains = false;
            for (int i = root2.intervals.size() - 1; i >= 0; --i) {
                Object key = root2.intervals.get(i).get();
                if (key == null) continue;
                contains |= key == interval;
                IntervalNode node = this.lookupNode(key);
                assert (node == root2) : node;
                assert (node.getTree() == this) : node;
            }
            assert (contains) : root2.intervals + "; " + interval;
        }
        RedBlackTree.Node e = root2;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInterval(@NotNull T interval) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(29);
        }
        if (!((RangeMarkerEx)interval).isValid()) {
            return false;
        }
        try {
            this.l.writeLock().lock();
            this.incModCount();
            if (!((RangeMarkerEx)interval).isValid()) {
                boolean bl = false;
                return bl;
            }
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
            this.processReferenceQueue();
            IntervalNode<T> node = this.lookupNode(interval);
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            this.beforeRemove(interval, "Explicit Dispose");
            ((IntervalNode)node).removeInterval(interval);
            this.setNode(interval, null);
            this.checkMax(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    void removeNode(@NotNull IntervalNode<T> node) {
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(30);
        }
        this.deleteNode((RedBlackTree.Node<T>)node);
        RedBlackTree.Node parent2 = node.getParent();
        this.correctMaxUp((IntervalNode<T>)parent2);
    }

    @Override
    protected void deleteNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(31);
        }
        this.assertUnderWriteLock();
        IntervalNode node = (IntervalNode)n;
        this.pushDeltaFromRoot(node);
        this.assertAllDeltasAreNull(node);
        super.deleteNode(n);
        this.keySize -= node.intervals.size();
        assert (this.keySize >= 0) : this.keySize;
        node.setAttachedToTree(false);
    }

    @Override
    public int size() {
        return this.keySize;
    }

    boolean pushDelta(@Nullable IntervalNode<T> root2) {
        if (root2 == null || !root2.isValid()) {
            return true;
        }
        RedBlackTree.Node parent2 = root2.getParent();
        this.assertAllDeltasAreNull((IntervalNode<T>)parent2);
        int delta = root2.delta;
        ((IntervalNode)root2).setCachedValues(0, true, 0);
        if (delta != 0) {
            root2.setIntervalStart(root2.intervalStart() + delta);
            root2.setIntervalEnd(root2.intervalEnd() + delta);
            root2.maxEnd += delta;
            root2.delta = 0;
            return this.incDelta((IntervalNode<T>)root2.getLeft(), delta) & this.incDelta((IntervalNode<T>)root2.getRight(), delta);
        }
        ((IntervalNode)root2).setCachedValues(0, true, this.getModCount());
        return true;
    }

    private boolean incDelta(@Nullable IntervalNode<T> root2, int delta) {
        if (root2 == null) {
            return true;
        }
        if (root2.isValid()) {
            int newDelta = root2.changeDelta(delta);
            return newDelta == 0;
        }
        return this.incDelta((IntervalNode<T>)root2.getLeft(), delta) & this.incDelta((IntervalNode<T>)root2.getRight(), delta);
    }

    @Override
    @NotNull
    protected IntervalNode<T> swapWithMaxPred(@NotNull RedBlackTree.Node<T> root2, @NotNull RedBlackTree.Node<T> maxPred) {
        if (root2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(32);
        }
        if (maxPred == null) {
            IntervalTreeImpl.$$$reportNull$$$0(33);
        }
        this.checkMax(false);
        IntervalNode a = (IntervalNode)root2;
        IntervalNode d = (IntervalNode)maxPred;
        boolean acolor = a.isBlack();
        boolean dcolor = d.isBlack();
        assert (!a.isValid() || a.delta == 0) : a.delta;
        for (RedBlackTree.Node n = a.getLeft(); n != null; n = ((IntervalNode)n).getRight()) {
            assert (!((IntervalNode)n).isValid() || ((IntervalNode)n).delta == 0) : ((IntervalNode)n).delta;
        }
        this.swapNodes(a, d);
        a.setValid(false);
        a.setColor(dcolor);
        d.setColor(acolor);
        this.correctMaxUp(a);
        this.checkMax(false);
        assert (a.delta == 0) : a.delta;
        assert (d.delta == 0) : d.delta;
        IntervalNode intervalNode = a;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(34);
        }
        return intervalNode;
    }

    private void swapNodes(@NotNull IntervalNode<T> n1, @NotNull IntervalNode<T> n2) {
        if (n1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(35);
        }
        if (n2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(36);
        }
        RedBlackTree.Node l1 = n1.getLeft();
        RedBlackTree.Node r1 = n1.getRight();
        IntervalNode<T> p1 = n1.getParent();
        IntervalNode<T> l2 = n2.getLeft();
        IntervalNode<T> r2 = n2.getRight();
        RedBlackTree.Node p2 = n2.getParent();
        if (p1 != null) {
            if (p1.getLeft() == n1) {
                p1.setLeft(n2);
            } else {
                p1.setRight(n2);
            }
        } else {
            this.root = n2;
        }
        if (p2 != null) {
            if (((IntervalNode)p2).getLeft() == n2) {
                p2.setLeft(p2 == n1 ? l2 : n1);
            } else {
                p2.setRight(p2 == n1 ? r2 : n1);
            }
        } else {
            this.root = n1;
        }
        n1.setParent(p2 == n1 ? n2 : p2);
        n2.setParent(p1);
        n1.setLeft(l2);
        n2.setLeft(l1 == n2 ? n1 : l1);
        if (l1 != null) {
            l1.setParent(n2 == l1 ? p1 : n2);
        }
        if (r1 != null) {
            r1.setParent(n2);
        }
        n1.setRight(r2);
        n2.setRight(r1);
        if (l2 != null) {
            l2.setParent(n1);
        }
        if (r2 != null) {
            r2.setParent(n1);
        }
    }

    private int maxEndOf(@Nullable IntervalNode<T> node, int deltaUpToRootExclusive) {
        if (node == null) {
            return 0;
        }
        if (node.isValid()) {
            return node.maxEnd + node.delta + deltaUpToRootExclusive;
        }
        return Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRootExclusive), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRootExclusive));
    }

    void correctMax(@NotNull IntervalNode<T> node, int deltaUpToRoot) {
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(37);
        }
        if (!node.isValid()) {
            return;
        }
        int realMax = Math.max(Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRoot), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRoot)), deltaUpToRoot + node.intervalEnd());
        node.maxEnd = realMax - deltaUpToRoot;
    }

    private void correctMaxUp(@Nullable IntervalNode<T> node) {
        int delta;
        int n = delta = node == null ? 0 : node.computeDeltaUpToRoot();
        assert (delta == 0) : delta;
        while (node != null) {
            if (node.isValid()) {
                int d = node.delta;
                this.correctMax((IntervalNode<T>)node, delta);
                delta -= d;
            }
            node = node.getParent();
        }
        assert (delta == 0) : delta;
    }

    @Override
    protected void rotateRight(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(38);
        }
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent2 = node1.getParent();
        int deltaUp = parent2 == null ? 0 : ((IntervalNode)parent2).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        super.rotateRight(node1);
        if (node3 != null) {
            this.correctMax((IntervalNode<T>)node3, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node2, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void rotateLeft(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(39);
        }
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent2 = node1.getParent();
        int deltaUp = parent2 == null ? 0 : ((IntervalNode)parent2).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        this.checkMax(false);
        super.rotateLeft(node1);
        if (node2 != null) {
            this.correctMax((IntervalNode<T>)node2, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node3, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        this.checkMax(false);
    }

    @Override
    protected void replaceNode(@NotNull RedBlackTree.Node<T> node, RedBlackTree.Node<T> child) {
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(40);
        }
        IntervalNode myNode = (IntervalNode)node;
        this.pushDelta(myNode);
        this.pushDelta((IntervalNode)child);
        super.replaceNode(node, child);
        if (child != null && myNode.isValid()) {
            ((IntervalNode)child).changeDelta(myNode.delta);
        }
    }

    private void assertAllDeltasAreNull(@Nullable IntervalNode<T> node) {
        if (node == null) {
            return;
        }
        if (!node.isValid()) {
            return;
        }
        assert (node.delta == 0);
        long packedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
        assert (IntervalNode.modCount(packedOffsets) != this.getModCount() || IntervalNode.allDeltasUpAreNull(packedOffsets));
    }

    private void processReferenceQueue() {
        int dead = 0;
        while (this.myReferenceQueue.poll() != null) {
            ++dead;
        }
        this.deadReferenceCount += dead;
        if (this.deadReferenceCount > Math.max(1, this.size() / 3)) {
            this.purgeDeadNodes();
            this.deadReferenceCount = 0;
        }
    }

    private void purgeDeadNodes() {
        this.assertUnderWriteLock();
        SmartList<IntervalNode<T>> gced = new SmartList<IntervalNode<T>>();
        this.collectGced(this.getRoot(), gced);
        this.deleteNodes(gced);
        this.checkMax(true);
    }

    private void collectGced(@Nullable IntervalNode<T> root2, @NotNull List<? super IntervalNode<T>> gced) {
        if (gced == null) {
            IntervalTreeImpl.$$$reportNull$$$0(43);
        }
        if (root2 == null) {
            return;
        }
        if (!root2.hasAliveKey(true)) {
            gced.add(root2);
        }
        this.collectGced((IntervalNode<T>)root2.getLeft(), (List<? super IntervalNode<T>>)gced);
        this.collectGced((IntervalNode<T>)root2.getRight(), (List<? super IntervalNode<T>>)gced);
    }

    void fireBeforeRemoved(@NotNull T markerEx, @NotNull @NonNls Object reason) {
        if (markerEx == null) {
            IntervalTreeImpl.$$$reportNull$$$0(44);
        }
        if (reason == null) {
            IntervalTreeImpl.$$$reportNull$$$0(45);
        }
    }

    void beforeRemove(@NotNull T markerEx, @NonNls @NotNull Object reason) {
        if (markerEx == null) {
            IntervalTreeImpl.$$$reportNull$$$0(46);
        }
        if (reason == null) {
            IntervalTreeImpl.$$$reportNull$$$0(47);
        }
        if (this.firingBeforeRemove) {
            throw new IllegalStateException();
        }
        this.firingBeforeRemove = true;
        try {
            this.fireBeforeRemoved(markerEx, reason);
        }
        finally {
            this.firingBeforeRemove = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 34: 
            case 48: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 34: 
            case 48: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalid";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInterval";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 34: 
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/IntervalTreeImpl";
                break;
            }
            case 16: 
            case 30: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedAway";
                break;
            }
            case 20: 
            case 28: 
            case 29: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allValid";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCounter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCounter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 26: 
            case 31: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxPred";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gced";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerEx";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree1";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree1Range";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree2Range";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrInsert";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterval";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "maximumNode";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "swapWithMaxPred";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuide";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "mergingOverlappingIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAcquired";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processOverlappingWith";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processOverlappingWithOutside";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processContaining";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "overlappingIterator";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 34: 
            case 48: 
            case 54: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "overlaps";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findOrInsert";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteNodes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addInterval";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkMax";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "maximumNode";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkBelongsToTheTree";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeInterval";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "deleteNode";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "swapWithMaxPred";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "swapNodes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "correctMax";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replaceNode";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findMinOverlappingWith";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "changeData";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "collectGced";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemove";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "mergingOverlappingIterator";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findRangeMarkerAfter";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findRangeMarkerBefore";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$process$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 34: 
            case 48: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IntervalTreeGuide<T>
    implements WalkingState.TreeGuide<IntervalNode<T>> {
        private IntervalTreeGuide() {
        }

        @Override
        public IntervalNode<T> getNextSibling(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node parent2;
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(0);
            }
            if ((parent2 = element.getParent()) == null) {
                return null;
            }
            return ((IntervalNode)parent2).getLeft() == element ? ((IntervalNode)parent2).getRight() : null;
        }

        @Override
        public IntervalNode<T> getPrevSibling(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node parent2;
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(1);
            }
            if ((parent2 = element.getParent()) == null) {
                return null;
            }
            return ((IntervalNode)parent2).getRight() == element ? ((IntervalNode)parent2).getLeft() : null;
        }

        @Override
        public IntervalNode<T> getFirstChild(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node left;
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(2);
            }
            return (left = element.getLeft()) == null ? element.getRight() : left;
        }

        @Override
        public IntervalNode<T> getParent(@NotNull IntervalNode<T> element) {
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(3);
            }
            return element.getParent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNextSibling";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrevSibling";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IntTrinity {
        private final int first;
        private final int second;
        private final int third;

        private IntTrinity(int first2, int second, int third) {
            this.first = first2;
            this.second = second;
            this.third = third;
        }
    }

    static class IntervalNode<E>
    extends RedBlackTree.Node<E> {
        private volatile int myStart;
        private volatile int myEnd;
        final List<Getter<E>> intervals;
        int maxEnd;
        int delta;
        private volatile long cachedDeltaUpToRoot;
        @NotNull
        private final IntervalTreeImpl<E> myIntervalTree;
        private static final AtomicFieldUpdater<IntervalNode, Long> cachedDeltaUpdater = AtomicFieldUpdater.forLongFieldIn(IntervalNode.class);

        @Override
        public IntervalNode<E> getLeft() {
            return (IntervalNode)this.left;
        }

        @Override
        public IntervalNode<E> getRight() {
            return (IntervalNode)this.right;
        }

        @Override
        public IntervalNode<E> getParent() {
            return (IntervalNode)this.parent;
        }

        public boolean processAliveKeys(@NotNull Processor<? super E> processor2) {
            if (processor2 == null) {
                IntervalNode.$$$reportNull$$$0(2);
            }
            for (int i = 0; i < this.intervals.size(); ++i) {
                Getter<E> interval = this.intervals.get(i);
                E key = interval.get();
                if (key == null || processor2.process(key)) continue;
                return false;
            }
            return true;
        }

        public boolean hasAliveKey(boolean purgeDead) {
            boolean hasAliveInterval = false;
            for (int i = this.intervals.size() - 1; i >= 0; --i) {
                Getter<E> interval = this.intervals.get(i);
                if (interval.get() != null) {
                    hasAliveInterval = true;
                    if (!purgeDead) break;
                    continue;
                }
                if (!purgeDead) continue;
                ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
                this.removeIntervalInternal(i);
            }
            return hasAliveInterval;
        }

        private boolean removeInterval(@NotNull E key) {
            if (key == null) {
                IntervalNode.$$$reportNull$$$0(3);
            }
            ((IntervalTreeImpl)this.myIntervalTree).checkBelongsToTheTree(key, true);
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            for (int i = this.intervals.size() - 1; i >= 0; --i) {
                Getter<E> interval = this.intervals.get(i);
                E t = interval.get();
                if (t != key) continue;
                this.removeIntervalInternal(i);
                if (this.intervals.isEmpty()) {
                    this.myIntervalTree.removeNode(this);
                    return true;
                }
                return false;
            }
            assert (false) : "interval not found: " + key + "; " + this.intervals;
            return false;
        }

        private boolean isAttachedToTree() {
            return this.isFlagSet((byte)2);
        }

        private void setAttachedToTree(boolean attached) {
            this.setFlag((byte)2, attached);
        }

        void removeIntervalInternal(int i) {
            this.intervals.remove(i);
            if (this.isAttachedToTree()) {
                assert (((IntervalTreeImpl)this.myIntervalTree).keySize > 0) : IntervalTreeImpl.access$200(this.myIntervalTree);
                ((IntervalTreeImpl)this.myIntervalTree).keySize--;
            }
        }

        void addInterval(@NotNull E interval) {
            if (interval == null) {
                IntervalNode.$$$reportNull$$$0(4);
            }
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            this.intervals.add(this.createGetter(interval));
            if (this.isAttachedToTree()) {
                ((IntervalTreeImpl)this.myIntervalTree).keySize++;
                this.myIntervalTree.setNode(interval, this);
            }
        }

        protected Getter<E> createGetter(@NotNull E interval) {
            if (interval == null) {
                IntervalNode.$$$reportNull$$$0(5);
            }
            return new WeakReferencedGetter(interval, ((IntervalTreeImpl)this.myIntervalTree).myReferenceQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int computeDeltaUpToRoot() {
            block7: while (this.isValid()) {
                int treeModCount = this.myIntervalTree.getModCount();
                long packedOffsets = this.cachedDeltaUpToRoot;
                if (IntervalNode.modCount(packedOffsets) == treeModCount) {
                    return IntervalNode.deltaUpToRoot(packedOffsets);
                }
                try {
                    boolean allDeltasAreNull;
                    int deltaUp;
                    block17: {
                        this.myIntervalTree.l.readLock().lock();
                        RedBlackTree.Node node = this;
                        IntervalNode<E> treeRoot = this.myIntervalTree.getRoot();
                        if (treeRoot == null) {
                            int n = this.delta;
                            return n;
                        }
                        deltaUp = 0;
                        allDeltasAreNull = true;
                        int height = 0;
                        long path2 = 0L;
                        while (node != treeRoot) {
                            long nodePackedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
                            if (((IntervalNode)node).isValid() && IntervalNode.modCount(nodePackedOffsets) == treeModCount) {
                                deltaUp = IntervalNode.deltaUpToRoot(nodePackedOffsets) - ((IntervalNode)node).delta;
                                allDeltasAreNull = IntervalNode.allDeltasUpAreNull(nodePackedOffsets);
                                break;
                            }
                            RedBlackTree.Node parent2 = ((IntervalNode)node).getParent();
                            if (parent2 == null) {
                                int n = deltaUp;
                                return n;
                            }
                            path2 = path2 << 1 | (long)(((IntervalNode)parent2).getLeft() == node ? 0 : 1);
                            node = parent2;
                            ++height;
                        }
                        assert (height < 63) : height;
                        do {
                            int nodeDelta;
                            if (((IntervalNode)node).isValid() && !((IntervalNode)node).tryToSetCachedValues(deltaUp += (nodeDelta = ((IntervalNode)node).delta), allDeltasAreNull &= nodeDelta == 0, treeModCount)) continue block7;
                            if (node == this) break block17;
                            node = (path2 & 1L) == 0L ? ((IntervalNode)node).getLeft() : ((IntervalNode)node).getRight();
                            path2 >>= 1;
                        } while (node != null);
                        int n = deltaUp;
                        return n;
                    }
                    assert (deltaUp == 0 || !allDeltasAreNull);
                    int n = deltaUp;
                    return n;
                }
                finally {
                    this.myIntervalTree.l.readLock().unlock();
                    continue;
                }
                break;
            }
            return 0;
        }

        int changeDelta(int change) {
            if (change != 0) {
                this.setCachedValues(0, false, 0);
                return this.delta += change;
            }
            return this.delta;
        }

        void clearDelta() {
            if (this.delta != 0) {
                this.setCachedValues(0, false, 0);
                this.delta = 0;
            }
        }

        public int setIntervalStart(int start) {
            this.myStart = start;
            return this.myStart;
        }

        public int setIntervalEnd(int end) {
            this.myEnd = end;
            return this.myEnd;
        }

        public boolean isValid() {
            return this.isFlagSet((byte)4);
        }

        public boolean setValid(boolean value) {
            this.setFlag((byte)4, value);
            return value;
        }

        public int intervalStart() {
            return this.myStart;
        }

        public int intervalEnd() {
            return this.myEnd;
        }

        @NotNull
        public IntervalTreeImpl<E> getTree() {
            IntervalTreeImpl<E> intervalTreeImpl = this.myIntervalTree;
            if (intervalTreeImpl == null) {
                IntervalNode.$$$reportNull$$$0(6);
            }
            return intervalTreeImpl;
        }

        private void setCachedValues(int deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            this.cachedDeltaUpToRoot = IntervalNode.packValues(deltaUpToRoot, allDeltaUpToRootAreNull, modCount);
        }

        private static long packValues(long deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            return deltaUpToRoot << 33 | (allDeltaUpToRootAreNull ? 0x100000000L : 0L) | (long)modCount;
        }

        private boolean tryToSetCachedValues(int deltaUpToRoot, boolean allDeltasUpAreNull, int treeModCount) {
            if (this.myIntervalTree.getModCount() != treeModCount) {
                return false;
            }
            long newValue = IntervalNode.packValues(deltaUpToRoot, allDeltasUpAreNull, treeModCount);
            long oldValue = this.cachedDeltaUpToRoot;
            return cachedDeltaUpdater.compareAndSetLong(this, oldValue, newValue);
        }

        private static boolean allDeltasUpAreNull(long packedOffsets) {
            return (packedOffsets >> 32 & 1L) != 0L;
        }

        private static int modCount(long packedOffsets) {
            return (int)packedOffsets;
        }

        private static int deltaUpToRoot(long packedOffsets) {
            return (int)(packedOffsets >> 33);
        }

        @NonNls
        public String toString() {
            return "Node: " + this.intervals;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intervalTree";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interval";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processAliveKeys";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeInterval";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addInterval";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createGetter";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class WeakReferencedGetter<T>
        extends WeakReference<T>
        implements Getter<T> {
            private WeakReferencedGetter(@NotNull T referent, @NotNull ReferenceQueue<? super T> q) {
                if (referent == null) {
                    WeakReferencedGetter.$$$reportNull$$$0(0);
                }
                if (q == null) {
                    WeakReferencedGetter.$$$reportNull$$$0(1);
                }
                super(referent, q);
            }

            @NonNls
            public String toString() {
                return "Ref: " + this.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "referent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "q";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode$WeakReferencedGetter";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

