/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.types.Variance;

public class KtTypeParameter
extends KtNamedDeclarationStub<KotlinTypeParameterStub> {
    public KtTypeParameter(@NotNull ASTNode node) {
        super(node);
    }

    public KtTypeParameter(@NotNull KotlinTypeParameterStub stub) {
        super(stub, KtStubElementTypes.TYPE_PARAMETER);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitTypeParameter(this, data);
    }

    @NotNull
    public Variance getVariance() {
        KotlinTypeParameterStub stub = (KotlinTypeParameterStub)this.getStub();
        if (stub != null) {
            if (stub.isOutVariance()) {
                return Variance.OUT_VARIANCE;
            }
            if (stub.isInVariance()) {
                return Variance.IN_VARIANCE;
            }
            return Variance.INVARIANT;
        }
        KtModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            return Variance.INVARIANT;
        }
        if (modifierList.hasModifier(KtTokens.OUT_KEYWORD)) {
            return Variance.OUT_VARIANCE;
        }
        if (modifierList.hasModifier(KtTokens.IN_KEYWORD)) {
            return Variance.IN_VARIANCE;
        }
        return Variance.INVARIANT;
    }

    @Nullable
    public KtTypeReference setExtendsBound(@Nullable KtTypeReference typeReference) {
        KtTypeReference currentExtendsBound = this.getExtendsBound();
        if (currentExtendsBound != null) {
            if (typeReference == null) {
                Object colon = this.findChildByType(KtTokens.COLON);
                if (colon != null) {
                    colon.delete();
                }
                currentExtendsBound.delete();
                return null;
            }
            return (KtTypeReference)currentExtendsBound.replace(typeReference);
        }
        if (typeReference != null) {
            PsiElement colon = this.addAfter(new KtPsiFactory(this.getProject()).createColon(), this.getNameIdentifier());
            return (KtTypeReference)this.addAfter(typeReference, colon);
        }
        return null;
    }

    @Nullable
    public KtTypeReference getExtendsBound() {
        return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        KtTypeParameterListOwner owner = PsiTreeUtil.getParentOfType((PsiElement)this, KtTypeParameterListOwner.class);
        return new LocalSearchScope(owner != null ? owner : this);
    }
}

