/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformConfigurator;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformConfigurator;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R6\u0010\u0003\u001a*\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JvmPlatform;", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "()V", "defaultImports", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "multiTargetPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "getMultiTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getDefaultImports", "includeKotlinComparisons", "frontend.java"})
public final class JvmPlatform
extends TargetPlatform {
    private static final MemoizedFunctionToNotNull<Boolean, List<ImportPath>> defaultImports;
    @NotNull
    private static final PlatformConfigurator platformConfigurator;
    @NotNull
    private static final MultiTargetPlatform.Specific multiTargetPlatform;
    public static final JvmPlatform INSTANCE;

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports(boolean includeKotlinComparisons) {
        Object r = defaultImports.invoke(includeKotlinComparisons);
        Intrinsics.checkExpressionValueIsNotNull(r, "defaultImports(includeKotlinComparisons)");
        return (List)r;
    }

    @Override
    @NotNull
    public PlatformConfigurator getPlatformConfigurator() {
        return platformConfigurator;
    }

    @Override
    @NotNull
    public MultiTargetPlatform.Specific getMultiTargetPlatform() {
        return multiTargetPlatform;
    }

    private JvmPlatform() {
        super("JVM");
    }

    static {
        JvmPlatform jvmPlatform;
        INSTANCE = jvmPlatform = new JvmPlatform();
        defaultImports = new LockBasedStorageManager().createMemoizedFunction(defaultImports.1.INSTANCE);
        platformConfigurator = JvmPlatformConfigurator.INSTANCE;
        multiTargetPlatform = new MultiTargetPlatform.Specific(jvmPlatform.getPlatformName());
    }
}

