/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.util;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.javacs.kt.util.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0014\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0001\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"fileExtension", "", "Ljava/net/URI;", "getFileExtension", "(Ljava/net/URI;)Ljava/lang/String;", "filePath", "Ljava/nio/file/Path;", "getFilePath", "(Ljava/net/URI;)Ljava/nio/file/Path;", "describeURI", "uri", "describeURIs", "uris", "", "parseURI", "shared"})
@SourceDebugExtension(value={"SMAP\nURIs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URIs.kt\norg/javacs/kt/util/URIsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1#2:42\n1549#3:43\n1620#3,3:44\n*S KotlinDebug\n*F\n+ 1 URIs.kt\norg/javacs/kt/util/URIsKt\n*L\n32#1:43\n32#1:44,3\n*E\n"})
public final class URIsKt {
    @NotNull
    public static final URI parseURI(@NotNull String uri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            boolean bl = false;
            String string = URLDecoder.decode(uri, StandardCharsets.UTF_8.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(uri, StandardCharsets.UTF_8.toString())");
            object = Result.constructor-impl((Object)StringsKt.replace$default((String)string, (String)" ", (String)"%20", (boolean)false, (int)4, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        URI uRI = URI.create((String)(Result.isFailure-impl((Object)object) ? uri : object));
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(runCatching { URL\u202620\") }.getOrDefault(uri))");
        return uRI;
    }

    @Nullable
    public static final Path getFilePath(@NotNull URI $this$filePath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$filePath, (String)"<this>");
        Object object2 = $this$filePath;
        try {
            URI $this$_get_filePath__u24lambda_u241 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Paths.get($this$_get_filePath__u24lambda_u241));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Nullable
    public static final String getFileExtension(@NotNull URI $this$fileExtension) {
        String string;
        int end;
        Intrinsics.checkNotNullParameter((Object)$this$fileExtension, (String)"<this>");
        String string2 = $this$fileExtension.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        String str = string2;
        int dotOffset = StringsKt.lastIndexOf$default((CharSequence)str, (String)".", (int)0, (boolean)false, (int)6, null);
        int queryStart = StringsKt.indexOf$default((CharSequence)str, (String)"?", (int)0, (boolean)false, (int)6, null);
        int n = end = queryStart != -1 ? queryStart : str.length();
        if (dotOffset < 0) {
            string = null;
        } else {
            String string3 = str.substring(dotOffset + 1, end);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String describeURIs(@NotNull Collection<URI> uris) {
        Object object;
        Intrinsics.checkNotNullParameter(uris, (String)"uris");
        if (uris.isEmpty()) {
            object = "0 files";
        } else if (uris.size() > 5) {
            object = uris.size() + " files";
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = uris;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                URI uRI = (URI)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(URIsKt.describeURI((URI)p0));
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }
        return object;
    }

    @NotNull
    public static final String describeURI(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return URIsKt.describeURI(URIsKt.parseURI(uri));
    }

    @NotNull
    public static final String describeURI(@NotNull URI uri) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                object = uri.getPath();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Pair<String, String> pair = UtilsKt.partitionAroundLast(it, "/");
                String parent = (String)pair.component1();
                String fileName = (String)pair.component2();
                String string = ".../" + StringsKt.substringAfterLast$default((String)parent, (String)"/", null, (int)2, null) + fileName;
                object = string;
                if (string != null) break block3;
            }
            String string = uri.toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        }
        return object;
    }
}

