/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsBlock
extends SourceInfoAwareJsNode
implements JsStatement {
    @NotNull
    private final List<JsStatement> statements;

    public JsBlock() {
        this(new SmartList<JsStatement>());
    }

    public JsBlock(JsStatement statement2) {
        this(new SmartList<JsStatement>(statement2));
    }

    public JsBlock(JsStatement ... statements) {
        this(new SmartList<JsStatement>(statements));
    }

    public JsBlock(@NotNull List<JsStatement> statements) {
        if (statements == null) {
            JsBlock.$$$reportNull$$$0(0);
        }
        this.statements = statements;
    }

    @NotNull
    public List<JsStatement> getStatements() {
        List<JsStatement> list2 = this.statements;
        if (list2 == null) {
            JsBlock.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public boolean isTransparent() {
        return false;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitBlock(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.statements);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptStatementList(this.statements);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsBlock deepCopy() {
        JsBlock jsBlock = (JsBlock)new JsBlock(AstUtil.deepCopy(this.statements)).withMetadataFrom(this);
        if (jsBlock == null) {
            JsBlock.$$$reportNull$$$0(2);
        }
        return jsBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/backend/ast/JsBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/backend/ast/JsBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

