/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.SourceExclusions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"findJavaSourceFiles", "", "Ljava/nio/file/Path;", "root", "logAdded", "", "sources", "", "name", "", "logRemoved", "server"})
public final class CompilerClassPathKt {
    private static final Set<Path> findJavaSourceFiles(Path root) {
        PathMatcher sourceMatcher = FileSystems.getDefault().getPathMatcher("glob:*.java");
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)new SourceExclusions(root).walkIncluded(), (Function1)((Function1)new Function1<Path, Boolean>(sourceMatcher){
            final /* synthetic */ PathMatcher $sourceMatcher;
            {
                this.$sourceMatcher = $sourceMatcher;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$sourceMatcher.matches(it.getFileName());
            }
        })));
    }

    private static final void logAdded(Collection<? extends Path> sources, String name) {
        if (sources.isEmpty()) {
            return;
        }
        if (sources.size() > 5) {
            Object[] objectArray = new Object[]{sources.size(), name};
            LoggerKt.getLOG().info("Adding {} files to {}", objectArray);
        } else {
            Object[] objectArray = new Object[]{sources, name};
            LoggerKt.getLOG().info("Adding {} to {}", objectArray);
        }
    }

    private static final void logRemoved(Collection<? extends Path> sources, String name) {
        if (sources.isEmpty()) {
            return;
        }
        if (sources.size() > 5) {
            Object[] objectArray = new Object[]{sources.size(), name};
            LoggerKt.getLOG().info("Removing {} files from {}", objectArray);
        } else {
            Object[] objectArray = new Object[]{sources, name};
            LoggerKt.getLOG().info("Removing {} from {}", objectArray);
        }
    }

    public static final /* synthetic */ void access$logAdded(Collection sources, String name) {
        CompilerClassPathKt.logAdded(sources, name);
    }

    public static final /* synthetic */ void access$logRemoved(Collection sources, String name) {
        CompilerClassPathKt.logRemoved(sources, name);
    }

    public static final /* synthetic */ Set access$findJavaSourceFiles(Path root) {
        return CompilerClassPathKt.findJavaSourceFiles(root);
    }
}

