/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.requests;

import java.lang.reflect.Constructor;
import junit.framework.TestCase;
import org.junit.internal.runners.OldTestClassRunner;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRequest
extends Request {
    private final Class<?> fTestClass;

    public ClassRequest(Class<?> each) {
        this.fTestClass = each;
    }

    @Override
    public Runner getRunner() {
        Class runnerClass = this.getRunnerClass(this.fTestClass);
        try {
            Constructor constructor2 = runnerClass.getConstructor(Class.class);
            Runner runner = (Runner)constructor2.newInstance(this.fTestClass);
            return runner;
        }
        catch (Exception e) {
            return Request.errorReport(this.fTestClass, e).getRunner();
        }
    }

    Class getRunnerClass(Class<?> testClass) {
        RunWith annotation2 = testClass.getAnnotation(RunWith.class);
        if (annotation2 != null) {
            return annotation2.value();
        }
        if (this.isPre4Test(testClass)) {
            return OldTestClassRunner.class;
        }
        return TestClassRunner.class;
    }

    boolean isPre4Test(Class<?> testClass) {
        return TestCase.class.isAssignableFrom(testClass);
    }
}

