/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.JsMappingKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheInfo;
import org.jetbrains.kotlin.ir.backend.js.ic.DataKt;
import org.jetbrains.kotlin.ir.backend.js.ic.IcCacheInfo;
import org.jetbrains.kotlin.ir.backend.js.ic.IcKt;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcData;
import org.jetbrains.kotlin.name.FqName;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\u001af\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u001a.\u0010\u0016\u001a\u00020\u00152\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u001a$\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\"\u0013\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"compilerVersion", "Lkotlin/ULong;", "J", "buildCache", "", "cachePath", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "mainModule", "Lorg/jetbrains/kotlin/ir/backend/js/MainModule$Klib;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "dependencies", "", "friendDependencies", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "forceClean", "icCache", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IcCacheInfo;", "checkCaches", "cachePaths", "", "skipLib", "md5", "Ljava/io/File;", "additional", "", "(Ljava/io/File;Ljava/lang/Iterable;)J", "backend.js"})
public final class FileUtilKt {
    private static final long compilerVersion = URandomKt.nextULong(Random.Default);

    /*
     * WARNING - void declaration
     */
    public static final boolean buildCache(@NotNull String cachePath, @NotNull Project project, @NotNull MainModule.Klib mainModule, @NotNull CompilerConfiguration configuration2, @NotNull Collection<String> dependencies2, @NotNull Collection<String> friendDependencies, @NotNull Set<FqName> exportedDeclarations, boolean forceClean, @NotNull IcCacheInfo icCache) {
        CacheInfo oldCacheInfo;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(cachePath, "cachePath");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(mainModule, "mainModule");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        Intrinsics.checkNotNullParameter(friendDependencies, "friendDependencies");
        Intrinsics.checkNotNullParameter(exportedDeclarations, "exportedDeclarations");
        Intrinsics.checkNotNullParameter(icCache, "icCache");
        Iterable $this$mapNotNull$iv = dependencies2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ULong uLong;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String path2 = new File(it).getCanonicalPath();
            ULong uLong2 = icCache.getMd5().get(path2);
            if (uLong2 == null) continue;
            ULong it$iv$iv = uLong = uLong2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List<ULong> dependencyHashes = CollectionsKt.plus((Collection)((List)destination$iv$iv), ULong.box-impl(compilerVersion));
        long md5 = FileUtilKt.md5(new File(mainModule.getLibPath()), (Iterable<ULong>)dependencyHashes);
        if (!forceClean && (oldCacheInfo = CacheInfo.Companion.load(cachePath)) != null && md5 == oldCacheInfo.getMd5-s-VKNKU()) {
            return false;
        }
        File icDir = new File(cachePath);
        File[] fileArray = icDir.listFiles(FileUtilKt::buildCache$lambda-1);
        Intrinsics.checkNotNull(fileArray);
        File[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach2 = false;
        for (File element$iv : $this$forEach$iv) {
            File it = element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            FilesKt.deleteRecursively(it);
        }
        new File(icDir, "info").delete();
        icDir.mkdirs();
        SerializedIcData icData = IcKt.prepareSingleLibraryIcCache(project, configuration2, mainModule.getLibPath(), dependencies2, friendDependencies, exportedDeclarations, icCache.getData());
        DataKt.writeTo(icData, new File(cachePath));
        new CacheInfo(cachePath, mainModule.getLibPath(), md5, null).save();
        return true;
    }

    public static /* synthetic */ boolean buildCache$default(String string2, Project project, MainModule.Klib klib, CompilerConfiguration compilerConfiguration, Collection collection, Collection collection2, Set set, boolean bl, IcCacheInfo icCacheInfo, int n, Object object) {
        if ((n & 0x40) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            icCacheInfo = IcCacheInfo.Companion.getEMPTY();
        }
        return FileUtilKt.buildCache(string2, project, klib, compilerConfiguration, collection, collection2, set, bl, icCacheInfo);
    }

    private static final long md5(File $this$md5, Iterable<ULong> additional) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        Iterator<ULong> iterator2 = additional.iterator();
        while (iterator2.hasNext()) {
            long ul = iterator2.next().unbox-impl();
            md5.update(JsMappingKt.toByteArray(ul));
        }
        FileUtilKt.md5$process$default($this$md5, md5, null, 2, null);
        byte[] d = md5.digest();
        byte by = d[0];
        long l = ULong.constructor-impl(by);
        long l2 = 255L;
        l = ULong.constructor-impl(l & l2);
        byte by2 = d[1];
        long l3 = ULong.constructor-impl(by2);
        long l4 = 255L;
        l3 = ULong.constructor-impl(l3 & l4);
        int n = 8;
        l3 = ULong.constructor-impl(l3 << n);
        l = ULong.constructor-impl(l | l3);
        byte by3 = d[2];
        long l5 = ULong.constructor-impl(by3);
        long l6 = 255L;
        l5 = ULong.constructor-impl(l5 & l6);
        int n2 = 16;
        l5 = ULong.constructor-impl(l5 << n2);
        l = ULong.constructor-impl(l | l5);
        byte by4 = d[3];
        long l7 = ULong.constructor-impl(by4);
        long l8 = 255L;
        l7 = ULong.constructor-impl(l7 & l8);
        int n3 = 24;
        l7 = ULong.constructor-impl(l7 << n3);
        l = ULong.constructor-impl(l | l7);
        byte by5 = d[4];
        long l9 = ULong.constructor-impl(by5);
        long l10 = 255L;
        l9 = ULong.constructor-impl(l9 & l10);
        int n4 = 32;
        l9 = ULong.constructor-impl(l9 << n4);
        l = ULong.constructor-impl(l | l9);
        byte by6 = d[5];
        long l11 = ULong.constructor-impl(by6);
        long l12 = 255L;
        l11 = ULong.constructor-impl(l11 & l12);
        int n5 = 40;
        l11 = ULong.constructor-impl(l11 << n5);
        l = ULong.constructor-impl(l | l11);
        byte by7 = d[6];
        long l13 = ULong.constructor-impl(by7);
        long l14 = 255L;
        l13 = ULong.constructor-impl(l13 & l14);
        int n6 = 48;
        l13 = ULong.constructor-impl(l13 << n6);
        l = ULong.constructor-impl(l | l13);
        byte by8 = d[7];
        long l15 = ULong.constructor-impl(by8);
        long l16 = 255L;
        l15 = ULong.constructor-impl(l15 & l16);
        int n7 = 56;
        l15 = ULong.constructor-impl(l15 << n7);
        return ULong.constructor-impl(l | l15);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IcCacheInfo checkCaches(@NotNull Collection<String> dependencies2, @NotNull List<String> cachePaths, @Nullable String skipLib) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        Set<String> set;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        Intrinsics.checkNotNullParameter(cachePaths, "cachePaths");
        String skipLibPath = new File(skipLib).getCanonicalPath();
        Iterable $this$map$iv2 = dependencies2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            String string2 = (String)item$iv$iv;
            set = destination$iv$iv;
            boolean bl = false;
            object = new File((String)it).getCanonicalPath();
            set.add((String)object);
        }
        Set<String> allLibs = SetsKt.minus(CollectionsKt.toSet((List)destination$iv$iv), skipLibPath);
        Iterable $this$map$iv3 = cachePaths;
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String bl = (String)item$iv$iv;
            set = destination$iv$iv2;
            boolean bl2 = false;
            CacheInfo cacheInfo = CacheInfo.Companion.load((String)it);
            if (cacheInfo == null) {
                throw new IllegalStateException(Intrinsics.stringPlus("Cannot load IC cache from ", it).toString());
            }
            object = cacheInfo;
            set.add((String)object);
        }
        List caches = (List)destination$iv$iv2;
        Iterable $i$f$map22 = caches;
        set = allLibs;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CacheInfo bl2 = (CacheInfo)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            String string3 = it.getLibPath();
            object.add(string3);
        }
        object = (List)destination$iv$iv3;
        Set<String> missedLibs = SetsKt.minus(set, (Iterable)object);
        if (!missedLibs.isEmpty()) {
            throw new IllegalStateException(Intrinsics.stringPlus("Missing caches for libraries: ", missedLibs).toString());
        }
        Map result2 = new LinkedHashMap();
        Map md5 = new LinkedHashMap();
        for (CacheInfo c : caches) {
            if (!allLibs.contains(c.getLibPath())) {
                throw new IllegalStateException(Intrinsics.stringPlus("Missing library: ", c.getLibPath()).toString());
            }
            result2.put(c.getLibPath(), DataKt.readIcData(new File(c.getPath())));
            md5.put(c.getLibPath(), ULong.box-impl(c.getMd5-s-VKNKU()));
        }
        return new IcCacheInfo(result2, md5);
    }

    public static /* synthetic */ IcCacheInfo checkCaches$default(Collection collection, List list2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return FileUtilKt.checkCaches(collection, list2, string2);
    }

    private static final boolean buildCache$lambda-1(File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        String string2 = file2.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "file.name");
        return StringsKt.startsWith$default(string2, "ic-", false, 2, null);
    }

    private static final void md5$process(File $this$md5_u24process, MessageDigest md5, String prefix) {
        if ($this$md5_u24process.isDirectory()) {
            File[] fileArray = $this$md5_u24process.listFiles();
            Intrinsics.checkNotNull(fileArray);
            File[] $this$sortedBy$iv = fileArray;
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    String string2 = it.getName();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string2));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                String string2 = Intrinsics.stringPlus(prefix, it.getName());
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                md5.update(byArray);
                Intrinsics.checkNotNullExpressionValue(it, "it");
                FileUtilKt.md5$process(it, md5, prefix + it.getName() + '/');
            }
        } else {
            md5.update(FilesKt.readBytes($this$md5_u24process));
        }
    }

    static /* synthetic */ void md5$process$default(File file2, MessageDigest messageDigest, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        FileUtilKt.md5$process(file2, messageDigest, string2);
    }
}

