/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.extensions.FirExtensionService;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractPhaseTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirAnnotationResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirPartialImportResolveTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J@\u0010\u001b\u001a\u0012\u0012\b\u0012\u00060\u001dj\u0002`\u001e\u0012\u0004\u0012\u00020\u001f0\u001c*\u00020\u00192\u0010\u0010 \u001a\f\u0012\b\u0012\u00060\u001dj\u0002`\u001e0!2\u0010\u0010\"\u001a\f\u0012\b\u0012\u00060\u001dj\u0002`\u001e0!H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPluginAnnotationsResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractPhaseTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "annotationTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirAnnotationResolveTransformer;", "extensionService", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionService;", "getExtensionService", "()Lorg/jetbrains/kotlin/fir/extensions/FirExtensionService;", "importTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPartialImportResolveTransformer;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "resolveAnnotations", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "annotations", "", "metaAnnotations", "resolve"})
public final class FirPluginAnnotationsResolveTransformer
extends FirAbstractPhaseTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirAnnotationResolveTransformer annotationTransformer;
    @NotNull
    private final FirPartialImportResolveTransformer importTransformer;
    @NotNull
    private final FirExtensionService extensionService;

    public FirPluginAnnotationsResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(FirResolvePhase.ANNOTATIONS_FOR_PLUGINS);
        this.session = session2;
        this.annotationTransformer = new FirAnnotationResolveTransformer(this.getSession(), scopeSession);
        this.importTransformer = new FirPartialImportResolveTransformer(this.getSession());
        this.extensionService = FirExtensionServiceKt.getExtensionService(this.getSession());
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirExtensionService getExtensionService() {
        return this.extensionService;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException("Should not be here");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.checkSessionConsistency(file2);
        if (!FirExtensionServiceKt.getHasPredicateBasedExtensions(this.extensionService)) {
            return file2;
        }
        FirRegisteredPluginAnnotations registeredPluginAnnotations = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.getSession());
        Multimap<FqName, FirRegularClass> newAnnotations = this.resolveAnnotations(file2, registeredPluginAnnotations.getAnnotations(), registeredPluginAnnotations.getMetaAnnotations());
        if (!newAnnotations.isEmpty()) {
            void destination$iv;
            Collection collection;
            for (FqName fqName2 : newAnnotations.keySet()) {
                Intrinsics.checkNotNullExpressionValue(fqName2, "metaAnnotation");
                collection = newAnnotations.get(fqName2);
                Intrinsics.checkNotNullExpressionValue(collection, "newAnnotations[metaAnnotation]");
                registeredPluginAnnotations.registerUserDefinedAnnotation(fqName2, collection);
            }
            Collection<FirRegularClass> collection2 = newAnnotations.values();
            Intrinsics.checkNotNullExpressionValue(collection2, "newAnnotations.values()");
            Iterable iterable = collection2;
            collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : iterable) {
                void it;
                FirRegularClass firRegularClass = (FirRegularClass)item$iv;
                void var13_15 = destination$iv;
                boolean bl = false;
                FqName fqName3 = it.getSymbol().getClassId().asSingleFqName();
                var13_15.add(fqName3);
            }
            Set newAnnotationsFqns = (Set)destination$iv;
            this.resolveAnnotations(file2, newAnnotationsFqns, SetsKt.emptySet());
        }
        return file2;
    }

    private final Multimap<FqName, FirRegularClass> resolveAnnotations(FirFile $this$resolveAnnotations, Set<FqName> annotations2, Set<FqName> metaAnnotations) {
        this.importTransformer.setAcceptableFqNames(annotations2);
        $this$resolveAnnotations.transformImports(this.importTransformer, null);
        this.annotationTransformer.setMetaAnnotations(metaAnnotations);
        LinkedHashMultimap newAnnotations = LinkedHashMultimap.create();
        FirTransformer firTransformer = this.annotationTransformer;
        Intrinsics.checkNotNullExpressionValue(newAnnotations, "newAnnotations");
        $this$resolveAnnotations.transform(firTransformer, newAnnotations);
        return newAnnotations;
    }
}

