/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.HashingStrategy;
import org.jetbrains.kotlin.com.intellij.util.containers.RefValueHashMap;

abstract class ConcurrentRefHashMap<K, V>
extends AbstractMap<K, V>
implements HashingStrategy<K>,
ConcurrentMap<K, V> {
    final ReferenceQueue<K> myReferenceQueue;
    private final ConcurrentMap<KeyReference<K>, V> myMap;
    @NotNull
    private final HashingStrategy<? super K> myHashingStrategy;
    private static final HardKey<?> NULL_KEY = new HardKey<Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        void setKey(Object key, int hash) {
        }
    };
    static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(Runtime.getRuntime().availableProcessors(), 4);
    private static final HashingStrategy<?> THIS = new HashingStrategy<Object>(){

        @Override
        public int hashCode(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<HardKey<?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());
    private Set<Map.Entry<K, V>> entrySet;

    @NotNull
    abstract KeyReference<K> createKeyReference(@NotNull K var1, @NotNull HashingStrategy<? super K> var2);

    @NotNull
    private KeyReference<K> createKeyReference(@Nullable K key) {
        if (key == null) {
            HardKey<?> hardKey = NULL_KEY;
            if (hardKey == null) {
                ConcurrentRefHashMap.$$$reportNull$$$0(0);
            }
            return hardKey;
        }
        KeyReference<? super K> keyReference = this.createKeyReference(key, this.myHashingStrategy);
        if (keyReference == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(1);
        }
        return keyReference;
    }

    private boolean processQueue() {
        KeyReference wk;
        boolean processed = false;
        while ((wk = (KeyReference)((Object)this.myReferenceQueue.poll())) != null) {
            this.myMap.remove(wk);
            processed = true;
        }
        return processed;
    }

    ConcurrentRefHashMap() {
        this(16);
    }

    private ConcurrentRefHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    private ConcurrentRefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, DEFAULT_CONCURRENCY_LEVEL, THIS);
    }

    ConcurrentRefHashMap(@NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(2);
        }
        this(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL, hashingStrategy);
    }

    ConcurrentRefHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @Nullable HashingStrategy<? super K> hashingStrategy) {
        this.myReferenceQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy == THIS ? this : (hashingStrategy == null ? HashingStrategy.canonical() : hashingStrategy);
        this.myMap = new ConcurrentHashMap<KeyReference<K>, V>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(@Nullable Object key) {
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            boolean bl = this.myMap.containsKey(hardKey);
            return bl;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public boolean containsValue(Object value2) {
        throw RefValueHashMap.pointlessContainsValue();
    }

    @NotNull
    private HardKey<K> createHardKey(@Nullable Object o) {
        if (o == null) {
            HardKey<?> hardKey = NULL_KEY;
            if (hardKey == null) {
                ConcurrentRefHashMap.$$$reportNull$$$0(3);
            }
            return hardKey;
        }
        Object key = o;
        HardKey<?> hardKey = HARD_KEY.get();
        hardKey.setKey(key, this.myHashingStrategy.hashCode(key));
        HardKey<?> hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(4);
        }
        return hardKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@Nullable Object key) {
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v = this.myMap.get(hardKey);
            return v;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public V put(@Nullable K key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(5);
        }
        this.processQueue();
        KeyReference<K> weakKey = this.createKeyReference(key);
        return this.myMap.put(weakKey, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@Nullable Object key) {
        this.processQueue();
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v = this.myMap.remove(hardKey);
            return v;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        EntrySet entrySet = es;
        if (entrySet == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(6);
        }
        return entrySet;
    }

    @Override
    public V putIfAbsent(@Nullable K key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(7);
        }
        this.processQueue();
        return this.myMap.putIfAbsent(this.createKeyReference(key), value2);
    }

    @Override
    public boolean remove(@Nullable Object key, @NotNull Object value2) {
        if (value2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(8);
        }
        this.processQueue();
        return this.myMap.remove(this.createKeyReference(key), value2);
    }

    @Override
    public boolean replace(@Nullable K key, @NotNull V oldValue, @NotNull V newValue2) {
        if (oldValue == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(9);
        }
        if (newValue2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(10);
        }
        this.processQueue();
        return this.myMap.replace(this.createKeyReference(key), oldValue, newValue2);
    }

    @Override
    public V replace(@Nullable K key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(11);
        }
        this.processQueue();
        return this.myMap.replace(this.createKeyReference(key), value2);
    }

    @Override
    public int hashCode(@Nullable K object) {
        int h = object == null ? 0 : object.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    @Override
    public boolean equals(K o1, K o2) {
        return Objects.equals(o1, o2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<KeyReference<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentRefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<KeyReference<K>, V>> hashIterator;
                private RefEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        KeyReference wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null && wk != NULL_KEY) continue;
                        }
                        this.next = new RefEntry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    RefEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            ConcurrentRefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = ConcurrentRefHashMap.this.createHardKey(e.getKey());
            try {
                Object hv = ConcurrentRefHashMap.this.myMap.get(key);
                boolean bl = hv == null ? ev == null && ConcurrentRefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
                if (toRemove) {
                    ConcurrentRefHashMap.this.myMap.remove(key);
                }
            }
            finally {
                key.clear();
            }
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                KeyReference wk = entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static final class RefEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        RefEntry(@NotNull Map.Entry<?, V> ent, @Nullable K key) {
            if (ent == null) {
                RefEntry.$$$reportNull$$$0(0);
            }
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(@NotNull V value2) {
            if (value2 == null) {
                RefEntry.$$$reportNull$$$0(1);
            }
            return this.ent.setValue(value2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.key, e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentRefHashMap$RefEntry";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HardKey<K>
    implements KeyReference<K> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        void setKey(K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        private void clear() {
            this.setKey(null, 0);
        }
    }

    @FunctionalInterface
    static interface KeyReference<K> {
        public K get();

        public int hashCode();
    }
}

