/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerWithBuiltIns;
import org.jetbrains.kotlin.backend.common.serialization.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.IrSymbolTypeMismatchException;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.NoDeserializerForModule;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.SignatureIdNotFoundInModuleWithDependencies;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.SymbolTypeMismatch;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.UserVisibleIrModulesSupport;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.linkage.IrDeserializer;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingEnumEntrySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingPropertySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbolKt;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbolKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\rJ\u001e\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00180#H\u0014J\"\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00042\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020AH$J\b\u0010B\u001a\u00020CH\u0002J$\u0010D\u001a\u00020:2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010E\u001a\u00020?2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00170#J\u0016\u0010G\u001a\u00020:2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010E\u001a\u00020?J\u0016\u0010H\u001a\u00020:2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010E\u001a\u00020?J \u0010I\u001a\u00020:2\u0006\u0010=\u001a\u00020\u00042\b\u0010E\u001a\u0004\u0018\u00010?2\u0006\u0010J\u001a\u00020\u0017J.\u0010I\u001a\u00020:2\u0006\u0010=\u001a\u00020\u00042\b\u0010E\u001a\u0004\u0018\u00010?2\b\b\u0002\u0010K\u001a\u00020A2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\u0017J\u0018\u0010M\u001a\u00020:2\u0006\u0010=\u001a\u00020\u00042\b\u0010E\u001a\u0004\u0018\u00010?J\b\u0010N\u001a\u00020CH\u0002J\u0012\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\u0011H\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010Q\u001a\u00020\u0011H\u0016J\u0016\u0010T\u001a\u00020\u00112\u0006\u0010U\u001a\u00020\u00102\u0006\u0010V\u001a\u00020\u0011J\u0016\u0010W\u001a\u00020\u00182\u0006\u0010X\u001a\u00020\u00102\u0006\u0010Y\u001a\u00020\u0018J \u0010Z\u001a\u00020C2\b\u00109\u001a\u0004\u0018\u00010:2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0010\u0010\\\u001a\u00020]2\u0006\u0010=\u001a\u00020\u0004H$J\u0018\u0010^\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u0018H\u0014J\u0010\u0010_\u001a\u00020]2\u0006\u0010Q\u001a\u00020\u0011H\u0014J\b\u0010`\u001a\u00020CH\u0016J \u0010a\u001a\u00020\u00112\u0006\u0010b\u001a\u00020\u00102\u0006\u0010c\u001a\u00020d2\u0006\u0010J\u001a\u00020eH\u0016J\u0018\u0010f\u001a\u00020\u00182\u0006\u0010g\u001a\u00020\u00042\b\u0010X\u001a\u0004\u0018\u00010\u0010J\u0010\u0010h\u001a\u00020i2\u0006\u0010c\u001a\u00020dH\u0002J\u001a\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010l\u001a\u00020S2\u0006\u0010X\u001a\u00020\u0010H\u0016J\u001a\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010l\u001a\u00020S2\u0006\u0010X\u001a\u00020\u0010H\u0016J\u0012\u0010o\u001a\u0004\u0018\u00010S2\u0006\u0010Q\u001a\u00020\u0011H\u0002R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001d\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00180\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0013R\u0014\u0010/\u001a\u0004\u0018\u000100X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u000205X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006p"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "exportedDependencies", "", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;)V", "actualSymbols", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getActualSymbols$ir_serialization_common", "()Ljava/util/Map;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "deserializersForModules", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "getDeserializersForModules", "expectSymbols", "getExpectSymbols$ir_serialization_common", "expectUniqIdToActualUniqId", "getExpectUniqIdToActualUniqId", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "linkerExtensions", "", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$IrLinkerExtension;", "getMessageLogger", "()Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "modulesWithReachableTopLevels", "", "getModulesWithReachableTopLevels", "()Ljava/util/Set;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "topLevelActualUniqItToDeserializer", "getTopLevelActualUniqItToDeserializer", "translationPluginContext", "Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "getTranslationPluginContext", "()Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "triedToDeserializeDeclarationForSymbol", "userVisibleIrModulesSupport", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "getUserVisibleIrModulesSupport", "()Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "createCurrentModuleDeserializer", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "deserializeAllReachableTopLevels", "", "deserializeDirtyFiles", "kotlinLibrary", "dirtyFiles", "deserializeFullModule", "deserializeHeadersWithInlineBodies", "deserializeIrModuleHeader", "moduleName", "deserializationStrategy", "_moduleName", "deserializeOnlyHeaderModule", "finalizeExpectActualLinker", "findDeserializedDeclarationForSymbol", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "symbol", "getDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "handleExpectActualMapping", "idSig", "rawSymbol", "handleSignatureIdNotFoundInModuleWithDependencies", "idSignature", "moduleDeserializer", "init", "extensions", "isBuiltInModule", "", "maybeWrapWithBuiltInAndInit", "platformSpecificSymbol", "postProcess", "resolveBySignatureInModule", "signature", "kind", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$TopLevelSymbolKind;", "Lorg/jetbrains/kotlin/name/Name;", "resolveModuleDeserializer", "module", "topLevelKindToSymbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "tryReferencingPropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "parent", "tryReferencingSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "tryResolveCustomDeclaration", "ir.serialization.common"})
public abstract class KotlinIrLinker
implements FileLocalAwareLinker,
IrDeserializer {
    @Nullable
    private final ModuleDescriptor currentModule;
    @NotNull
    private final IrMessageLogger messageLogger;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<ModuleDescriptor> exportedDependencies;
    @NotNull
    private final Map<IdSignature, IdSignature> expectUniqIdToActualUniqId;
    @NotNull
    private final Map<IdSignature, IrModuleDeserializer> topLevelActualUniqItToDeserializer;
    @NotNull
    private final Map<IdSignature, IrSymbol> expectSymbols;
    @NotNull
    private final Map<IdSignature, IrSymbol> actualSymbols;
    @NotNull
    private final Set<IrModuleDeserializer> modulesWithReachableTopLevels;
    @NotNull
    private final Map<String, IrModuleDeserializer> deserializersForModules;
    @NotNull
    private final Set<IrSymbol> triedToDeserializeDeclarationForSymbol;
    private Collection<? extends IrDeserializer.IrLinkerExtension> linkerExtensions;
    @NotNull
    private final UserVisibleIrModulesSupport userVisibleIrModulesSupport;

    public KotlinIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull IrMessageLogger messageLogger, @NotNull IrBuiltIns builtIns, @NotNull SymbolTable symbolTable, @NotNull List<? extends ModuleDescriptor> exportedDependencies) {
        Intrinsics.checkNotNullParameter(messageLogger, "messageLogger");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(exportedDependencies, "exportedDependencies");
        this.currentModule = currentModule;
        this.messageLogger = messageLogger;
        this.builtIns = builtIns;
        this.symbolTable = symbolTable;
        this.exportedDependencies = exportedDependencies;
        this.expectUniqIdToActualUniqId = new LinkedHashMap();
        this.topLevelActualUniqItToDeserializer = new LinkedHashMap();
        this.expectSymbols = new LinkedHashMap();
        this.actualSymbols = new LinkedHashMap();
        this.modulesWithReachableTopLevels = new LinkedHashSet();
        this.deserializersForModules = new LinkedHashMap();
        this.triedToDeserializeDeclarationForSymbol = new LinkedHashSet();
        this.userVisibleIrModulesSupport = UserVisibleIrModulesSupport.Companion.getDEFAULT();
    }

    @NotNull
    public final IrMessageLogger getMessageLogger() {
        return this.messageLogger;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final Map<IdSignature, IdSignature> getExpectUniqIdToActualUniqId() {
        return this.expectUniqIdToActualUniqId;
    }

    @NotNull
    public final Map<IdSignature, IrModuleDeserializer> getTopLevelActualUniqItToDeserializer() {
        return this.topLevelActualUniqItToDeserializer;
    }

    @NotNull
    public final Map<IdSignature, IrSymbol> getExpectSymbols$ir_serialization_common() {
        return this.expectSymbols;
    }

    @NotNull
    public final Map<IdSignature, IrSymbol> getActualSymbols$ir_serialization_common() {
        return this.actualSymbols;
    }

    @NotNull
    public final Set<IrModuleDeserializer> getModulesWithReachableTopLevels() {
        return this.modulesWithReachableTopLevels;
    }

    @NotNull
    protected final Map<String, IrModuleDeserializer> getDeserializersForModules() {
        return this.deserializersForModules;
    }

    @NotNull
    public abstract FakeOverrideBuilder getFakeOverrideBuilder();

    @Nullable
    public abstract TranslationPluginContext getTranslationPluginContext();

    @NotNull
    protected UserVisibleIrModulesSupport getUserVisibleIrModulesSupport() {
        return this.userVisibleIrModulesSupport;
    }

    @NotNull
    public final IrModuleDeserializer handleSignatureIdNotFoundInModuleWithDependencies(@NotNull IdSignature idSignature, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        Intrinsics.checkNotNullParameter(moduleDeserializer, "moduleDeserializer");
        throw new SignatureIdNotFoundInModuleWithDependencies(idSignature, moduleDeserializer, this.deserializersForModules.values(), this.getUserVisibleIrModulesSupport()).raiseIssue(this.messageLogger);
    }

    @NotNull
    public final IrModuleDeserializer resolveModuleDeserializer(@NotNull ModuleDescriptor module2, @Nullable IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(module2, "module");
        IrModuleDeserializer irModuleDeserializer = this.deserializersForModules.get(module2.getName().asString());
        if (irModuleDeserializer == null) {
            Name name2 = module2.getName();
            Intrinsics.checkNotNullExpressionValue(name2, "module.name");
            throw new NoDeserializerForModule(name2, idSignature).raiseIssue(this.messageLogger);
        }
        return irModuleDeserializer;
    }

    @NotNull
    protected abstract IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor var1, @Nullable KotlinLibrary var2, @NotNull DeserializationStrategy var3);

    protected abstract boolean isBuiltInModule(@NotNull ModuleDescriptor var1);

    private final void deserializeAllReachableTopLevels() {
        while (!((Collection)this.modulesWithReachableTopLevels).isEmpty()) {
            IrModuleDeserializer moduleDeserializer = (IrModuleDeserializer)CollectionsKt.first((Iterable)this.modulesWithReachableTopLevels);
            this.modulesWithReachableTopLevels.remove(moduleDeserializer);
            moduleDeserializer.deserializeReachableDeclarations();
        }
    }

    private final DeclarationDescriptor findDeserializedDeclarationForSymbol(IrSymbol symbol2) {
        if (this.triedToDeserializeDeclarationForSymbol.contains(symbol2)) {
            return null;
        }
        this.triedToDeserializeDeclarationForSymbol.add(symbol2);
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        IrModuleDeserializer moduleDeserializer = this.resolveModuleDeserializer(DescriptorUtilsKt.getModule(descriptor2), symbol2.getSignature());
        moduleDeserializer.declareIrSymbol(symbol2);
        this.deserializeAllReachableTopLevels();
        if (!symbol2.isBound()) {
            return null;
        }
        return descriptor2;
    }

    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return false;
    }

    private final IrDeclaration tryResolveCustomDeclaration(IrSymbol symbol2) {
        Iterable<IrDeserializer.IrLinkerExtension> iterable;
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        if (descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return null;
        }
        TranslationPluginContext translationPluginContext = this.getTranslationPluginContext();
        if (translationPluginContext == null) {
            iterable = null;
        } else {
            IrDeclaration irDeclaration2;
            Object object;
            Iterable<IrDeserializer.IrLinkerExtension> iterable2;
            block10: {
                IrDeclaration irDeclaration3;
                Collection<? extends IrDeserializer.IrLinkerExtension> collection;
                TranslationPluginContext translationPluginContext2;
                TranslationPluginContext ctx2 = translationPluginContext2 = translationPluginContext;
                boolean bl = false;
                iterable2 = this.linkerExtensions;
                if (iterable2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("linkerExtensions");
                    collection = null;
                } else {
                    collection = iterable2;
                }
                iterable2 = collection;
                Iterator<IrDeserializer.IrLinkerExtension> iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    IrDeserializer.IrLinkerExtension irLinkerExtension;
                    IrDeserializer.IrLinkerExtension it = irLinkerExtension = iterator2.next();
                    boolean bl2 = false;
                    object = it.resolveSymbol(symbol2, ctx2);
                    if (object == null) continue;
                    irDeclaration3 = object;
                    break block10;
                }
                irDeclaration3 = irDeclaration2 = null;
            }
            if (irDeclaration2 == null) {
                iterable = null;
            } else {
                Iterable<IrDeserializer.IrLinkerExtension> it = iterable2 = irDeclaration2;
                boolean bl = false;
                if (!Intrinsics.areEqual(symbol2.getOwner(), it)) {
                    object = "Failed requirement.";
                    throw new IllegalArgumentException(object.toString());
                }
                iterable = iterable2;
            }
        }
        return iterable;
    }

    @Override
    @Nullable
    public IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor descriptor2;
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        if (!IrSymbolKt.isPublicApi(symbol2) && symbol2.getHasDescriptor()) {
            descriptor2 = symbol2.getDescriptor();
            if (!this.platformSpecificSymbol(symbol2) && DescriptorUtilsKt.getModule(descriptor2) != this.currentModule) {
                return null;
            }
        }
        if (!symbol2.isBound()) {
            try {
                IrDeclaration irDeclaration2;
                descriptor2 = this.findDeserializedDeclarationForSymbol(symbol2);
                if (descriptor2 == null && (irDeclaration2 = this.tryResolveCustomDeclaration(symbol2)) == null) {
                    return null;
                }
            }
            catch (IrSymbolTypeMismatchException e) {
                throw new SymbolTypeMismatch(e, this.deserializersForModules.values(), this.getUserVisibleIrModulesSupport()).raiseIssue(this.messageLogger);
            }
        }
        if (!symbol2.isBound() && (LegacyDescriptorUtilsKt.isExpectMember(symbol2.getDescriptor()) || ((declarationDescriptor = symbol2.getDescriptor().getContainingDeclaration()) == null ? false : LegacyDescriptorUtilsKt.isExpectMember(declarationDescriptor)))) {
            return null;
        }
        if (!symbol2.isBound()) {
            return null;
        }
        return (IrDeclaration)symbol2.getOwner();
    }

    @Override
    @Nullable
    public IrSimpleFunctionSymbol tryReferencingSimpleFunctionByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        if (idSignature.isPubliclyVisible()) {
            return null;
        }
        IrFile file2 = IrUtilsKt.getFile(parent2);
        ModuleDescriptor moduleDescriptor = file2.getPackageFragmentDescriptor().getContainingDeclaration();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referenceSimpleFunctionByLocalSignature(file2, idSignature);
    }

    @Override
    @Nullable
    public IrPropertySymbol tryReferencingPropertyByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        if (idSignature.isPubliclyVisible()) {
            return null;
        }
        IrFile file2 = IrUtilsKt.getFile(parent2);
        ModuleDescriptor moduleDescriptor = file2.getPackageFragmentDescriptor().getContainingDeclaration();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referencePropertyByLocalSignature(file2, idSignature);
    }

    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter(moduleFragment, "moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        return new CurrentModuleDeserializer(moduleFragment, dependencies2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@Nullable IrModuleFragment moduleFragment, @NotNull Collection<? extends IrDeserializer.IrLinkerExtension> extensions) {
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.linkerExtensions = extensions;
        if (moduleFragment != null) {
            String $this$mapTo$iv$iv;
            Iterable $this$map$iv = moduleFragment.getDescriptor().getAllDependencyModules();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrModuleDeserializer irModuleDeserializer = this.resolveModuleDeserializer((ModuleDescriptor)it, null);
                collection.add(irModuleDeserializer);
            }
            List currentModuleDependencies = (List)destination$iv$iv;
            IrModuleDeserializer currentModuleDeserializer = this.createCurrentModuleDeserializer(moduleFragment, currentModuleDependencies);
            $this$mapTo$iv$iv = moduleFragment.getName().asString();
            Intrinsics.checkNotNullExpressionValue($this$mapTo$iv$iv, "moduleFragment.name.asString()");
            this.deserializersForModules.put($this$mapTo$iv$iv, this.maybeWrapWithBuiltInAndInit(moduleFragment.getDescriptor(), currentModuleDeserializer));
        }
        Iterable $this$forEach$iv = this.deserializersForModules.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
            boolean bl = false;
            it.init();
        }
    }

    @Override
    public void postProcess() {
        this.finalizeExpectActualLinker();
        this.getFakeOverrideBuilder().provideFakeOverrides();
        this.triedToDeserializeDeclarationForSymbol.clear();
    }

    @NotNull
    public final IrSymbol handleExpectActualMapping(@NotNull IdSignature idSig, @NotNull IrSymbol rawSymbol) {
        Object object;
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Intrinsics.checkNotNullParameter(rawSymbol, "rawSymbol");
        if (this.expectUniqIdToActualUniqId.values().contains(idSig)) {
            object = this.actualSymbols;
            object.put((IdSignature)idSig, (IrSymbol)rawSymbol);
        }
        if ((object = this.expectUniqIdToActualUniqId.get(idSig)) != null) {
            Object object2;
            IdSignature idSignature;
            Object object3;
            Object actualSig = object3 = object;
            boolean bl = false;
            IdSignature $this$handleExpectActualMapping_u24lambda_u2d7_u24lambda_u2d5 = idSignature = idSig;
            boolean bl2 = false;
            boolean bl3 = $this$handleExpectActualMapping_u24lambda_u2d7_u24lambda_u2d5.test(IdSignature.Flags.IS_EXPECT);
            if (_Assertions.ENABLED && !bl3) {
                object2 = "Assertion failed";
                throw new AssertionError(object2);
            }
            IrDelegatingSymbol<? extends IrBindableSymbol<?, ? extends IrDeclaration>, ? extends IrDeclaration, ?> referencingSymbol = IrDelegatingSymbolKt.wrapInDelegatedSymbol(rawSymbol);
            object2 = this.getExpectSymbols$ir_serialization_common();
            object2.put(idSig, referencingSymbol);
            object2 = this.getTopLevelActualUniqItToDeserializer().get(actualSig);
            if (object2 != null) {
                Object object4;
                Object moduleDeserializer = object4 = object2;
                boolean bl4 = false;
                IrSymbol actualSymbol = this.getActualSymbols$ir_serialization_common().get(actualSig);
                if (actualSymbol == null || !actualSymbol.isBound()) {
                    ((IrModuleDeserializer)moduleDeserializer).addModuleReachableTopLevel((IdSignature)actualSig);
                }
            }
            return referencingSymbol;
        }
        return rawSymbol;
    }

    private final BinarySymbolData.SymbolKind topLevelKindToSymbolKind(IrDeserializer.TopLevelSymbolKind kind) {
        BinarySymbolData.SymbolKind symbolKind;
        IrDeserializer.TopLevelSymbolKind topLevelSymbolKind = kind;
        int n = WhenMappings.$EnumSwitchMapping$0[topLevelSymbolKind.ordinal()];
        switch (n) {
            case 1: {
                symbolKind = BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                break;
            }
            case 2: {
                symbolKind = BinarySymbolData.SymbolKind.PROPERTY_SYMBOL;
                break;
            }
            case 3: {
                symbolKind = BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                break;
            }
            case 4: {
                symbolKind = BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return symbolKind;
    }

    @Override
    @NotNull
    public IrSymbol resolveBySignatureInModule(@NotNull IdSignature signature2, @NotNull IrDeserializer.TopLevelSymbolKind kind, @NotNull Name moduleName) {
        IrSymbol irSymbol2;
        Object v0;
        block4: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter(signature2, "signature");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            Iterable iterable2 = iterable = (Iterable)this.deserializersForModules.entrySet();
            for (Object t : iterable2) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), moduleName.asString())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            throw new IllegalStateException(("No module for name '" + moduleName + "' found").toString());
        }
        IrModuleDeserializer moduleDeserializer = (IrModuleDeserializer)entry.getValue();
        boolean bl = Intrinsics.areEqual(signature2, signature2.topLevelSignature());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22 = false;
            String $i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22 = "Signature '" + signature2 + "' has to be top level";
            throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22);
        }
        if (!moduleDeserializer.contains(signature2)) {
            throw new IllegalStateException(("No signature " + signature2 + " in module " + moduleName).toString());
        }
        IrSymbol it = irSymbol2 = moduleDeserializer.deserializeIrSymbol(signature2, this.topLevelKindToSymbolKind(kind));
        boolean bl2 = false;
        this.deserializeAllReachableTopLevels();
        return irSymbol2;
    }

    private final void finalizeExpectActualLinker() {
        Map<IdSignature, IdSignature> $this$forEach$iv = this.expectUniqIdToActualUniqId;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IdSignature, IdSignature>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IdSignature, IdSignature> element$iv;
            Map.Entry<IdSignature, IdSignature> it = element$iv = iterator2.next();
            boolean bl = false;
            IrSymbol expectSymbol = this.getExpectSymbols$ir_serialization_common().get(it.getKey());
            IrSymbol actualSymbol = this.getActualSymbols$ir_serialization_common().get(it.getValue());
            if (expectSymbol == null || actualSymbol == null) continue;
            IrSymbol irSymbol2 = expectSymbol;
            if (irSymbol2 instanceof IrDelegatingClassSymbolImpl) {
                ((IrDelegatingClassSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrClassSymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingEnumEntrySymbolImpl) {
                ((IrDelegatingEnumEntrySymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrEnumEntrySymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingSimpleFunctionSymbolImpl) {
                ((IrDelegatingSimpleFunctionSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrSimpleFunctionSymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingConstructorSymbolImpl) {
                ((IrDelegatingConstructorSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrConstructorSymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingPropertySymbolImpl) {
                ((IrDelegatingPropertySymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrPropertySymbol)actualSymbol));
                continue;
            }
            throw new IllegalStateException(Intrinsics.stringPlus("Unexpected expect symbol kind during actualization: ", expectSymbol).toString());
        }
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull DeserializationStrategy deserializationStrategy, @Nullable String _moduleName) {
        IrModuleDeserializer irModuleDeserializer;
        String string2;
        boolean bl;
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)deserializationStrategy, "deserializationStrategy");
        boolean bl2 = bl = kotlinLibrary != null || _moduleName != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422 = false;
            String $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422 = Intrinsics.stringPlus("Either library or explicit name have to be provided ", moduleDescriptor);
            throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422);
        }
        KotlinLibrary $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422 = kotlinLibrary;
        if ($i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422 == null) {
            String string3 = _moduleName;
            string2 = string3;
            Intrinsics.checkNotNull(string3);
        } else {
            String string4;
            String string5;
            String it = string5 = (string4 = KotlinLibraryKt.getUniqueName($i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422));
            boolean bl3 = false;
            string2 = '<' + it + '>';
        }
        String moduleName = string2;
        boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422 = Intrinsics.areEqual(moduleDescriptor.getName().asString(), moduleName);
        if (_Assertions.ENABLED && !$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$422) {
            boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$32 = false;
            String $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$32 = moduleDescriptor.getName().asString() + " != " + moduleName;
            throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$32);
        }
        Map<String, IrModuleDeserializer> $this$getOrPut$iv = this.deserializersForModules;
        boolean $i$f$getOrPut = false;
        IrModuleDeserializer value$iv = $this$getOrPut$iv.get(moduleName);
        if (value$iv == null) {
            boolean bl4 = false;
            IrModuleDeserializer answer$iv = this.maybeWrapWithBuiltInAndInit(moduleDescriptor, this.createModuleDeserializer(moduleDescriptor, kotlinLibrary, deserializationStrategy));
            $this$getOrPut$iv.put(moduleName, answer$iv);
            irModuleDeserializer = answer$iv;
        } else {
            irModuleDeserializer = value$iv;
        }
        IrModuleDeserializer deserializerForModule = irModuleDeserializer;
        return deserializerForModule.getModuleFragment();
    }

    public static /* synthetic */ IrModuleFragment deserializeIrModuleHeader$default(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, KotlinLibrary kotlinLibrary, DeserializationStrategy deserializationStrategy, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deserializeIrModuleHeader");
        }
        if ((n & 4) != 0) {
            deserializationStrategy = DeserializationStrategy.ONLY_REFERENCED;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return kotlinIrLinker.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, deserializationStrategy, string2);
    }

    @NotNull
    protected IrModuleDeserializer maybeWrapWithBuiltInAndInit(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(moduleDeserializer, "moduleDeserializer");
        return this.isBuiltInModule(moduleDescriptor) ? (IrModuleDeserializer)new IrModuleDeserializerWithBuiltIns(this.builtIns, moduleDeserializer) : moduleDeserializer;
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        DeserializationStrategy deserializationStrategy = this.exportedDependencies.contains(moduleDescriptor) ? DeserializationStrategy.ALL : DeserializationStrategy.EXPLICITLY_EXPORTED;
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, deserializationStrategy, moduleName);
    }

    @NotNull
    public final IrModuleFragment deserializeFullModule(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(kotlinLibrary, "kotlinLibrary");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, DeserializationStrategy.ALL, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeOnlyHeaderModule(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, DeserializationStrategy.ONLY_DECLARATION_HEADERS, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeHeadersWithInlineBodies(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(kotlinLibrary, "kotlinLibrary");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, DeserializationStrategy.WITH_INLINE_BODIES, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeDirtyFiles(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary, @NotNull Collection<String> dirtyFiles) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(kotlinLibrary, "kotlinLibrary");
        Intrinsics.checkNotNullParameter(dirtyFiles, "dirtyFiles");
        return this.deserializeFullModule(moduleDescriptor, kotlinLibrary);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrDeserializer.TopLevelSymbolKind.values().length];
            nArray[IrDeserializer.TopLevelSymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            nArray[IrDeserializer.TopLevelSymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
            nArray[IrDeserializer.TopLevelSymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
            nArray[IrDeserializer.TopLevelSymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

