/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.sisu.space.FileEntryIterator;
import org.eclipse.sisu.space.Streams;

final class ZipEntryIterator
implements Iterator<String> {
    private String[] entryNames;
    private int index;

    ZipEntryIterator(URL url) {
        try {
            this.entryNames = "file".equals(url.getProtocol()) ? ZipEntryIterator.getEntryNames(new ZipFile(FileEntryIterator.toFile(url))) : ZipEntryIterator.getEntryNames(new ZipInputStream(Streams.open(url)));
        }
        catch (IOException iOException) {
            this.entryNames = new String[0];
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.entryNames.length;
    }

    @Override
    public String next() {
        return this.entryNames[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static String[] getEntryNames(ZipFile zipFile2) throws IOException {
        try {
            String[] names2 = new String[zipFile2.size()];
            Enumeration<? extends ZipEntry> e = zipFile2.entries();
            int i = 0;
            while (i < names2.length) {
                names2[i] = e.nextElement().getName();
                ++i;
            }
            String[] stringArray = names2;
            return stringArray;
        }
        finally {
            zipFile2.close();
        }
    }

    private static String[] getEntryNames(ZipInputStream zipStream) throws IOException {
        try {
            ArrayList<String> names2 = new ArrayList<String>(64);
            ZipEntry e = zipStream.getNextEntry();
            while (e != null) {
                names2.add(e.getName());
                e = zipStream.getNextEntry();
            }
            String[] stringArray = names2.toArray(new String[names2.size()]);
            return stringArray;
        }
        finally {
            zipStream.close();
        }
    }
}

