/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.plexus.ClassRealmManager;
import org.eclipse.sisu.plexus.ComponentImpl;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBeanSource;
import org.eclipse.sisu.plexus.PlexusTypeBinder;
import org.eclipse.sisu.plexus.RequirementImpl;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.LoadedClass;

public final class ComponentDescriptorBeanModule
implements PlexusBeanModule {
    private final ClassSpace space;
    private final Map<Component, DeferredClass<?>> componentMap = new HashMap();
    private final Map<String, PlexusBeanMetadata> metadataMap = new HashMap<String, PlexusBeanMetadata>();

    public ComponentDescriptorBeanModule(ClassSpace space, List<ComponentDescriptor<?>> descriptors) {
        this.space = space;
        int i = 0;
        int size = descriptors.size();
        while (i < size) {
            ComponentDescriptor<?> cd = descriptors.get(i);
            Component component = ComponentDescriptorBeanModule.newComponent(cd);
            String factory2 = cd.getComponentFactory();
            if (factory2 == null || "java".equals(factory2)) {
                try {
                    this.componentMap.put(component, new LoadedClass(cd.getImplementationClass()));
                }
                catch (TypeNotPresentException typeNotPresentException) {
                    this.componentMap.put(component, space.deferLoadClass(cd.getImplementation()));
                }
            } else {
                this.componentMap.put(component, new DeferredFactoryClass(cd, factory2));
            }
            List<ComponentRequirement> requirements = cd.getRequirements();
            if (!requirements.isEmpty()) {
                this.metadataMap.put(cd.getImplementation(), new ComponentMetadata(space, requirements));
            }
            ++i;
        }
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        String source = this.space.toString();
        PlexusTypeBinder plexusTypeBinder = new PlexusTypeBinder(binder);
        for (Map.Entry<Component, DeferredClass<?>> entry : this.componentMap.entrySet()) {
            plexusTypeBinder.hear(entry.getKey(), entry.getValue(), source);
        }
        return new PlexusDescriptorBeanSource(this.metadataMap);
    }

    static Component newComponent(ComponentDescriptor<?> cd) {
        return new ComponentImpl(cd.getRoleClass(), cd.getRoleHint(), cd.getInstantiationStrategy(), cd.getDescription());
    }

    static Requirement newRequirement(ClassSpace space, ComponentRequirement cr) {
        return new RequirementImpl(space.deferLoadClass(cr.getRole()), cr.isOptional(), Collections.singletonList(cr.getRoleHint()));
    }

    private static final class ComponentMetadata
    implements PlexusBeanMetadata {
        private Map<String, Requirement> requirementMap = new HashMap<String, Requirement>();

        ComponentMetadata(ClassSpace space, List<ComponentRequirement> requirements) {
            int i = 0;
            int size = requirements.size();
            while (i < size) {
                ComponentRequirement cr = requirements.get(i);
                this.requirementMap.put(cr.getFieldName(), ComponentDescriptorBeanModule.newRequirement(space, cr));
                ++i;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.requirementMap.isEmpty();
        }

        @Override
        public Requirement getRequirement(BeanProperty<?> property2) {
            Requirement requirement2 = this.requirementMap.get(property2.getName());
            if (requirement2 != null && this.requirementMap.isEmpty()) {
                this.requirementMap = Collections.emptyMap();
            }
            return requirement2;
        }

        @Override
        public Configuration getConfiguration(BeanProperty<?> property2) {
            return null;
        }
    }

    private static final class DeferredFactoryClass
    implements DeferredClass<Object>,
    DeferredProvider<Object> {
        @Inject
        private PlexusContainer container;
        @Inject
        private Injector injector;
        private final ComponentDescriptor<?> cd;
        private final String hint;

        DeferredFactoryClass(ComponentDescriptor<?> cd, String hint) {
            this.cd = cd;
            this.hint = hint;
        }

        @Override
        public Class load() throws TypeNotPresentException {
            return this.cd.getImplementationClass();
        }

        @Override
        public String getName() {
            return this.cd.getImplementation();
        }

        @Override
        public DeferredProvider<Object> asProvider() {
            return this;
        }

        @Override
        public Object get() {
            try {
                ComponentFactory factory2;
                Object o;
                ClassRealm contextRealm = this.container.getLookupRealm();
                if (contextRealm == null) {
                    contextRealm = ClassRealmManager.contextRealm();
                }
                if (contextRealm == null) {
                    contextRealm = this.container.getContainerRealm();
                }
                if ((o = (factory2 = this.container.lookup(ComponentFactory.class, this.hint)).newInstance(this.cd, contextRealm, this.container)) != null) {
                    this.injector.injectMembers(o);
                }
                return o;
            }
            catch (Exception e) {
                throw new ProvisionException("Error in ComponentFactory:" + this.hint, e);
            }
        }

        @Override
        public DeferredClass<Object> getImplementationClass() {
            return this;
        }
    }

    private static final class PlexusDescriptorBeanSource
    implements PlexusBeanSource {
        private Map<String, PlexusBeanMetadata> metadataMap;

        PlexusDescriptorBeanSource(Map<String, PlexusBeanMetadata> metadataMap) {
            this.metadataMap = metadataMap;
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation2) {
            if (this.metadataMap == null) {
                return null;
            }
            PlexusBeanMetadata metadata2 = this.metadataMap.remove(implementation2.getName());
            if (this.metadataMap.isEmpty()) {
                this.metadataMap = null;
            }
            return metadata2;
        }
    }
}

