/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import java.util.Collections;
import java.util.Map;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.launch.SisuTracker;
import org.eclipse.sisu.osgi.ServiceBindings;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SisuExtender
implements BundleActivator {
    private static final Map<Long, MutableBeanLocator> locators = Collections.synchronizedMap(Weak.values());
    protected SisuTracker tracker;

    public void start(BundleContext context2) {
        this.tracker = this.createTracker(context2);
        this.tracker.open();
    }

    public void stop(BundleContext context2) {
        this.tracker.close();
        this.tracker = null;
    }

    protected int bundleStateMask() {
        return 40;
    }

    protected SisuTracker createTracker(BundleContext context2) {
        return new SisuTracker(context2, this.bundleStateMask(), this.findLocator(context2));
    }

    protected MutableBeanLocator createLocator(BundleContext context2) {
        DefaultBeanLocator locator = new DefaultBeanLocator();
        locator.add(new ServiceBindings(context2));
        return locator;
    }

    protected final MutableBeanLocator findLocator(BundleContext context2) {
        Long extenderId = context2.getBundle().getBundleId();
        MutableBeanLocator locator = locators.get(extenderId);
        if (locator == null) {
            locator = this.createLocator(context2);
            locators.put(extenderId, locator);
        }
        return locator;
    }
}

