/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.sisu.bean.BeanBinder;
import org.eclipse.sisu.bean.BeanInjector;
import org.eclipse.sisu.bean.BeanProperties;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.bean.PropertyBinding;

public final class BeanListener
implements TypeListener {
    private final BeanBinder beanBinder;

    public BeanListener(BeanBinder beanBinder) {
        this.beanBinder = beanBinder;
    }

    public <B> void hear(TypeLiteral<B> type2, TypeEncounter<B> encounter) {
        PropertyBinder propertyBinder = this.beanBinder.bindBean(type2, encounter);
        if (propertyBinder == null) {
            return;
        }
        ArrayList<PropertyBinding> bindings = new ArrayList<PropertyBinding>();
        HashSet<String> visited2 = new HashSet<String>();
        for (BeanProperty<Object> property2 : new BeanProperties(type2.getRawType())) {
            String name2;
            if (property2.getAnnotation(javax.inject.Inject.class) != null || property2.getAnnotation(Inject.class) != null || !visited2.add(name2 = property2.getName())) continue;
            try {
                PropertyBinding binding = propertyBinder.bindProperty(property2);
                if (binding == PropertyBinder.LAST_BINDING) break;
                if (binding != null) {
                    bindings.add(binding);
                    continue;
                }
                visited2.remove(name2);
            }
            catch (RuntimeException e) {
                encounter.addError(new ProvisionException("Error binding: " + property2, e));
            }
        }
        if (bindings.size() > 0) {
            encounter.register(new BeanInjector(bindings));
        }
    }
}

