/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.version;

import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.version.SnapshotVersionFilter;

public final class ContextualSnapshotVersionFilter
implements VersionFilter {
    public static final String CONFIG_PROP_ENABLE = "aether.snapshotFilter";
    private final SnapshotVersionFilter filter = new SnapshotVersionFilter();

    private boolean isEnabled(RepositorySystemSession session2) {
        return ConfigUtils.getBoolean(session2, false, CONFIG_PROP_ENABLE);
    }

    @Override
    public void filterVersions(VersionFilter.VersionFilterContext context2) {
        if (this.isEnabled(context2.getSession())) {
            this.filter.filterVersions(context2);
        }
    }

    @Override
    public VersionFilter deriveChildFilter(DependencyCollectionContext context2) {
        if (!this.isEnabled(context2.getSession())) {
            Artifact artifact = context2.getArtifact();
            if (artifact == null) {
                return this;
            }
            if (artifact.isSnapshot()) {
                return null;
            }
        }
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

