/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.ConfigUtils;

@Named(value="maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    static final String CONFIG_PROP_SIGNATURE_CHECKSUMS = "aether.checksums.forSignature";
    static final String CONFIG_PROP_CHECKSUMS_ALGORITHMS = "aether.checksums.algorithms";
    static final String DEFAULT_CHECKSUMS_ALGORITHMS = "SHA-1,MD5";
    private float priority;

    @Override
    public float getPriority() {
        return this.priority;
    }

    public Maven2RepositoryLayoutFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public RepositoryLayout newInstance(RepositorySystemSession session2, RemoteRepository repository) throws NoRepositoryLayoutException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        boolean forSignature = ConfigUtils.getBoolean(session2, false, CONFIG_PROP_SIGNATURE_CHECKSUMS);
        List<String> checksumsAlgorithms = Arrays.asList(ConfigUtils.getString(session2, DEFAULT_CHECKSUMS_ALGORITHMS, CONFIG_PROP_CHECKSUMS_ALGORITHMS).split(","));
        return forSignature ? new Maven2RepositoryLayout(checksumsAlgorithms) : new Maven2RepositoryLayoutEx(checksumsAlgorithms);
    }

    private static class Maven2RepositoryLayoutEx
    extends Maven2RepositoryLayout {
        protected Maven2RepositoryLayoutEx(List<String> checksumsAlgorithms) {
            super(checksumsAlgorithms);
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location2) {
            if (this.isSignature(artifact.getExtension())) {
                return Collections.emptyList();
            }
            return super.getChecksums(artifact, upload, location2);
        }

        private boolean isSignature(String extension) {
            return extension.endsWith(".asc");
        }
    }

    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        private final List<String> checksumsAlgorithms;

        protected Maven2RepositoryLayout(List<String> checksumsAlgorithms) {
            this.checksumsAlgorithms = checksumsAlgorithms;
        }

        private URI toUri(String path2) {
            try {
                return new URI(null, null, path2, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path2 = new StringBuilder(128);
            path2.append(artifact.getGroupId().replace('.', '/')).append('/');
            path2.append(artifact.getArtifactId()).append('/');
            path2.append(artifact.getBaseVersion()).append('/');
            path2.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (artifact.getClassifier().length() > 0) {
                path2.append('-').append(artifact.getClassifier());
            }
            if (artifact.getExtension().length() > 0) {
                path2.append('.').append(artifact.getExtension());
            }
            return this.toUri(path2.toString());
        }

        @Override
        public URI getLocation(Metadata metadata2, boolean upload) {
            StringBuilder path2 = new StringBuilder(128);
            if (metadata2.getGroupId().length() > 0) {
                path2.append(metadata2.getGroupId().replace('.', '/')).append('/');
                if (metadata2.getArtifactId().length() > 0) {
                    path2.append(metadata2.getArtifactId()).append('/');
                    if (metadata2.getVersion().length() > 0) {
                        path2.append(metadata2.getVersion()).append('/');
                    }
                }
            }
            path2.append(metadata2.getType());
            return this.toUri(path2.toString());
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location2) {
            return this.getChecksums(location2);
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Metadata metadata2, boolean upload, URI location2) {
            return this.getChecksums(location2);
        }

        private List<RepositoryLayout.Checksum> getChecksums(URI location2) {
            ArrayList<RepositoryLayout.Checksum> checksums = new ArrayList<RepositoryLayout.Checksum>(this.checksumsAlgorithms.size());
            for (String algorithm : this.checksumsAlgorithms) {
                checksums.add(RepositoryLayout.Checksum.forLocation(location2, algorithm));
            }
            return checksums;
        }
    }
}

