/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultFileProcessor;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultOfflineController;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.slf4j.Slf4jLoggerFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.LoggerFactory;

public final class DefaultServiceLocator
implements ServiceLocator {
    private final Map<Class<?>, Entry<?>> entries = new HashMap();
    private ErrorHandler errorHandler;

    public DefaultServiceLocator() {
        this.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        this.addService(ArtifactResolver.class, DefaultArtifactResolver.class);
        this.addService(DependencyCollector.class, DefaultDependencyCollector.class);
        this.addService(Deployer.class, DefaultDeployer.class);
        this.addService(Installer.class, DefaultInstaller.class);
        this.addService(MetadataResolver.class, DefaultMetadataResolver.class);
        this.addService(RepositoryLayoutProvider.class, DefaultRepositoryLayoutProvider.class);
        this.addService(RepositoryLayoutFactory.class, Maven2RepositoryLayoutFactory.class);
        this.addService(TransporterProvider.class, DefaultTransporterProvider.class);
        this.addService(ChecksumPolicyProvider.class, DefaultChecksumPolicyProvider.class);
        this.addService(RepositoryConnectorProvider.class, DefaultRepositoryConnectorProvider.class);
        this.addService(RemoteRepositoryManager.class, DefaultRemoteRepositoryManager.class);
        this.addService(UpdateCheckManager.class, DefaultUpdateCheckManager.class);
        this.addService(UpdatePolicyAnalyzer.class, DefaultUpdatePolicyAnalyzer.class);
        this.addService(FileProcessor.class, DefaultFileProcessor.class);
        this.addService(SyncContextFactory.class, DefaultSyncContextFactory.class);
        this.addService(RepositoryEventDispatcher.class, DefaultRepositoryEventDispatcher.class);
        this.addService(OfflineController.class, DefaultOfflineController.class);
        this.addService(LocalRepositoryProvider.class, DefaultLocalRepositoryProvider.class);
        this.addService(LocalRepositoryManagerFactory.class, SimpleLocalRepositoryManagerFactory.class);
        this.addService(LocalRepositoryManagerFactory.class, EnhancedLocalRepositoryManagerFactory.class);
        this.addService(LoggerFactory.class, Slf4jLoggerFactory.class);
    }

    private <T> Entry<T> getEntry(Class<T> type2, boolean create2) {
        Entry<Object> entry = this.entries.get(Objects.requireNonNull(type2, "service type cannot be null"));
        if (entry == null && create2) {
            entry = new Entry<T>(type2);
            this.entries.put(type2, entry);
        }
        return entry;
    }

    public <T> DefaultServiceLocator setService(Class<T> type2, Class<? extends T> impl) {
        this.getEntry(type2, true).setService(impl);
        return this;
    }

    public <T> DefaultServiceLocator addService(Class<T> type2, Class<? extends T> impl) {
        this.getEntry(type2, true).addService(impl);
        return this;
    }

    public <T> DefaultServiceLocator setServices(Class<T> type2, T ... services) {
        this.getEntry(type2, true).setServices(services);
        return this;
    }

    @Override
    public <T> T getService(Class<T> type2) {
        Entry<T> entry = this.getEntry(type2, false);
        return entry != null ? (T)entry.getInstance() : null;
    }

    @Override
    public <T> List<T> getServices(Class<T> type2) {
        Entry<T> entry = this.getEntry(type2, false);
        return entry != null ? entry.getInstances() : null;
    }

    private void serviceCreationFailed(Class<?> type2, Class<?> impl, Throwable exception) {
        if (this.errorHandler != null) {
            this.errorHandler.serviceCreationFailed(type2, impl, exception);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public static abstract class ErrorHandler {
        public void serviceCreationFailed(Class<?> type2, Class<?> impl, Throwable exception) {
        }
    }

    private class Entry<T> {
        private final Class<T> type;
        private final Collection<Object> providers;
        private List<T> instances;

        Entry(Class<T> type2) {
            this.type = Objects.requireNonNull(type2, "service type cannot be null");
            this.providers = new LinkedHashSet<Object>(8);
        }

        public synchronized void setServices(T ... services) {
            this.providers.clear();
            if (services != null) {
                for (T service : services) {
                    this.providers.add(Objects.requireNonNull(service, "service instance cannot be null"));
                }
            }
            this.instances = null;
        }

        public synchronized void setService(Class<? extends T> impl) {
            this.providers.clear();
            this.addService(impl);
        }

        public synchronized void addService(Class<? extends T> impl) {
            this.providers.add(Objects.requireNonNull(impl, "implementation class cannot be null"));
            this.instances = null;
        }

        public T getInstance() {
            List<T> instances = this.getInstances();
            return instances.isEmpty() ? null : (T)instances.get(0);
        }

        public synchronized List<T> getInstances() {
            if (this.instances == null) {
                this.instances = new ArrayList<T>(this.providers.size());
                for (Object provider2 : this.providers) {
                    T instance = provider2 instanceof Class ? this.newInstance((Class)provider2) : this.type.cast(provider2);
                    if (instance == null) continue;
                    this.instances.add(instance);
                }
                this.instances = Collections.unmodifiableList(this.instances);
            }
            return this.instances;
        }

        private T newInstance(Class<?> impl) {
            try {
                Object obj;
                T instance;
                Constructor<?> constr = impl.getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPublic(constr.getModifiers())) {
                    constr.setAccessible(true);
                }
                if ((instance = this.type.cast(obj = constr.newInstance(new Object[0]))) instanceof Service) {
                    ((Service)instance).initService(DefaultServiceLocator.this);
                }
                return instance;
            }
            catch (Exception | LinkageError e) {
                DefaultServiceLocator.this.serviceCreationFailed(this.type, impl, e);
                return null;
            }
        }
    }
}

