/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.LifecycleManager;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.plexus.ClassRealmManager;
import org.eclipse.sisu.plexus.ComponentDescriptorBeanModule;
import org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import org.eclipse.sisu.plexus.PlexusBean;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBindingModule;
import org.eclipse.sisu.plexus.PlexusDateTypeConverter;
import org.eclipse.sisu.plexus.PlexusLifecycleManager;
import org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.LoadedClass;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.EntryListAdapter;
import org.eclipse.sisu.wire.EntryMapAdapter;
import org.eclipse.sisu.wire.MergedModule;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.slf4j.ILoggerFactory;

public final class DefaultPlexusContainer
implements MutablePlexusContainer {
    private static final String DEFAULT_REALM_NAME = "plexus.core";
    private static final Module[] NO_CUSTOM_MODULES;
    final AtomicInteger plexusRank = new AtomicInteger();
    final Map<ClassRealm, List<ComponentDescriptor<?>>> descriptorMap = new IdentityHashMap();
    final ThreadLocal<ClassRealm> lookupRealm = new ThreadLocal();
    final LoggerManagerProvider loggerManagerProvider = new LoggerManagerProvider();
    final MutableBeanLocator qualifiedBeanLocator = new DefaultBeanLocator();
    final Context context;
    final Map<?, ?> variables;
    final ClassRealm containerRealm;
    final ClassRealmManager classRealmManager;
    final PlexusBeanLocator plexusBeanLocator;
    final BeanManager plexusBeanManager;
    private final String componentVisibility;
    private final boolean isAutoWiringEnabled;
    private final BeanScanning scanning;
    private final Module containerModule = new ContainerModule();
    private final Module defaultsModule = new DefaultsModule();
    private LoggerManager loggerManager = new ConsoleLoggerManager();
    private Logger logger;
    private boolean disposing;

    static {
        System.setProperty("guice.disable.misplaced.annotation.check", "true");
        NO_CUSTOM_MODULES = new Module[0];
    }

    public DefaultPlexusContainer() throws PlexusContainerException {
        this(new DefaultContainerConfiguration());
    }

    public DefaultPlexusContainer(ContainerConfiguration configuration2) throws PlexusContainerException {
        this(configuration2, NO_CUSTOM_MODULES);
    }

    public DefaultPlexusContainer(ContainerConfiguration configuration2, Module ... customModules) throws PlexusContainerException {
        URL plexusXml = this.lookupPlexusXml(configuration2);
        this.context = DefaultPlexusContainer.getContextComponent(configuration2);
        this.context.put("plexus", this);
        this.variables = new ContextMapAdapter(this.context);
        this.containerRealm = DefaultPlexusContainer.lookupContainerRealm(configuration2);
        this.classRealmManager = new ClassRealmManager(this.qualifiedBeanLocator);
        this.containerRealm.getWorld().addListener(this.classRealmManager);
        this.componentVisibility = configuration2.getComponentVisibility();
        this.isAutoWiringEnabled = configuration2.getAutoWiring();
        this.scanning = DefaultPlexusContainer.parseScanningOption(configuration2.getClassPathScanning());
        this.plexusBeanLocator = new DefaultPlexusBeanLocator(this.qualifiedBeanLocator, this.componentVisibility);
        LifecycleManager jsr250Lifecycle = configuration2.getJSR250Lifecycle() ? new LifecycleManager() : null;
        this.plexusBeanManager = new PlexusLifecycleManager(Providers.of(this.context), this.loggerManagerProvider, new SLF4JLoggerFactoryProvider(), jsr250Lifecycle);
        this.setLookupRealm(this.containerRealm);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        URLClassSpace space = new URLClassSpace(this.containerRealm);
        beanModules.add(new PlexusXmlBeanModule(space, this.variables, plexusXml));
        BeanScanning global = BeanScanning.INDEX == this.scanning ? BeanScanning.GLOBAL_INDEX : this.scanning;
        beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, global));
        try {
            this.addPlexusInjector(beanModules, new BootModule(customModules));
        }
        catch (RuntimeException e) {
            try {
                this.dispose();
            }
            catch (Throwable throwable) {}
            throw e;
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Object lookup(String role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public Object lookup(String role, String hint) throws ComponentLookupException {
        return this.lookup(null, role, hint);
    }

    @Override
    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.lookup(role, null, hint);
    }

    @Override
    public <T> T lookup(Class<T> type2, String role, String hint) throws ComponentLookupException {
        try {
            return (T)this.locate(role, type2, hint).iterator().next().getValue();
        }
        catch (RuntimeException e) {
            throw new ComponentLookupException(e, type2 != null ? type2.getName() : role, hint);
        }
    }

    @Override
    public List<Object> lookupList(String role) throws ComponentLookupException {
        return new EntryListAdapter<Object>(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        return new EntryListAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return new EntryMapAdapter<String, Object>(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        return new EntryMapAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public boolean hasComponent(String role) {
        return this.hasComponent(role, "");
    }

    @Override
    public boolean hasComponent(String role, String hint) {
        return this.hasComponent((Class)null, role, hint);
    }

    public boolean hasComponent(Class role) {
        return this.hasComponent(role, "");
    }

    public boolean hasComponent(Class role, String hint) {
        return this.hasComponent(role, (String)null, hint);
    }

    public boolean hasComponent(Class type2, String role, String hint) {
        return DefaultPlexusContainer.hasPlexusBeans(this.locate(role, type2, hint));
    }

    @Override
    public void addComponent(Object component, String role) {
        try {
            this.addComponent(component, component.getClass().getClassLoader().loadClass(role), "default");
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(role, e);
        }
    }

    @Override
    public <T> void addComponent(final T component, final Class<?> role, final String hint) {
        this.qualifiedBeanLocator.add(Guice.createInjector(new Module(){

            @Override
            public void configure(Binder binder) {
                if (Hints.isDefaultHint(hint)) {
                    binder.bind(role).toInstance(component);
                } else {
                    binder.bind(role).annotatedWith(Names.named(hint)).toInstance(component);
                }
            }
        }), this.plexusRank.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addComponentDescriptor(ComponentDescriptor<T> descriptor2) {
        ClassRealm realm = descriptor2.getRealm();
        if (realm == null) {
            realm = this.containerRealm;
            descriptor2.setRealm(realm);
        }
        Map<ClassRealm, List<ComponentDescriptor<?>>> map2 = this.descriptorMap;
        synchronized (map2) {
            List<ComponentDescriptor<?>> descriptors = this.descriptorMap.get(realm);
            if (descriptors == null) {
                descriptors = new ArrayList();
                this.descriptorMap.put(realm, descriptors);
            }
            descriptors.add(descriptor2);
        }
        if (this.containerRealm == realm) {
            this.discoverComponents(this.containerRealm);
        }
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role, String hint) {
        return this.getComponentDescriptor(null, role, hint);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type2, String role, String hint) {
        PlexusBean<T> bean;
        Iterator<PlexusBean<T>> i = this.locate(role, type2, hint).iterator();
        if (i.hasNext() && (bean = i.next()).getImplementationClass() != null) {
            return DefaultPlexusContainer.newComponentDescriptor(role, bean);
        }
        return null;
    }

    public List getComponentDescriptorList(String role) {
        return this.getComponentDescriptorList(null, role);
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type2, String role) {
        ArrayList<ComponentDescriptor<T>> tempList = new ArrayList<ComponentDescriptor<T>>();
        for (PlexusBean<T> bean : this.locate(role, type2, new String[0])) {
            tempList.add(DefaultPlexusContainer.newComponentDescriptor(role, bean));
        }
        return tempList;
    }

    public Map getComponentDescriptorMap(String role) {
        return this.getComponentDescriptorMap(null, role);
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type2, String role) {
        LinkedHashMap<String, ComponentDescriptor<T>> tempMap = new LinkedHashMap<String, ComponentDescriptor<T>>();
        for (PlexusBean<T> bean : this.locate(role, type2, new String[0])) {
            tempMap.put((String)bean.getKey(), DefaultPlexusContainer.newComponentDescriptor(role, bean));
        }
        return tempMap;
    }

    @Override
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm) {
        return this.discoverComponents(realm, NO_CUSTOM_MODULES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm, Module ... customModules) {
        try {
            ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
            Map<ClassRealm, List<ComponentDescriptor<?>>> map2 = this.descriptorMap;
            synchronized (map2) {
                URLClassSpace space = new URLClassSpace(realm);
                List<ComponentDescriptor<?>> descriptors = this.descriptorMap.remove(realm);
                if (descriptors != null) {
                    beanModules.add(new ComponentDescriptorBeanModule(space, descriptors));
                }
                if (this.containerRealm != realm && !this.classRealmManager.isManaged(realm)) {
                    beanModules.add(new PlexusXmlBeanModule(space, this.variables));
                    BeanScanning local = BeanScanning.GLOBAL_INDEX == this.scanning ? BeanScanning.INDEX : this.scanning;
                    beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, local));
                }
            }
            if (!beanModules.isEmpty()) {
                this.classRealmManager.manage(realm, this.addPlexusInjector(beanModules, customModules));
            }
        }
        catch (RuntimeException e) {
            this.getLogger().warn(realm.toString(), e);
        }
        return null;
    }

    public Injector addPlexusInjector(List<? extends PlexusBeanModule> beanModules, Module ... customModules) {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(this.containerModule);
        Collections.addAll(modules, customModules);
        modules.add(new PlexusBindingModule(this.plexusBeanManager, beanModules));
        modules.add(this.defaultsModule);
        return Guice.createInjector(this.isAutoWiringEnabled ? new WireModule(modules) : new MergedModule(modules));
    }

    @Override
    public ClassWorld getClassWorld() {
        return this.containerRealm.getWorld();
    }

    @Override
    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    @Override
    public ClassRealm setLookupRealm(ClassRealm realm) {
        ClassRealm oldRealm = this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    @Override
    public ClassRealm getLookupRealm() {
        return this.lookupRealm.get();
    }

    @Override
    public ClassRealm createChildRealm(String id) {
        try {
            return this.containerRealm.createChildRealm(id);
        }
        catch (DuplicateRealmException duplicateRealmException) {
            try {
                return this.getClassWorld().getRealm(id);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                return null;
            }
        }
    }

    @Override
    public synchronized LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    @Override
    @Inject(optional=true)
    public synchronized void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager != null ? loggerManager : new ConsoleLoggerManager();
        this.logger = null;
    }

    @Override
    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.loggerManager.getLoggerForComponent(PlexusContainer.class.getName(), null);
        }
        return this.logger;
    }

    @Override
    public void release(Object component) {
        this.plexusBeanManager.unmanage(component);
    }

    @Override
    public void releaseAll(Map<String, ?> components2) {
        for (Object o : components2.values()) {
            this.release(o);
        }
    }

    @Override
    public void releaseAll(List<?> components2) {
        for (Object o : components2) {
            this.release(o);
        }
    }

    @Override
    public void dispose() {
        this.disposing = true;
        this.plexusBeanManager.unmanage();
        this.containerRealm.setParentRealm(null);
        this.qualifiedBeanLocator.clear();
        this.lookupRealm.remove();
        this.containerRealm.getWorld().removeListener(this.classRealmManager);
    }

    private static BeanScanning parseScanningOption(String scanning) {
        BeanScanning[] beanScanningArray = BeanScanning.values();
        int n = beanScanningArray.length;
        int n2 = 0;
        while (n2 < n) {
            BeanScanning option = beanScanningArray[n2];
            if (option.name().equalsIgnoreCase(scanning)) {
                return option;
            }
            ++n2;
        }
        return BeanScanning.OFF;
    }

    private static ClassRealm lookupContainerRealm(ContainerConfiguration configuration2) throws PlexusContainerException {
        ClassRealm realm;
        block5: {
            realm = configuration2.getRealm();
            if (realm == null) {
                ClassWorld world = configuration2.getClassWorld();
                if (world == null) {
                    world = new ClassWorld(DEFAULT_REALM_NAME, Thread.currentThread().getContextClassLoader());
                }
                try {
                    realm = world.getRealm(DEFAULT_REALM_NAME);
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    Iterator<ClassRealm> realmIterator = world.getRealms().iterator();
                    if (!realmIterator.hasNext()) break block5;
                    realm = realmIterator.next();
                }
            }
        }
        if (realm == null) {
            throw new PlexusContainerException("Missing container class realm: plexus.core");
        }
        return realm;
    }

    private URL lookupPlexusXml(ContainerConfiguration configuration2) {
        String configurationPath;
        URL url = configuration2.getContainerConfigurationURL();
        if (url == null && (configurationPath = configuration2.getContainerConfiguration()) != null) {
            File file2;
            int index2 = 0;
            while (index2 < configurationPath.length() && configurationPath.charAt(index2) == '/') {
                ++index2;
            }
            url = this.getClass().getClassLoader().getResource(configurationPath.substring(index2));
            if (url == null && (file2 = new File(configurationPath)).isFile()) {
                try {
                    url = file2.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (url == null) {
                this.getLogger().debug("Missing container configuration: " + configurationPath);
            }
        }
        return url;
    }

    private static Context getContextComponent(ContainerConfiguration configuration2) {
        Map<Object, Object> contextData = configuration2.getContext();
        Context contextComponent = configuration2.getContextComponent();
        if (contextComponent == null) {
            return new DefaultContext(contextData);
        }
        if (contextData != null) {
            for (Map.Entry<Object, Object> entry : contextData.entrySet()) {
                contextComponent.put(entry.getKey(), entry.getValue());
            }
        }
        return contextComponent;
    }

    private <T> Iterable<PlexusBean<T>> locate(String role, Class<T> type2, String ... hints) {
        if (this.disposing) {
            return Collections.EMPTY_SET;
        }
        String[] canonicalHints = Hints.canonicalHints(hints);
        if (role == null || type2 != null && type2.getName().equals(role)) {
            return this.plexusBeanLocator.locate(TypeLiteral.get(type2), canonicalHints);
        }
        HashSet candidates2 = new HashSet();
        for (ClassRealm realm : this.getVisibleRealms()) {
            try {
                Iterable<PlexusBean<T>> beans;
                Class<?> clazz = realm.loadClass(role);
                if (!candidates2.add(clazz) || !DefaultPlexusContainer.hasPlexusBeans(beans = this.plexusBeanLocator.locate(TypeLiteral.get(clazz), canonicalHints))) continue;
                return beans;
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
        }
        return Collections.EMPTY_SET;
    }

    private Collection<ClassRealm> getVisibleRealms() {
        Set<String> realmNames;
        ClassRealm threadContextRealm;
        Object[] realms = this.getClassWorld().getRealms().toArray();
        LinkedHashSet<ClassRealm> visibleRealms = new LinkedHashSet<ClassRealm>(realms.length);
        ClassRealm currentLookupRealm = this.getLookupRealm();
        if (currentLookupRealm != null) {
            visibleRealms.add(currentLookupRealm);
        }
        if ((threadContextRealm = ClassRealmManager.contextRealm()) != null) {
            visibleRealms.add(threadContextRealm);
        }
        if ("realm".equalsIgnoreCase(this.componentVisibility) && (realmNames = ClassRealmManager.visibleRealmNames(threadContextRealm)) != null && realmNames.size() > 0) {
            int i = realms.length - 1;
            while (i >= 0) {
                ClassRealm r = (ClassRealm)realms[i];
                if (realmNames.contains(r.toString())) {
                    visibleRealms.add(r);
                }
                --i;
            }
            return visibleRealms;
        }
        int i = realms.length - 1;
        while (i >= 0) {
            visibleRealms.add((ClassRealm)realms[i]);
            --i;
        }
        return visibleRealms;
    }

    private static <T> boolean hasPlexusBeans(Iterable<PlexusBean<T>> beans) {
        Iterator<PlexusBean<T>> i = beans.iterator();
        return i.hasNext() && i.next().getImplementationClass() != null;
    }

    private static <T> ComponentDescriptor<T> newComponentDescriptor(String role, PlexusBean<T> bean) {
        ComponentDescriptor cd = new ComponentDescriptor();
        cd.setRole(role);
        cd.setRoleHint((String)bean.getKey());
        cd.setImplementationClass(bean.getImplementationClass());
        cd.setDescription(bean.getDescription());
        return cd;
    }

    final class BootModule
    implements Module {
        private final Module[] customBootModules;

        BootModule(Module[] customBootModules) {
            this.customBootModules = customBootModules;
        }

        @Override
        public void configure(Binder binder) {
            binder.requestInjection(DefaultPlexusContainer.this);
            Module[] moduleArray = this.customBootModules;
            int n = this.customBootModules.length;
            int n2 = 0;
            while (n2 < n) {
                Module m = moduleArray[n2];
                binder.install(m);
                ++n2;
            }
        }
    }

    final class ContainerModule
    implements Module {
        ContainerModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(Context.class).toInstance(DefaultPlexusContainer.this.context);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(DefaultPlexusContainer.this.context.getContextData());
            binder.bind(MutableBeanLocator.class).toInstance(DefaultPlexusContainer.this.qualifiedBeanLocator);
            binder.bind(PlexusBeanLocator.class).toInstance(DefaultPlexusContainer.this.plexusBeanLocator);
            binder.bind(BeanManager.class).toInstance(DefaultPlexusContainer.this.plexusBeanManager);
            binder.bind(PlexusContainer.class).to(MutablePlexusContainer.class);
            binder.bind(MutablePlexusContainer.class).to(DefaultPlexusContainer.class);
            binder.bind(DefaultPlexusContainer.class).toProvider(Providers.of(DefaultPlexusContainer.this));
        }
    }

    final class DefaultsModule
    implements Module {
        private final LoggerProvider loggerProvider;
        private final PlexusDateTypeConverter dateConverter;

        DefaultsModule() {
            this.loggerProvider = new LoggerProvider();
            this.dateConverter = new PlexusDateTypeConverter();
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(LoggerManager.class).toProvider(DefaultPlexusContainer.this.loggerManagerProvider);
            binder.bind(Logger.class).toProvider(this.loggerProvider);
            Key<RankingFunction> plexusRankingKey = Key.get(RankingFunction.class, (Annotation)Names.named("plexus"));
            binder.bind(plexusRankingKey).toInstance(new DefaultRankingFunction(DefaultPlexusContainer.this.plexusRank.incrementAndGet()));
            binder.bind(RankingFunction.class).to(plexusRankingKey);
            binder.install(this.dateConverter);
            binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        }
    }

    final class LoggerManagerProvider
    implements DeferredProvider<LoggerManager> {
        LoggerManagerProvider() {
        }

        @Override
        public LoggerManager get() {
            return DefaultPlexusContainer.this.getLoggerManager();
        }

        @Override
        public DeferredClass<LoggerManager> getImplementationClass() {
            return new LoadedClass<LoggerManager>(this.get().getClass());
        }
    }

    final class LoggerProvider
    implements DeferredProvider<Logger> {
        LoggerProvider() {
        }

        @Override
        public Logger get() {
            return DefaultPlexusContainer.this.getLogger();
        }

        @Override
        public DeferredClass<Logger> getImplementationClass() {
            return new LoadedClass<Logger>(this.get().getClass());
        }
    }

    final class SLF4JLoggerFactoryProvider
    implements Provider<Object> {
        SLF4JLoggerFactoryProvider() {
        }

        @Override
        public Object get() {
            return DefaultPlexusContainer.this.plexusBeanLocator.locate(TypeLiteral.get(ILoggerFactory.class), new String[0]).iterator().next().getValue();
        }
    }
}

