/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.events;

import java.io.File;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.WagonEvent;
import org.apache.maven.wagon.resource.Resource;

public class TransferEvent
extends WagonEvent {
    public static final int TRANSFER_INITIATED = 0;
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    private Resource resource;
    private int eventType;
    private int requestType;
    private Exception exception;
    private File localFile;

    public TransferEvent(Wagon wagon, Resource resource, int eventType, int requestType) {
        super(wagon);
        this.resource = resource;
        this.setEventType(eventType);
        this.setRequestType(requestType);
    }

    public TransferEvent(Wagon wagon, Resource resource, Exception exception, int requestType) {
        this(wagon, resource, 4, requestType);
        this.exception = exception;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        switch (requestType) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + requestType);
            }
        }
        this.requestType = requestType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal event type: " + eventType);
            }
        }
        this.eventType = eventType;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TransferEvent[");
        switch (this.getRequestType()) {
            case 5: {
                sb.append("GET");
                break;
            }
            case 6: {
                sb.append("PUT");
                break;
            }
            default: {
                sb.append(this.getRequestType());
            }
        }
        sb.append("|");
        switch (this.getEventType()) {
            case 2: {
                sb.append("COMPLETED");
                break;
            }
            case 4: {
                sb.append("ERROR");
                break;
            }
            case 0: {
                sb.append("INITIATED");
                break;
            }
            case 3: {
                sb.append("PROGRESS");
                break;
            }
            case 1: {
                sb.append("STARTED");
                break;
            }
            default: {
                sb.append(this.getEventType());
            }
        }
        sb.append("|");
        sb.append(this.getWagon().getRepository()).append("|");
        sb.append(this.getLocalFile()).append("|");
        sb.append(this.getResource().inspect());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.eventType;
        result2 = 31 * result2 + (this.exception == null ? 0 : this.exception.hashCode());
        result2 = 31 * result2 + (this.localFile == null ? 0 : this.localFile.hashCode());
        result2 = 31 * result2 + this.requestType;
        result2 = 31 * result2 + (this.resource == null ? 0 : this.resource.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransferEvent other = (TransferEvent)obj;
        if (this.eventType != other.eventType) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.getClass().equals(other.exception.getClass())) {
            return false;
        }
        if (this.requestType != other.requestType) {
            return false;
        }
        if (this.resource == null) {
            if (other.resource != null) {
                return false;
            }
        } else {
            if (!this.resource.equals(other.resource)) {
                return false;
            }
            if (!this.source.equals(other.source)) {
                return false;
            }
        }
        return true;
    }
}

