/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.building;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.building.Problem;

public class ToolchainsBuildingException
extends Exception {
    private final List<Problem> problems = new ArrayList<Problem>();

    public ToolchainsBuildingException(List<Problem> problems) {
        super(ToolchainsBuildingException.toMessage(problems));
        if (problems != null) {
            this.problems.addAll(problems);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    private static String toMessage(List<Problem> problems) {
        StringWriter buffer = new StringWriter(1024);
        PrintWriter writer = new PrintWriter(buffer);
        writer.print(problems.size());
        writer.print(problems.size() == 1 ? " problem was " : " problems were ");
        writer.print("encountered while building the effective toolchains");
        writer.println();
        for (Problem problem : problems) {
            writer.print("[");
            writer.print((Object)problem.getSeverity());
            writer.print("] ");
            writer.print(problem.getMessage());
            String location2 = problem.getLocation();
            if (!location2.isEmpty()) {
                writer.print(" @ ");
                writer.print(location2);
            }
            writer.println();
        }
        return buffer.toString();
    }
}

