/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class Contributor
implements Serializable,
Cloneable,
InputLocationTracker {
    private String name;
    private String email;
    private String url;
    private String organization;
    private String organizationUrl;
    private List<String> roles;
    private String timezone;
    private Properties properties;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation nameLocation;
    private InputLocation emailLocation;
    private InputLocation urlLocation;
    private InputLocation organizationLocation;
    private InputLocation organizationUrlLocation;
    private InputLocation rolesLocation;
    private InputLocation timezoneLocation;
    private InputLocation propertiesLocation;

    public void addProperty(String key, String value2) {
        this.getProperties().put(key, value2);
    }

    public void addRole(String string2) {
        this.getRoles().add(string2);
    }

    public Contributor clone() {
        try {
            Contributor copy2 = (Contributor)super.clone();
            if (this.roles != null) {
                copy2.roles = new ArrayList<String>();
                copy2.roles.addAll(this.roles);
            }
            if (this.properties != null) {
                copy2.properties = (Properties)this.properties.clone();
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "name": {
                    return this.nameLocation;
                }
                case "email": {
                    return this.emailLocation;
                }
                case "url": {
                    return this.urlLocation;
                }
                case "organization": {
                    return this.organizationLocation;
                }
                case "organizationUrl": {
                    return this.organizationUrlLocation;
                }
                case "roles": {
                    return this.rolesLocation;
                }
                case "timezone": {
                    return this.timezoneLocation;
                }
                case "properties": {
                    return this.propertiesLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public String getName() {
        return this.name;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    @Override
    public void setLocation(Object key, InputLocation location2) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    this.location = location2;
                    return;
                }
                case "name": {
                    this.nameLocation = location2;
                    return;
                }
                case "email": {
                    this.emailLocation = location2;
                    return;
                }
                case "url": {
                    this.urlLocation = location2;
                    return;
                }
                case "organization": {
                    this.organizationLocation = location2;
                    return;
                }
                case "organizationUrl": {
                    this.organizationUrlLocation = location2;
                    return;
                }
                case "roles": {
                    this.rolesLocation = location2;
                    return;
                }
                case "timezone": {
                    this.timezoneLocation = location2;
                    return;
                }
                case "properties": {
                    this.propertiesLocation = location2;
                    return;
                }
            }
            this.setOtherLocation(key, location2);
            return;
        }
        this.setOtherLocation(key, location2);
    }

    public void setOtherLocation(Object key, InputLocation location2) {
        if (location2 != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location2);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public List<String> getRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        return this.roles;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getUrl() {
        return this.url;
    }

    public void removeRole(String string2) {
        this.getRoles().remove(string2);
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
    }

    public void setProperties(Properties properties2) {
        this.properties = properties2;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

